//
//  ManageCustomerAPI.swift
//  EPOS
//
//  Created by Tushar Premal on 11/01/23.
//

import Foundation

class ManageCustomer:NSObject{
    
    static let shared = ManageCustomer()
    
    private override init() {
        
    }
    
    var isProcessIsRunning = false
    var arrCustomers = [CustomerModel]()
    var arrVouchers = [VoucherModel]()
    
    @objc func fetchOfflineCustoemr(){
        if isProcessIsRunning && !Reachabilities.shared.isConnectedToNetwork(){
            return
        }
        NSObject.cancelPreviousPerformRequests(withTarget: self)
        arrCustomers = CoreDataHelper.shared.fetchOfflineCustomers()
        self.CallUploadCustokmerAPI()
    }
    
    func fetchOfflineVoucher(){
        arrVouchers = SQLiteManage.FetchUpdatedVouchers()
        self.CallCreateVoucher()
    }
    
    func CallUploadCustokmerAPI(){
        if let customer = arrCustomers.first{
            isProcessIsRunning = true
            var dictParam = [String:Any]()
            var strURL = AppConstants.APIURL.kCustomer
            if customer.offline == 0{
                strURL = "\(AppConstants.APIURL.kCustomer)\(customer.id ?? 0)"
            }
            dictParam["name"] = customer.name ?? ""
            dictParam["mobile"] = customer.mobile ?? ""
            dictParam["email"] = customer.email ?? ""
            dictParam["house_no"] = customer.houseNo ?? ""
            dictParam["street"] = customer.street ?? ""
            dictParam["city"] = customer.city ?? ""
            dictParam["postcode"] = customer.postcode ?? ""
            dictParam["distance"] = customer.distance ?? 0
            dictParam["unique_id"] = customer.uniqueId
            WebServiceManager().requestAPI(params: dictParam, urlString: strURL, method: "POST") { (message, result) in
                DispatchQueue.main.async {
                    if let response = result as? NSDictionary{
                        let jsonDecoder = JSONDecoder()
                        if let data = AppCommonMethods.convertToJson(object: response), let aData = try? jsonDecoder.decode(CustomerModel.self, from: data){
                            aData.offline = 0
                            CoreDataHelper.shared.saveAndUpdateCusomer(customer: aData, offline: 0, updated: 0, isFromUpload: true)
                        }
                    }
                    self.arrCustomers.removeFirst()
                    self.CallUploadCustokmerAPI()
                }
            }
        }else{
            fetchOfflineVoucher()
        }
    }
    
    func CallCreateVoucher(){
        if let voucher = arrVouchers.first{
            var dictParam = [String:Any]()
            let dictCustomer = NSMutableDictionary()
            if voucher.customer == nil{
                dictParam["customer_id"] = ""
                dictCustomer["id"] = ""
            }else{
                if voucher.customer?.offline ?? 1 == 0{
                    dictCustomer["id"] = voucher.customer?.id ?? 0
                    dictParam["customer_id"] = voucher.customer?.id ?? 0
                }else{
                    dictParam["customer_id"] = ""
                    dictCustomer["id"] = ""
                }
            }
            dictCustomer["name"] = voucher.customer?.name ?? ""
            dictCustomer["mobile"] = voucher.customer?.mobile ?? ""
            dictCustomer["email"] = voucher.customer?.email ?? ""
            dictCustomer["unique_id"] = voucher.customer?.uniqueId ?? ""
            dictParam["customer"] = AppCommonMethods.convertJsontoString(json: dictCustomer)
            dictParam["week_day"] = voucher.weekDay ?? ""
            dictParam["order_type_id"] = voucher.orderTypeId ?? ""
            dictParam["voucher_code"] = voucher.voucherCode ?? ""
            dictParam["voucher_amount"] = voucher.voucherAmount ?? 0
            dictParam["minimum_order_value"] = voucher.minimumOrderValue ?? 0
            dictParam["start_date"] = voucher.startDate ?? ""
            dictParam["end_date"] = voucher.endDate
            dictParam["unique_id"] = voucher.uniqueId
            
            var strURL = AppConstants.APIURL.kVoucher
            if voucher.offline == 0{
                strURL = "\(AppConstants.APIURL.kVoucher)\(voucher.id ?? 0)"
            }
//            AppCommonMethods.startProgressBar()
            WebServiceManager().requestAPI(params: dictParam, urlString: strURL, method: "POST") { (message, result) in
                DispatchQueue.main.async {
                    if let response = result as? NSDictionary{
                        let jsonDecoder = JSONDecoder()
                        if let data = AppCommonMethods.convertToJson(object: response), let aData = try? jsonDecoder.decode(VoucherModel.self, from: data){
                            aData.offline = 0
                            aData.updated = 0
                            if voucher.offline == 1{
                                SQLiteManage.insertVouchers(arrVouchers: [aData])
                            }else{
                                SQLiteManage.insertVouchers(arrVouchers: [aData])
                            }
                            return
                        }
                    }
                    self.CallCreateVoucher()
                }
            }
        }else{
            isProcessIsRunning = false
            self.perform(#selector(fetchOfflineCustoemr), with: nil, afterDelay: 60)
        }
    }
}
