//
//  CoreDataHelper.swift
//  EPOS
//
//  Created by Apple on 09/04/21.
//

import Foundation
import CoreData
import UIKit

class CoreDataHelper:NSObject {
    
    static let shared = CoreDataHelper()
    var context:NSManagedObjectContext!
    
    //MARK: Database Operations
    private override init() {
        context = AppConstants.appDelegate.persistentContainer.viewContext
        context.retainsRegisteredObjects = true
        context.mergePolicy = NSMergeByPropertyObjectTrumpMergePolicy
        if AppConstants.isInDevlopmentMode{
            let documentDirectoryURL =  try? FileManager.default.url(for: .documentDirectory, in: .userDomainMask, appropriateFor: nil, create: true)
            print("Database Path:",documentDirectoryURL?.absoluteString ?? "")
        }
    }
    
    func fetchDataFromDatabase(entity:String, predict:NSPredicate? = nil, sortKey:String? = nil, ascending:Bool = false, limit:Int? = nil, offset:Int? = nil)->[Any]?{
        let fReq: NSFetchRequest = NSFetchRequest<NSFetchRequestResult>(entityName: entity)
        if predict != nil{
            fReq.predicate = predict
        }
        if sortKey != nil{
            let sorter: NSSortDescriptor = NSSortDescriptor(key: "\(sortKey!)" , ascending: ascending)
            fReq.sortDescriptors = [sorter]
        }
        if limit != nil{
            fReq.fetchLimit = limit!
        }
        if offset != nil{
            fReq.fetchOffset = offset!
        }
        
        fReq.returnsObjectsAsFaults = false
        do{
            return try context.fetch(fReq)
        }catch let error{
            print(error.localizedDescription)
        }
        return nil
    }
    
    func deleteDataFromDatabase(entity:String, predict:NSPredicate? = nil){
        let fReq: NSFetchRequest = NSFetchRequest<NSFetchRequestResult>(entityName: entity)
        if predict != nil{
            fReq.predicate = predict
        }
        do{
            let req = NSBatchDeleteRequest.init(fetchRequest: fReq)
            try context.execute(req)
            try context.save()
        }catch let error{
            print(error.localizedDescription)
        }
    }
    
    func numberOfRowOfEntity(name:String, predict:NSPredicate? = nil)->Int?{
        let fReq: NSFetchRequest = NSFetchRequest<NSFetchRequestResult>(entityName: name)
        if predict != nil{
            fReq.predicate = predict
        }
        do{
            return try context.count(for: fReq)
        }catch let error{
            print(error.localizedDescription)
        }
        return nil
    }
    
    //MARK: Fetch Data From Database
    func fetchOfflineReservationsData()->ReservationModel?{
        let predicate = NSPredicate.init(format: "is_update == 1 AND is_delete == 0 AND business_id == %d", AppConstants.businessData?.id ?? 0)
        if let result = fetchDataFromDatabase(entity: "Reservations", predict: predicate, limit: 1) as? [NSManagedObject], let data = result.first{
            return ReservationModel.init(data)
        }
        return nil
    }
    
    func fetchDeletedReservationsData()->ReservationModel?{
        let predicate = NSPredicate.init(format: "is_delete == 1 AND business_id == %d AND offline == 0", AppConstants.businessData?.id ?? 0)
        if let result = fetchDataFromDatabase(entity: "Reservations", predict: predicate, limit: 1) as? [NSManagedObject], let data = result.first{
            return ReservationModel.init(data)
        }
        return nil
    }
    
    func fetchFloorData()->[FloorModel]{
        if let result = fetchDataFromDatabase(entity: "Floor",predict: NSPredicate.init(format: "total_tables != 0"), sortKey: "sequence", ascending: true) as? [NSManagedObject]{
            var arrFloor = [FloorModel]()
            result.forEach { (floor) in
                arrFloor.append(FloorModel.init(floor))
            }
            return arrFloor
        }
        return [FloorModel]()
    }
    
    func fetchReservationData(fromDate:Date? = nil,toDate:Date? = nil, onlyRunning:Bool = false)->[ReservationModel]{
        var strPredicate = String(format: "reservation_date_time != 0 AND business_id == %d AND is_delete == 0",AppConstants.businessData?.id ?? 0)
        if fromDate != nil && toDate != nil{
            strPredicate = String(format: "reservation_date_time >= %ld AND reservation_date_time < %ld AND business_id == %d AND is_delete == 0", Int(fromDate!.timeIntervalSince1970), Int(toDate!.timeIntervalSince1970),AppConstants.businessData?.id ?? 0)
        }
        if onlyRunning{
            strPredicate.append(" AND reservation_status_id == 1")
        }
        let predicate = NSPredicate.init(format: strPredicate)
        var arrReservation = [ReservationModel]()
        if let result = fetchDataFromDatabase(entity: "Reservations",predict: predicate) as? [NSManagedObject]{
            result.forEach { (type) in
                arrReservation.append(ReservationModel.init(type))
            }
        }
        return arrReservation
    }
    
    func fetchPagedReservationData(fromDate:Date, toDate:Date, offset:Int)->[ReservationModel]{
        let strPredicate = String(format: "reservation_date_time >= %ld AND reservation_date_time < %ld AND business_id == %d AND is_delete == 0", Int(fromDate.timeIntervalSince1970), Int(toDate.timeIntervalSince1970), AppConstants.businessData?.id ?? 0)
        let predicate = NSPredicate.init(format: strPredicate)
        var arrReservation = [ReservationModel]()
        if let result = fetchDataFromDatabase(entity: "Reservations", predict: predicate, offset: offset) as? [NSManagedObject]{
            result.forEach { (type) in
                arrReservation.append(ReservationModel.init(type))
            }
        }
        return arrReservation
    }
    
    func fetchDepositTypeData()->[DepositTypeModel]{
        var arrType = [DepositTypeModel]()
        if let result = fetchDataFromDatabase(entity: "DepositTypes") as? [NSManagedObject]{
            result.forEach { (type) in
                arrType.append(DepositTypeModel.init(type))
            }
        }
        return arrType
    }
    
    func fetchCategoryData(orderTypeId:Int, isBanquet:Bool)->[CategoryModel]{
        var predicate = NSPredicate.init(format: "disabled == 0 AND parent_id == 0 AND (is_collection == nil OR is_collection == 1)")
        if orderTypeId == 1{
            predicate = NSPredicate.init(format: "disabled == 0 AND parent_id == 0 AND (is_dinein == nil OR is_dinein == 1)")
        }else if orderTypeId == 3{
            predicate = NSPredicate.init(format: "disabled == 0 AND parent_id == 0 AND (is_delivery == nil OR is_delivery == 1)")
        }
        if isBanquet{
            predicate = NSPredicate.init(format: "disabled == 0 AND parent_id == 0 AND (is_banquet == nil OR is_banquet == 1)")
        }
        var arrCategory = [CategoryModel]()
        if let result = fetchDataFromDatabase(entity: "Category",predict: predicate) as? [NSManagedObject]{
            result.forEach { (category) in
                arrCategory.append(CategoryModel.init(category))
            }
        }
        return arrCategory
    }
    
    func fetchPrintBlockObject(categoryId:Int)->PrintBlockModel?{
        let predicate = NSPredicate.init(format: "id == %d AND disabled == 0",categoryId)
        if let result = fetchDataFromDatabase(entity: "Category",predict: predicate) as? [NSManagedObject], let data = result.first{
            let predicateBlock = NSPredicate.init(format: "id == %d",data.getIntValue("print_block_id") ?? 0)
            if let result = fetchDataFromDatabase(entity: "PrintBlock",predict: predicateBlock) as? [NSManagedObject], let block = result.first{
                return PrintBlockModel.init(block)
            }
        }
        return nil
    }
    
    func fetchChildCategoryData(parentId:Int, orderTypeId:Int, isBanquet:Bool)->[CategoryModel]{
        var predicate = NSPredicate.init(format: "disabled == 0 AND parent_id == %ld AND (is_collection == nil OR is_collection == 1)",parentId)
        if orderTypeId == 1{
            predicate = NSPredicate.init(format: "disabled == 0 AND parent_id == %ld AND (is_dinein == nil OR is_dinein == 1)",parentId)
        }else if orderTypeId == 3{
            predicate = NSPredicate.init(format: "disabled == 0 AND parent_id == %ld AND (is_delivery == nil OR is_delivery == 1)",parentId)
        }
        if isBanquet{
            predicate = NSPredicate.init(format: "disabled == 0 AND parent_id == %ld AND (is_banquet == nil OR is_banquet == 1)",parentId)
        }
        var arrCategory = [CategoryModel]()
        if let result = fetchDataFromDatabase(entity: "Category",predict: predicate) as? [NSManagedObject]{
            result.forEach { (category) in
                arrCategory.append(CategoryModel.init(category))
            }
        }
        return arrCategory
    }
    
    func fetchCategoryById(id:Int)->CategoryModel?{
        let predicate = NSPredicate.init(format: "id == %ld",id)
        if let result = fetchDataFromDatabase(entity: "Category",predict: predicate) as? [NSManagedObject], let data = result.first{
            return CategoryModel.init(data)
        }
        return nil
    }
    
    func fetchProductData(categoryId:Int, oderTypeId:Int,isBanquet:Bool = false)->[ProductModel]{
        var predicate = NSPredicate.init(format: "category_id == %ld AND disabled == 0 AND is_collection == 1", categoryId)
        if oderTypeId == 1{
            predicate = NSPredicate.init(format: "category_id == %ld AND disabled == 0 AND is_dinein == 1", categoryId)
        }else if oderTypeId == 3{
            predicate = NSPredicate.init(format: "category_id == %ld AND disabled == 0 AND is_delivery == 1", categoryId)
        }
        if isBanquet{
            predicate = NSPredicate.init(format: "category_id == %ld AND disabled == 0 AND is_banquet == 1", categoryId)
        }
        
        if let result = fetchDataFromDatabase(entity: "Product", predict: predicate) as? [NSManagedObject]{
            var arrProduct = [ProductModel]()
            result.forEach { (product) in
                arrProduct.append(ProductModel.init(product))
            }
            return arrProduct
        }
        return [ProductModel]()
    }
    
    func fetchSearchProductData(seachTerm:String,oderTypeId:Int,isBanquet:Bool = false)->[ProductModel]{
        var predicate = NSPredicate.init(format: "name CONTAINS[cd] %@ AND disabled == 0 AND is_collection == 1", seachTerm)
        if oderTypeId == 1{
            predicate = NSPredicate.init(format: "name CONTAINS[cd] %@ AND disabled == 0 AND is_dinein == 1", seachTerm)
        }else if oderTypeId == 3{
            predicate = NSPredicate.init(format: "name CONTAINS[cd] %@ AND disabled == 0 AND is_delivery == 1", seachTerm)
        }
        if isBanquet{
            predicate = NSPredicate.init(format: "name CONTAINS[cd] AND disabled == 0 AND is_banquet == 1", seachTerm)
        }
        
        if let result = fetchDataFromDatabase(entity: "Product", predict: predicate) as? [NSManagedObject]{
            var arrProduct = [ProductModel]()
            result.forEach { (product) in
                arrProduct.append(ProductModel.init(product))
            }
            return arrProduct
        }
        return [ProductModel]()
    }
    
    func fetchProductCount(categoryId:Int, oderTypeId:Int)->Int{
        var predicate = NSPredicate.init(format: "category_id == %ld AND disabled == 0 AND is_collection == 1", categoryId)
        if oderTypeId == 1{
            predicate = NSPredicate.init(format: "category_id == %ld AND disabled == 0 AND is_dinein == 1", categoryId)
        }else if oderTypeId == 3{
            predicate = NSPredicate.init(format: "category_id == %ld AND disabled == 0 AND is_delivery == 1", categoryId)
        }
        return numberOfRowOfEntity(name: "Product", predict: predicate) ?? 0
    }
    
    func fetchProductObejct(prodcutId:Int)->ProductModel?{
        let predicate = NSPredicate.init(format: "id == %ld AND disabled == 0", prodcutId)
        if let result = fetchDataFromDatabase(entity: "Product", predict: predicate, limit: 1) as? [NSManagedObject], let data = result.first{
            return ProductModel.init(data)
        }
        return nil
    }
    
    func fetchAddOnData(productId:Int, parnetId:Int? = nil)->[AddOnModel]{
        let predicate = NSPredicate.init(format: "product_id == %ld AND disabled == 0", productId)
        var arrAddOn = [AddOnModel]()
        if let result = fetchDataFromDatabase(entity: "ProductAddons", predict: predicate) as? [NSManagedObject]{
            result.forEach { addon in
                if let id = addon.value(forKey: "id") as? Int{
                    let childPredicate = NSPredicate.init(format: "id == %ld AND disabled == 0", id)
                    if let result = fetchDataFromDatabase(entity: "AddOns", predict: childPredicate, limit: 1) as? [NSManagedObject], let data = result.first{
                        let model = AddOnModel.init(data)
                        model.productId = productId
                        let arr = fetchChildAddon(parnetId: model.id ?? 0, productId: productId)
                        if arr.count > 0{
                            model.children = arr
                        }
                        model.minQuantity = addon.getIntValue("min_quantity")
                        model.maxQuantity = addon.getIntValue("max_quantity")
                        arrAddOn.append(model)
                    }
                }
            }
        }
        return arrAddOn
    }
    
    func fetchAddOnData(addonId:Int)->AddOnModel?{
        let predicate = NSPredicate.init(format: "id == %ld AND disabled == 0", addonId)
        if let arr = fetchDataFromDatabase(entity: "AddOns", predict: predicate) as? [NSManagedObject], let result = arr.first{
            return AddOnModel.init(result)
        }
        return nil
    }
    
    func fetchChildAddon(parnetId:Int, productId:Int)->[AddOnModel]{
        let predicate = NSPredicate.init(format: "parent_id == %ld AND disabled == 0", parnetId)
        
        if let result = fetchDataFromDatabase(entity: "AddOns", predict: predicate) as? [NSManagedObject]{
            var arrAddOn = [AddOnModel]()
            for addon in result{
                let model = AddOnModel.init(addon)
                let arr = fetchChildAddon(parnetId: model.id ?? 0, productId: productId)
                model.productId = productId
                if arr.count > 0{
                    model.children = arr
                }
                arrAddOn.append(model)
            }
            return arrAddOn
        }
        return [AddOnModel]()
    }
    
    func fetchIngredientData(productId:Int)->[IngredientModel]{
        let predicate = NSPredicate.init(format: "product_id == %ld AND disabled == 0", productId)
        if let result = fetchDataFromDatabase(entity: "Ingredients", predict: predicate) as? [NSManagedObject]{
            var arrIngredient = [IngredientModel]()
            result.forEach { (ingredient) in
                arrIngredient.append(IngredientModel.init(ingredient))
            }
            return arrIngredient
        }
        return [IngredientModel]()
    }
    
    
    func fetchIngredientDataFromId(id:Int)->IngredientModel?{
        let predicate = NSPredicate.init(format: "id == %ld AND disabled == 0", id)
        if let arrData = fetchDataFromDatabase(entity: "Ingredients", predict: predicate) as? [NSManagedObject], let result = arrData.first{
            return IngredientModel.init(result)
        }
        return nil
    }
    
    func fetchCustomerObect(id:Int)->CustomerModel?{
        let predicate = NSPredicate.init(format: "id == %ld", id)
        if let result = fetchDataFromDatabase(entity: "Customer", predict: predicate, limit: 1) as? [NSManagedObject], let data = result.first{
            return CustomerModel.init(data)
        }
        return nil
    }
    
    func fetchTableStatusData(id:Int? = nil, name:String? = nil)->[TableStatusModel]{
        var predicate:NSPredicate?
        if id != nil{
            predicate = NSPredicate.init(format: "id == %ld", id!)
        }
        if name != nil{
            predicate = NSPredicate.init(format: "status ==[c] %@", name!)
        }
        if let result = fetchDataFromDatabase(entity: "TableStatuses", predict: predicate) as? [NSManagedObject]{
            var arrStatus = [TableStatusModel]()
            result.forEach { (status) in
                arrStatus.append(TableStatusModel.init(status))
            }
            return arrStatus
        }
        return [TableStatusModel]()
    }
    
    func fetchCustomerData(name:String? = nil)->[CustomerModel]{
        var predicate = NSPredicate.init(format: "id != 0")
        if name != nil{
            predicate = NSPredicate.init(format: "(name CONTAINS[cd] %@ OR mobile CONTAINS[cd] %@) AND id != 0", name!, name!)
        }
        if let result = fetchDataFromDatabase(entity: "Customer", predict: predicate) as? [NSManagedObject]{
            var arrUser = [CustomerModel]()
            result.forEach { (user) in
                arrUser.append(CustomerModel.init(user))
            }
            return arrUser
        }
        return [CustomerModel]()
    }
    
    func fetchOfflineCustomers()->[CustomerModel]{
        let predicate = NSPredicate.init(format: "id != 0 AND is_updated == 1")
        if let result = fetchDataFromDatabase(entity: "Customer", predict: predicate) as? [NSManagedObject]{
            var arrUser = [CustomerModel]()
            result.forEach { (user) in
                arrUser.append(CustomerModel.init(user))
            }
            return arrUser
        }
        return [CustomerModel]()
    }
    
    func fetchPrepLocationData()->[PrepLocationModel]{
        let predicate = NSPredicate.init(format: "disabled == 0")
        if let result = fetchDataFromDatabase(entity: "PrepLocation",predict: predicate) as? [NSManagedObject]{
            var arrPrepLocation = [PrepLocationModel]()
            result.forEach { (prepLocation) in
                arrPrepLocation.append(PrepLocationModel.init(prepLocation))
            }
            return arrPrepLocation
        }
        return [PrepLocationModel]()
    }
    
    func fetchPrepLocationData(id:Int)->PrepLocationModel?{
        let predicate = NSPredicate.init(format: "id == %d AND disabled == 0",id)
        if let result = fetchDataFromDatabase(entity: "PrepLocation",predict: predicate) as? [NSManagedObject], let data = result.first{
            return PrepLocationModel.init(data)
        }
        return nil
    }
    
    func fetchPrintBlockModel()->[PrintBlockModel]{
        var arrBlock = [PrintBlockModel]()
        if let result = fetchDataFromDatabase(entity: "PrintBlock", sortKey: "sequence") as? [NSManagedObject]{
            result.forEach { (block) in
                arrBlock.append(PrintBlockModel.init(block))
            }
        }
        return arrBlock
    }
    
    //MARK: Save Data Into Database
    func savePrintBlockIntoDatabase(arrData:[PrintBlockModel]){
        for i in 0..<arrData.count{
            let model = arrData[i]
            AppCommonMethods.changeProgressMessage(msg: "Saving print blocks\n\(i+1)/\(arrData.count)")
            let blockEntry = NSEntityDescription.insertNewObject(forEntityName: "PrintBlock", into: self.context)
            blockEntry.setValue(model.id ?? 0, forKey: "id")
            blockEntry.setValue(model.name ?? "", forKey: "name")
            blockEntry.setValue(model.sequence ?? 0, forKey: "sequence")
            AppConstants.appDelegate.saveContext()
        }
    }
    
    func saveFloorIntoDatabase(arrData:[FloorModel]){
        for i in 0..<arrData.count{
            let model = arrData[i]
            AppCommonMethods.changeProgressMessage(msg: "Saving floors\n\(i+1)/\(arrData.count)")
            let floorEntry = NSEntityDescription.insertNewObject(forEntityName: "Floor", into: self.context)
            floorEntry.setValue(model.id ?? 0, forKey: "id")
            floorEntry.setValue(model.sequence ?? 0, forKey: "sequence")
            floorEntry.setValue(model.name ?? "", forKey: "name")
            floorEntry.setValue(model.totalTable ?? 0, forKey: "total_tables")
            AppConstants.appDelegate.saveContext()
            if model.tableData?.count ?? 0 > 0{
                SQLiteManage.insertTable(arrData: model.tableData!, floorId: model.id)
            }
        }
    }
    
    func saveDepositTypeIntoDatabase(arrData:[DepositTypeModel]){
        for i in 0..<arrData.count{
            let model = arrData[i]
            AppCommonMethods.changeProgressMessage(msg: "Saving deposit types\n\(i+1)/\(arrData.count)")
            let typeEntry = NSEntityDescription.insertNewObject(forEntityName: "DepositTypes", into: self.context)
            typeEntry.setValue(model.id ?? 0, forKey: "id")
            typeEntry.setValue(model.type ?? "", forKey: "type")
            AppConstants.appDelegate.saveContext()
        }
    }
    
    func saveTableStatusesIntoDatabase(arrData:[TableStatusModel]){
        for i in 0..<arrData.count{
            let model = arrData[i]
            AppCommonMethods.changeProgressMessage(msg: "Saving table status\n\(i+1)/\(arrData.count)")
            let tableEntry = NSEntityDescription.insertNewObject(forEntityName: "TableStatuses", into: self.context)
            tableEntry.setValue(model.id ?? 0, forKey: "id")
            tableEntry.setValue(model.bottomColor ?? "", forKey: "bottom_color")
            tableEntry.setValue(model.topColor ?? "", forKey: "top_color")
            tableEntry.setValue(model.status ?? "", forKey: "status")
            AppConstants.appDelegate.saveContext()
        }
    }
    
    func saveCategoryIntoDatabase(arrData:[CategoryModel]){
        for i in 0..<arrData.count{
            let model = arrData[i]
            AppCommonMethods.changeProgressMessage(msg: "Saving categories\n\(i+1)/\(arrData.count)")
            let categoryEntry = NSEntityDescription.insertNewObject(forEntityName: "Category", into: self.context)
            categoryEntry.setValue(model.id ?? 0, forKey: "id")
            categoryEntry.setValue(model.name ?? "", forKey: "name")
            categoryEntry.setValue(model.disabled ?? 0, forKey: "disabled")
            categoryEntry.setValue(model.parentId ?? 0, forKey: "parent_id")
            categoryEntry.setValue(model.topColor ?? "", forKey: "top_color")
            categoryEntry.setValue(model.bottomColor ?? "", forKey: "bottom_color")
            categoryEntry.setValue(model.fontColor ?? "", forKey: "font_color")
            categoryEntry.setValue(model.printBlock?.id ?? 0, forKey: "print_block_id")
            categoryEntry.setValue(model.isBanquet, forKey: "is_banquet")
            categoryEntry.setValue(model.isDelivery, forKey: "is_delivery")
            categoryEntry.setValue(model.isCollection, forKey: "is_collection")
            categoryEntry.setValue(model.isDineIn, forKey: "is_dinein")
            AppConstants.appDelegate.saveContext()
        }
    }

    func saveAndUpdateCusomer(customers:[CustomerModel], offline:Int, shouldUpdateLabel:Bool = false){
        for i in 0..<customers.count{
            if shouldUpdateLabel{
                AppCommonMethods.changeProgressMessage(msg: "Saving customers\n\(i+1)/\(customers.count)")
            }
            self.context.performAndWait {
                let customer = customers[i]
                var uniqueId = customer.uniqueId
                if uniqueId == ""{
                    uniqueId = "\(Int(Date().timeIntervalSinceReferenceDate))\(AppConstants.businessData?.id ?? 0)\(AppConstants.DeviceId)\(i)"
                }
                var userEntry = NSEntityDescription.insertNewObject(forEntityName: "Customer", into: self.context)
                let predicate = NSPredicate.init(format: "unique_id == %@", uniqueId)
                if let result = fetchDataFromDatabase(entity: "Customer", predict: predicate) as? [NSManagedObject], let data = result.first{
                    if data.getIntValue("is_updated") ?? 0 == 1{
                        return
                    }
                    userEntry = data
                }
                userEntry.setValue(customer.id ?? 0, forKey: "id")
                userEntry.setValue(customer.name ?? "", forKey: "name")
                userEntry.setValue(customer.mobile ?? "", forKey: "mobile")
                userEntry.setValue(customer.email ?? "", forKey: "email")
                userEntry.setValue(customer.city ?? "", forKey: "city")
                userEntry.setValue(customer.houseNo ?? "", forKey: "house_no")
                userEntry.setValue(customer.postcode ?? "", forKey: "postcode")
                userEntry.setValue(customer.street ?? "", forKey: "street")
                userEntry.setValue(customer.newsLetter ?? 0, forKey: "news_letter")
                if customer.distance ?? 0 != 0{
                    userEntry.setValue(customer.distance ?? 0, forKey: "distance")
                }
                userEntry.setValue(offline, forKey: "offline")
                userEntry.setValue(0, forKey: "is_updated")
                userEntry.setValue(uniqueId, forKey: "unique_id")
                
                AppConstants.appDelegate.saveContext()
            }
        }
    }
    
    func saveAndUpdateCusomer(customer:CustomerModel, offline:Int, updated:Int, isFromUpload:Bool = false){
        self.context.performAndWait {
            var id:Int?
            var userEntry = NSEntityDescription.insertNewObject(forEntityName: "Customer", into: self.context)
            let predicate = NSPredicate.init(format: "unique_id == %@", customer.uniqueId)
            if let result = fetchDataFromDatabase(entity: "Customer", predict: predicate) as? [NSManagedObject], let data = result.first{
                id = data.getIntValue("id")
                userEntry = data
            }
            userEntry.setValue(customer.id ?? 0, forKey: "id")
            userEntry.setValue(customer.name ?? "", forKey: "name")
            userEntry.setValue(customer.mobile ?? "", forKey: "mobile")
            userEntry.setValue(customer.email ?? "", forKey: "email")
            userEntry.setValue(customer.city ?? "", forKey: "city")
            userEntry.setValue(customer.houseNo ?? "", forKey: "house_no")
            userEntry.setValue(customer.postcode ?? "", forKey: "postcode")
            userEntry.setValue(customer.street ?? "", forKey: "street")
            userEntry.setValue(customer.newsLetter ?? 0, forKey: "news_letter")
            if customer.distance ?? 0 != 0{
                userEntry.setValue(customer.distance ?? 0, forKey: "distance")
            }
            userEntry.setValue(offline, forKey: "offline")
            userEntry.setValue(updated, forKey: "is_updated")
            userEntry.setValue(customer.uniqueId, forKey: "unique_id")
            AppConstants.appDelegate.saveContext()
            
            if isFromUpload && id != nil{
                if let arr = fetchDataFromDatabase(entity: "Reservations",predict: NSPredicate.init(format: "customer_id == %d AND is_delete == 0", id!)) as? [NSManagedObject]{
                    for object in arr{
                        object.setValue(customer.id ?? 0, forKey: "customer_id")
                        AppConstants.appDelegate.saveContext()
                    }
                }
                _ = SQLiteManage.ExecuteQuery("UPDATE Orders SET customer_id = \(customer.id ?? 0) WHERE customer_id = \(id!)")
                _ = SQLiteManage.ExecuteQuery("UPDATE Vouchers SET customer_id = \(customer.id ?? 0) WHERE customer_id = \(id!)")
            }
        }
    }
    
    func saveProductIntoDatabase(arrData:[ProductModel]){
        for i in 0..<arrData.count{
            AppCommonMethods.changeProgressMessage(msg: "Saving products\n\(i+1)/\(arrData.count)")
            self.context.performAndWait {
                let model = arrData[i]
                if model.arrSelectedAddOn?.count ?? 0 > 0{
                    for addon in model.arrSelectedAddOn!{
                        let addonEntry = NSEntityDescription.insertNewObject(forEntityName: "ProductAddons", into: self.context)
                        addonEntry.setValue(addon.id ?? 0, forKey: "id")
                        addonEntry.setValue(addon.minQuantity ?? 0, forKey: "min_quantity")
                        addonEntry.setValue(addon.maxQuantity ?? 0, forKey: "max_quantity")
                        addonEntry.setValue(model.id ?? 0, forKey: "product_id")
                        addonEntry.setValue(addon.disabled ?? 0, forKey: "disabled")
                        AppConstants.appDelegate.saveContext()
                    }
                }
                if model.arrSelectedIngrident?.count ?? 0 > 0{
                    self.saveIngredientIntoDatabase(arrData: model.arrSelectedIngrident!)
                }
                let productEntry = NSEntityDescription.insertNewObject(forEntityName: "Product", into: self.context)
                productEntry.setValue(model.id ?? 0, forKey: "id")
                productEntry.setValue(model.name ?? "", forKey: "name")
                productEntry.setValue(model.shortName ?? "", forKey: "short_name")
                productEntry.setValue(model.description ?? "", forKey: "product_description")
                productEntry.setValue(model.price ?? 0, forKey: "price")
                productEntry.setValue(model.categoryId ?? 0, forKey: "category_id")
                productEntry.setValue(model.preparationLocationId ?? 0, forKey: "preparation_location_id")
                productEntry.setValue(model.deliveryPreparationLocationId ?? 0, forKey: "delivery_preparation_location_id")
                productEntry.setValue(model.takeawayPreparationLocationId ?? 0, forKey: "takeaway_preparation_location_id")
                productEntry.setValue(model.banquetPreparationLocationId ?? 0, forKey: "banquet_preparation_location_id")
                productEntry.setValue(model.takeawayPrice ?? 0, forKey: "takeaway_price")
                productEntry.setValue(model.deliveryPrice ?? 0, forKey: "delivery_price")
                productEntry.setValue(model.waitingPrice ?? 0, forKey: "waiting_price")
                productEntry.setValue(model.arrSelectedAddOn?.count ?? 0, forKey: "total_addons")
                productEntry.setValue(model.topColor ?? "", forKey: "top_color")
                productEntry.setValue(model.fontColor ?? "", forKey: "font_color")
                productEntry.setValue(model.imageUrl ?? "", forKey: "image_url")
                productEntry.setValue(model.disabled ?? 0, forKey: "disabled")
                productEntry.setValue(model.isBanquet ?? 0, forKey: "is_banquet")
                productEntry.setValue(model.isDelivery ?? 0, forKey: "is_delivery")
                productEntry.setValue(model.isCollection ?? 0, forKey: "is_collection")
                productEntry.setValue(model.isDineIn ?? 0, forKey: "is_dinein")
                productEntry.setValue(model.autoAddon ?? 0, forKey: "auto_addon")
                productEntry.setValue(model.autoModify ?? 0, forKey: "auto_modify")
                AppConstants.appDelegate.saveContext()
            }
        }
    }
    
    func saveAddOnIntoDatabase(arrData:[AddOnModel]){
        for i in 0..<arrData.count{
            let model = arrData[i]
            AppCommonMethods.changeProgressMessage(msg: "Saving addons\n\(i+1)/\(arrData.count)")
            let addonEntry = NSEntityDescription.insertNewObject(forEntityName: "AddOns", into: self.context)
            addonEntry.setValue(model.id ?? 0, forKey: "id")
            addonEntry.setValue(model.name ?? "", forKey: "addon_name")
            addonEntry.setValue(model.price ?? 0, forKey: "price")
            addonEntry.setValue(model.takeawayPrice ?? 0, forKey: "takeaway_price")
            addonEntry.setValue(model.deliveryPrice ?? 0, forKey: "delivery_price")
            addonEntry.setValue(model.waitingPrice ?? 0, forKey: "waiting_price")
            if model.parentId != nil{
                addonEntry.setValue(model.parentId!, forKey: "parent_id")
            }
            addonEntry.setValue(model.disabled ?? 0, forKey: "disabled")
            
            AppConstants.appDelegate.saveContext()
            
            if model.children != nil{
                saveAddOnIntoDatabase(arrData: AppCommonMethods.Copy(of: model.children!)!)
            }
        }
    }
    
    func saveIngredientIntoDatabase(arrData:[IngredientModel]){
        for model in arrData{
            let ingredientsEntry = NSEntityDescription.insertNewObject(forEntityName: "Ingredients", into: self.context)
            ingredientsEntry.setValue(model.id ?? 0, forKey: "id")
            ingredientsEntry.setValue(model.name ?? "", forKey: "name")
            ingredientsEntry.setValue(model.price ?? 0, forKey: "price")
            ingredientsEntry.setValue(model.with ?? 0, forKey: "with")
            ingredientsEntry.setValue(model.without ?? 0, forKey: "without")
            ingredientsEntry.setValue(model.priceWithout ?? 0, forKey: "price_without")
            ingredientsEntry.setValue(model.disabled ?? 0, forKey: "disabled")
            ingredientsEntry.setValue(model.productId ?? 0, forKey: "product_id")
            AppConstants.appDelegate.saveContext()
        }
    }
    
    func savePrepLocationIntoDatabase(arrData:[PrepLocationModel]){
        for i in 0..<arrData.count{
            let model = arrData[i]
            AppCommonMethods.changeProgressMessage(msg: "Saving preparation locations\n\(i+1)/\(arrData.count)")
            let locationEntry = NSEntityDescription.insertNewObject(forEntityName: "PrepLocation", into: self.context)
            locationEntry.setValue(model.id ?? 0, forKey: "id")
            locationEntry.setValue(model.printerId ?? 0, forKey: "printer_id")
            locationEntry.setValue(model.name ?? "", forKey: "name")
            locationEntry.setValue(model.printerIP ?? "", forKey: "printer_ip")
            locationEntry.setValue(model.disabled ?? 0, forKey: "disabled")
            AppConstants.appDelegate.saveContext()
        }
    }
    
    func SaveReservationToDatabase(reservation:ReservationModel, oldCustomerId:Int? = nil, update:Int, oldId:Int? = nil){
        if reservation.customer != nil{
            let customer = reservation.customer!
            var userEntry = NSEntityDescription.insertNewObject(forEntityName: "Customer", into: self.context)
            var predicate = NSPredicate.init(format: "unique_id == %@", customer.uniqueId)
            if let result = fetchDataFromDatabase(entity: "Customer", predict: predicate, limit: 1) as? [NSManagedObject], let object = result.first{
                userEntry = object
            }
            userEntry.setValue(customer.id ?? 0, forKey: "id")
            userEntry.setValue(customer.name ?? "", forKey: "name")
            userEntry.setValue(customer.mobile ?? "", forKey: "mobile")
            userEntry.setValue(customer.offline, forKey: "offline")
            userEntry.setValue(customer.email ?? "", forKey: "email")
            userEntry.setValue(customer.uniqueId, forKey: "unique_id")
            if customer.offline == 0 && oldCustomerId != nil{
                _ = SQLiteManage.ExecuteQuery("UPDATE Orders SET customer_id = \(customer.id ?? 0) WHERE customer_id = \(oldCustomerId!)")
            }
            AppConstants.appDelegate.saveContext()
        }
        var reservationEntry = NSEntityDescription.insertNewObject(forEntityName: "Reservations", into: self.context)
        var predicate = NSPredicate.init(format: "unique_id == %@", reservation.uniqueId)
        if let result = self.fetchDataFromDatabase(entity: "Reservations", predict: predicate, limit: 1) as? [NSManagedObject], let object = result.first{
            reservationEntry = object
        }
        reservationEntry.setValue(AppConstants.businessData?.id ?? 0, forKey: "business_id")
        reservationEntry.setValue(reservation.id ?? 0, forKey: "id")
        reservationEntry.setValue(reservation.customerId ?? 0, forKey: "customer_id")
        reservationEntry.setValue(reservation.depositAmount ?? 0, forKey: "deposit_amount")
        reservationEntry.setValue(reservation.depositTypeId ?? 0, forKey: "deposit_type_id")
        reservationEntry.setValue(reservation.diners ?? 0, forKey: "diners")
        reservationEntry.setValue(Int(((reservation.reservationDateTime ?? "").getDateFromString(format: "yyyy-MM-dd HH:mm:ss") ?? Date()).timeIntervalSince1970), forKey: "reservation_date_time")
        reservationEntry.setValue(reservation.reservationStatusId ?? 0, forKey: "reservation_status_id")
        reservationEntry.setValue(reservation.specialInstruction ?? "", forKey: "special_instruction")
        reservationEntry.setValue(reservation.tableId ?? 0, forKey: "table_id")
        reservationEntry.setValue(reservation.tableNumber ?? "", forKey: "table_number")
        reservationEntry.setValue(reservation.offline, forKey: "offline")
        reservationEntry.setValue(update, forKey: "is_update")
        reservationEntry.setValue(reservation.uniqueId, forKey: "unique_id")
        if AppConstants.userData != nil{
            reservationEntry.setValue(AppConstants.userData?.id ?? 0, forKey: "updater_id")
        }else{
            reservationEntry.setValue(reservation.updaterId ?? 0, forKey: "updater_id")
        }
        AppConstants.appDelegate.saveContext()
    }
    
    func SaveReservationToDatabase(arrData:[ReservationModel]){
        for reservation in arrData{
            var reservationEntry = NSEntityDescription.insertNewObject(forEntityName: "Reservations", into: self.context)
            let predicate = NSPredicate.init(format: "unique_id == %@ AND is_delete == 0", reservation.uniqueId)
            
            if let result = fetchDataFromDatabase(entity: "Reservations", predict: predicate, limit: 1) as? [NSManagedObject], let object = result.first{
                if let update = object.getIntValue("is_update"){
                    if update == 1{
                        return
                    }
                }
                reservationEntry = object
            }
            
            reservationEntry.setValue(AppConstants.businessData?.id ?? 0, forKey: "business_id")
            reservationEntry.setValue(reservation.id ?? 0, forKey: "id")
            reservationEntry.setValue(reservation.customerId ?? 0, forKey: "customer_id")
            reservationEntry.setValue(reservation.depositAmount ?? 0, forKey: "deposit_amount")
            reservationEntry.setValue(reservation.depositTypeId ?? 0, forKey: "deposit_type_id")
            reservationEntry.setValue(reservation.diners ?? 0, forKey: "diners")
            reservationEntry.setValue(Int(((reservation.reservationDateTime ?? "").getDateFromString(format: "yyyy-MM-dd HH:mm:ss") ?? Date()).timeIntervalSince1970), forKey: "reservation_date_time")
            reservationEntry.setValue(reservation.reservationStatusId ?? 0, forKey: "reservation_status_id")
            reservationEntry.setValue(reservation.specialInstruction ?? "", forKey: "special_instruction")
            reservationEntry.setValue(reservation.tableId ?? 0, forKey: "table_id")
            reservationEntry.setValue(reservation.tableNumber ?? "", forKey: "table_number")
            reservationEntry.setValue(reservation.uniqueId, forKey: "unique_id")
            reservationEntry.setValue(0, forKey: "offline")
            if AppConstants.userData != nil{
                reservationEntry.setValue(AppConstants.userData?.id ?? 0, forKey: "updater_id")
            }else{
                reservationEntry.setValue(reservation.updaterId ?? 0, forKey: "updater_id")
            }
            AppConstants.appDelegate.saveContext()
            
            if reservation.customer != nil{
                let customer = reservation.customer!
                var userEntry = NSEntityDescription.insertNewObject(forEntityName: "Customer", into: self.context)
                let predicate = NSPredicate.init(format: "unique_id == %@", customer.uniqueId)
                if let result = fetchDataFromDatabase(entity: "Customer", predict: predicate, limit: 1) as? [NSManagedObject], let object = result.first{
                    if object.getIntValue("is_updated") ?? 0 == 1{
                        return
                    }
                    userEntry = object
                }
                userEntry.setValue(customer.id ?? 0, forKey: "id")
                userEntry.setValue(customer.name ?? "", forKey: "name")
                userEntry.setValue(customer.mobile ?? "", forKey: "mobile")
                userEntry.setValue(0, forKey: "offline")
                userEntry.setValue(customer.email ?? "", forKey: "email")
                userEntry.setValue(customer.uniqueId, forKey: "unique_id")
                AppConstants.appDelegate.saveContext()
            }
        }
    }
    
    func DeleteReservation(uniquId:String,isFromAPI:Bool){
        let predicate = NSPredicate.init(format: "unique_id == %@", uniquId)
        if isFromAPI{
            deleteDataFromDatabase(entity: "Reservations",predict: predicate)
        }else{
            if let result = fetchDataFromDatabase(entity: "Reservations", predict: predicate, limit: 1) as? [NSManagedObject], let object = result.first{
                object.setValue(1, forKey: "is_delete")
                AppConstants.appDelegate.saveContext()
            }
        }
    }
    
    func DeleteBulkReservation(ids:[Int]){
        let request = NSBatchUpdateRequest.init(entityName: "Reservations")
        request.propertiesToUpdate = ["is_delete":1]
        do {
            try context.execute(request)
        } catch {
            let updateError = error as NSError
            print("\(updateError), \(updateError.userInfo)")
        }
    }
    
    func DeleteAdminData(){
        deleteDataFromDatabase(entity: "Reservations")
        deleteDataFromDatabase(entity: "Floor")
        deleteDataFromDatabase(entity: "Product")
        DeleteAllOrderData()
    }
    
    func DeleteAllOrderData(){
        _ = SQLiteManage.ExecuteQuery("DELETE FROM Orders")
        _ = SQLiteManage.ExecuteQuery("DELETE FROM OrderAddons")
        _ = SQLiteManage.ExecuteQuery("DELETE FROM OrderGroup")
        _ = SQLiteManage.ExecuteQuery("DELETE FROM OrderIngredients")
        _ = SQLiteManage.ExecuteQuery("DELETE FROM OrderPayment")
        _ = SQLiteManage.ExecuteQuery("DELETE FROM OrderProducts")
        _ = SQLiteManage.ExecuteQuery("UPDATE Tables SET last_order_time = 0, last_order_total = 0, offline = 0, table_status_id = 1, last_order_id = 0, locked = 0, merge_table_id = 0")
    }
    
    func DeleteBlankCustomers(){
        self.deleteDataFromDatabase(entity: "Customer", predict: NSPredicate.init(format: "(name = '' OR name = nil) AND (mobile = '' OR mobile = nil)"))
    }
}

//MARK: NSManagedObject
extension NSManagedObject{
    func getIntValue(_ key:String) ->Int?{
        if let id = self.value(forKey: key) as? Int{
            return id
        }
        
        if let id = self.value(forKey: key) as? String{
            return Int(id)
        }
        return nil
    }
    
    func getDoubleValue(_ key:String) ->Double?{
        if let id = self.value(forKey: key) as? Double{
            return id
        }
        if let id = self.value(forKey: key) as? String{
            return Double(id)
        }
        return nil
    }
    
    func getStringValue(_ key:String) ->String?{
        if let id = self.value(forKey: key) as? String{
            return id
        }
        if let id = self.value(forKey: key) as? Double{
            return "\(id)"
        }
        if let id = self.value(forKey: key) as? Int{
            return "\(id)"
        }
        return nil
    }
}
