//
//  BackgroudAPIExecution.swift
//  EPOS
//
//  Created by Apple on 20/05/21.
//

import Foundation
import UIKit
import CoreData

class BGAPIExecution: NSObject,URLSessionTaskDelegate {
    
    static let shared = BGAPIExecution()
    
    var urlTask:URLSessionTask?
    
    var orderSaved: ((Int,String?) -> Void)?
    var allDataPushed: (() -> Void)?
    var arrOrders = [OrderModel]()
    var isOnlyOrderPush = false
    let boundary = "---------------------------14737809831466499882746641449"
    var isManualPush = false
    var orderId = ""
    
    override init() {
        super.init()
        NotificationCenter.default.addObserver(self, selector: #selector(orderPushedToSocket), name: AppConstants.notifications.kDatabasePushed, object: nil)
    }
    
    @objc func orderPushedToSocket(){
        if isManualPush{
            if let order = arrOrders.first, order.uniqueId == orderId{
                arrOrders.removeFirst()
            }
            fetchOrderAndCallOrderAPI()
        }
    }
    
    func fetchAllOfflineOrders(){
        isManualPush = true
        isOnlyOrderPush = false
        arrOrders = SQLiteManage.fetchOfflineOrdersData()
        fetchOrderAndCallOrderAPI()
    }
    
    func fetchOrderAndCallOrderAPI(){
        if Reachabilities.shared.isConnectedToNetwork() && urlTask == nil{
            if let order = arrOrders.first{
                self.PushOrderToServer(order: order)
            }else{
                if !isOnlyOrderPush{
                    if let reservation = CoreDataHelper.shared.fetchOfflineReservationsData(){
                        self.SaveReservation(reservation: reservation, isDeleted: false)
                    }else if let reservation = CoreDataHelper.shared.fetchDeletedReservationsData(){
                        self.SaveReservation(reservation: reservation, isDeleted: true)
                    }else{
                        if allDataPushed != nil{
                            allDataPushed!()
                            self.allDataPushed = nil
                        }
                    }
                }else{
                    if allDataPushed != nil{
                        allDataPushed!()
                        self.allDataPushed = nil
                    }
                }
            }
        }
    }
    
    func fetchReservationAndCallAPI(){
        if Reachabilities.shared.isConnectedToNetwork() && urlTask == nil{
            if let reservation = CoreDataHelper.shared.fetchOfflineReservationsData(){
                self.SaveReservation(reservation: reservation, isDeleted: false)
            }else if let reservation = CoreDataHelper.shared.fetchDeletedReservationsData(){
                self.SaveReservation(reservation: reservation, isDeleted: true)
            }else{
                if allDataPushed != nil{
                    allDataPushed!()
                    self.allDataPushed = nil
                }
            }
        }
    }
    
    func AddOrderToQueue(order:OrderModel, shouldPrint:Bool = false, isDeleteFromRunningOrder:Bool = true){
        if urlTask != nil{
            urlTask?.suspend()
            urlTask = nil
        }
        isOnlyOrderPush = false
        SQLiteManage.SaveOrderIntoDatabase(order: order, updated: 1)
        PushOrderToServer(order: order, isManualPush: true, shouldPrint:shouldPrint, isDeleteFromRunningOrder: isDeleteFromRunningOrder)
        isManualPush = false
    }
    
    func AddOrdersToQueue(arr:[OrderModel]){
        if urlTask != nil{
            urlTask?.suspend()
            urlTask = nil
        }
        arrOrders = arr
        isOnlyOrderPush = true
        isManualPush = true
        fetchOrderAndCallOrderAPI()
    }
    
    func CallDeleteOrder(orderId:String, isDeleteFromRunningOrder:Bool){
        self.orderId = orderId
        SocketService.shared?.deleteOrderToSocket(id: orderId, isDeleteFromRunningOrder: isDeleteFromRunningOrder)
    }
    
    func StartOrderSaveTask(order:OrderModel, oldOrder:OrderModel, OldCustomerId:Int? = nil, isFromAgainPush:Bool = false, shouldPush:Bool = false){
        if OldCustomerId != nil{
            arrOrders.forEach { (model) in
                if model.customerId ?? 0 == OldCustomerId!{
                    model.customer = order.customer
                    model.customerId = order.customerId
                }
            }
        }
        CoreDataHelper.shared.saveAndUpdateCusomer(customer: order.customer!, offline: 0, updated: 0, isFromUpload: true)
        if order.table?.id ?? 0 != 0{
            if (order.table?.tableStatus?.status ?? "").lowercased() != "vacant"{
                SQLiteManage.updateTableStatus(tableId: order.table?.id ?? 0, lastOrderId: order.id, offline: 0)
            }else{
                SQLiteManage.updateTableStatus(tableId: order.table?.id ?? 0, lastOrderId: 0, lastOrderTotal: 0, lastOrderTime: "", offline: 0)
            }
        }
        completeQueue(order: order, oldOrder: oldOrder, shouldPushOrder: false)
    }
    
    func completeQueue(order:OrderModel, oldOrder:OrderModel, shouldPushOrder:Bool){
        SQLiteManage.deleteOrder(orderId: oldOrder.id ?? 0, isFromAPI: true)
        SQLiteManage.SaveOrderIntoDatabase(order: order, updated: 0)
        if shouldPushOrder{
            PushOrderToServer(order: order, againCall: true)
        }else{
            if orderSaved != nil{
                self.orderSaved!(order.id ?? 0, nil)
                orderSaved = nil
            }else{
                if arrOrders.count > 0{
                    arrOrders.removeFirst()
                }
                fetchOrderAndCallOrderAPI()
            }
        }
        
    }
    
    func PushOrderToServer(order:OrderModel, againCall:Bool = false, isManualPush:Bool = false, shouldPrint:Bool = false, isDeleteFromRunningOrder:Bool = false){
        
        if order.isDeleted == 1{
            if order.isNewOrder == 0{
                self.CallDeleteOrder(orderId: order.uniqueId, isDeleteFromRunningOrder: isDeleteFromRunningOrder)
            }else{
                SQLiteManage.deleteOrder(orderId: order.id ?? 0, isFromAPI: true)
                if self.allDataPushed != nil{
                    if self.arrOrders.count > 0{
                        self.arrOrders.removeFirst()
                        self.fetchOrderAndCallOrderAPI()
                    }
                }else if self.orderSaved != nil{
                    self.orderSaved!(order.id ?? 0,nil)
                    self.orderSaved = nil
                }
            }
            return
        }
        var dictOrder = [String:Any]()
        
        let dictCustomer = NSMutableDictionary()
        if order.customer?.offline ?? 1 == 0 && order.customer?.id != 0{
            dictCustomer["id"] = order.customer?.id ?? 0
            dictOrder["customer_id"] = order.customerId ?? 0
        }else{
            dictOrder["customer_id"] = ""
            dictCustomer["id"] = ""
        }
        
        dictOrder["unique_id"] = order.uniqueId
        dictCustomer["name"] = order.customer?.name ?? ""
        dictCustomer["mobile"] = order.customer?.mobile ?? ""
        dictCustomer["email"] = order.customer?.email ?? ""
        dictCustomer["house_no"] = order.customer?.houseNo ?? ""
        dictCustomer["street"] = order.customer?.street ?? ""
        dictCustomer["city"] = order.customer?.city ?? ""
        dictCustomer["postcode"] = order.customer?.postcode ?? ""
        dictCustomer["distance"] = order.customer?.distance ?? 0
        dictCustomer["news_letter"] = order.customer?.newsLetter ?? 0
        dictCustomer["unique_id"] = order.customer?.uniqueId ?? ""
        
        dictOrder["customer"] = AppConstants.DataSyncMode == "Auto" ? dictCustomer : AppCommonMethods.convertJsontoString(json: dictCustomer, shouldEncode: false)
        
        if order.tableId ?? 0 != 0{
            dictOrder["table_id"] = order.tableId ?? 0
            dictOrder["no_guest"] = "\(order.noGuest ?? 0)"
        }else{
            dictOrder["table_id"] = ""
            dictOrder["no_guest"] = ""
        }
        dictOrder["order_type_id"] = order.orderTypeId ?? 0
        dictOrder["order_type"] = order.orderType ?? ""
        
        dictOrder["updater_id"] = order.updaterId ?? 0
        if order.orderActionId ?? 0 != 0{
            dictOrder["order_action_id"] = order.orderActionId ?? 0
        }
        
        dictOrder["sub_total"] = String.init(format:"%.2f",order.subTotal ?? 0)
        dictOrder["tax"] = "0"
        dictOrder["service_charge"] = order.serviceCharge ?? 0
        dictOrder["delivery_charge"] = String.init(format:"%.2f",order.deliveryCharge ?? 0)
        dictOrder["gratuity"] = String.init(format:"%.2f",order.gratuity ?? 0)
        dictOrder["discount"] = String.init(format:"%.2f",order.discount ?? 0)
        dictOrder["distance"] = String.init(format:"%.2f",order.distance ?? 0)
        dictOrder["total"] = String.init(format:"%.2f",order.total ?? 0)
        dictOrder["comment"] = order.comment ?? ""
        dictOrder["is_auto_service_charge_remove"] = AppConstants.DataSyncMode == "Auto" ? order.isAutoServiceChargeRemove : (order.isAutoServiceChargeRemove ? 1 : 0)
        
        if isManualPush{
            if order.orderStatusId ?? 0 != 0{
                dictOrder["order_status_id"] = order.orderStatusId ?? 0
            }
        }else{
            if order.orderStatusId ?? 0 <= 2{
                dictOrder["order_status_id"] = 2
            }else{
                dictOrder["order_status_id"] = order.orderStatusId ?? 0
            }
        }
        
        dictOrder["is_archived"] = AppConstants.DataSyncMode == "Auto" ? order.isArchived : (order.isArchived ? 1 : 0)
        if !order.displayOrderId.isEmpty{
            dictOrder["display_order_id"] = order.displayOrderId
        }else{
            dictOrder["display_order_id"] = "\(AppConstants.userData?.preffix ?? "")\(order._id)"
        }
        
        if order.splitCount ?? 0 > 0{
            dictOrder["split_count"] = order.splitCount ?? 0
            dictOrder["split_type"] = "person"
        }else if order.arrOrderSplit.count > 0{
            dictOrder["split_type"] = "order_item"
        }
        dictOrder["total_paid"] = String.init(format:"%.2f",order.totalPaid ?? 0)
        var arrOrder = [NSMutableDictionary]()
        
        for model in order.arrProducts{
            let dictProduct = NSMutableDictionary()
            if model.groupUniqueId != ""{
                dictProduct["unique_id"] = model.groupUniqueId
            }
            dictProduct["product_name"] = model.productName ?? ""
            dictProduct["quantity"] = model.quantity ?? 0
            dictProduct["is_delete"] = AppConstants.DataSyncMode == "Auto" ? model.isDelete : (model.isDelete ? 1 : 0)
            dictProduct["sent_to_kitchen"] = AppConstants.DataSyncMode == "Auto" ? model.sentToKitchen : (model.sentToKitchen ? 1 : 0)
            dictProduct["special_instruction"] = model.specialInstruction ?? ""
            dictProduct["instruction_price"] = String.init(format:"%.2f",model.instructionPrice ?? 0)
            dictProduct["price"] = String.init(format:"%.2f",model.price ?? 0)
            dictProduct["sub_total"] = String.init(format:"%.2f",model.subTotal ?? 0)
            dictProduct["total"] = String.init(format:"%.2f",model.total ?? 0)
            dictProduct["addons_price"] = String.init(format:"%.2f",model.addonPrice ?? 0)
            dictProduct["ingredients_price"] = String.init(format:"%.2f",model.ingredientsPrice ?? 0)
            dictProduct["updater_id"] = model.updaterId ?? 0
            dictProduct["updater_at"] = model.updatedAt
            if model.orderSplitId ?? 0 != 0 && model.groupOffline == 0{
                dictProduct["order_split_id"] = model.orderSplitId ?? 0
            }
            if model.arrAddons.count > 0{
                var arrAddon = [NSMutableDictionary]()
                for addon in model.arrAddons{
                    let dictAddon = NSMutableDictionary()
                    dictAddon["addon_id"] = addon.AddonId ?? 0
                    dictAddon["updater_id"] = addon.updaterId ?? 0
                    dictAddon["total"] = String.init(format:"%.2f",addon.price ?? 0)
                    dictAddon["price"] = String.init(format:"%.2f",addon.price ?? 0)
                    if addon.isNewOrder == 0{
                        dictAddon["id"] = addon.id ?? 0
                    }else{
                        dictAddon["id"] = ""
                    }
                    dictAddon["quantity"] = addon.quantity
                    arrAddon.append(dictAddon)
                }
                dictProduct["order_item_addons"] = arrAddon
            }
            if model.arrIngriedent.count > 0{
                var arrAddon = [NSMutableDictionary]()
                for ingrident in model.arrIngriedent{
                    let dictAddon = NSMutableDictionary()
                    dictAddon["product_ingredient_id"] = ingrident.productIngredientId ?? 0
                    dictAddon["with"] = ingrident.with ?? 0
                    dictAddon["without"] = ingrident.without ?? 0
                    dictAddon["quantity"] = ingrident.quantity ?? 0
                    dictAddon["updater_id"] = ingrident.updaterId ?? 0
                    dictAddon["price"] = String.init(format:"%.2f",ingrident.price ?? 0)
                    dictAddon["total"] = String.init(format:"%.2f",((ingrident.price ?? 0) * (Double(ingrident.quantity ?? 0))))
                    if ingrident.isNewOrder == 0{
                        dictAddon["id"] = ingrident.id ?? 0
                    }else{
                        dictAddon["id"] = ""
                    }
                    arrAddon.append(dictAddon)
                }
                dictProduct["order_item_ingredients"] = arrAddon
            }
            if model.misc ?? 0 == 1{
                dictProduct["misc"] = 1
                dictProduct["product_id"] = ""
                dictProduct["id"] = ""
                dictProduct["preparation_location_id"] = model.prepLocationId ?? 0
                dictProduct["delivery_price"] = String.init(format:"%.2f",model.price ?? 0)
                dictProduct["takeaway_price"] = String.init(format:"%.2f",model.price ?? 0)
                dictProduct["web_price"] = String.init(format:"%.2f",model.price ?? 0)
                dictProduct["name"] = model.productName ?? ""
                dictProduct["waiting_price"] = String.init(format:"%.2f",model.price ?? 0)
            }else{
                dictProduct["product_id"] = model.prodcutId ?? 0
            }
            dictProduct["sent_to_kitchen_quantity"] = model.sentToKitchenQuantity
            if model.uniqueId != ""{
                dictProduct["id"] = model.id ?? 0
                dictProduct["item_unique_id"] = model.uniqueId
            }else{
                dictProduct["id"] = ""
                dictProduct["item_unique_id"] = Int(Date().timeIntervalSinceReferenceDate)
            }
            arrOrder.append(dictProduct)
        }
        
        dictOrder["order_items"] = AppConstants.DataSyncMode == "Auto" ? arrOrder : AppCommonMethods.convertJsontoString(json: arrOrder, shouldEncode: false)
        if order.arrOrderSplit.count > 0{
            var arrGroup = [[String:Any]]()
            order.arrOrderSplit.forEach { group in
                var dictParam = [String:Any]()
                if order.isNewOrder == 0{
                    dictParam["order_id"] = order.id ?? 0
                }
                if group.offline == 0{
                    dictParam["id"] = group.id ?? 0
                }
                dictParam["group_name"] = group.groupName ?? ""
                dictParam["total"] = (group.total ?? 0).getRoundFigure()
                dictParam["paid_amount"] = (group.paidAmount ?? 0).getRoundFigure()
                dictParam["unique_id"] = group.uniqueId
                dictParam["selected"] = false
                dictParam["auto_gratuity_remove"] = AppConstants.DataSyncMode == "Auto" ? group.autoGratuityRemove : (group.autoGratuityRemove ? 1 : 0)
                dictParam["auto_discount_remove"] = AppConstants.DataSyncMode == "Auto" ? group.autoDiscountRemove : (group.autoDiscountRemove ? 1 : 0)
                dictParam["auto_service_charge_remove"] = AppConstants.DataSyncMode == "Auto" ? group.autoServiceChargeRemove : (group.autoServiceChargeRemove ? 1 : 0)
                dictParam["discount"] = group.discount
                dictParam["gratuity"] = group.gratuity
                dictParam["service_charge"] = group.serviceCharge
                arrGroup.append(dictParam)
            }
            dictOrder["order_splits"] = AppConstants.DataSyncMode == "Auto" ? arrGroup : AppCommonMethods.convertJsontoString(json: arrGroup, shouldEncode: false)
        }
        
        if order.arrOrderPayments.count > 0{
            var arrPayment = [[String:Any]]()
            order.arrOrderPayments.forEach { payment in
                var dictPayment = [String:Any]()
                if order.isNewOrder == 0{
                    dictPayment["order_id"] = order.id ?? 0
                }
                dictPayment["amount"] = payment.amount ?? 0//String.init(format: "%.2f", payment.amount ?? 0)
                dictPayment["payment_method_id"] = "\(payment.paymentMethodId ?? 0)"
                dictPayment["payment_method_name"] = payment.paymentMethodName ?? ""
                
                if payment.paymentMethodId ?? 0 == 5{
                    dictPayment["voucher_id"] = "\(payment.voucherId ?? 0)"
                }else if payment.paymentMethodId ?? 0 == 3{
                    dictPayment["cheque_number"] = payment.chequeNumber ?? ""
                }
                dictPayment["cc_number"] = payment.ccNumber ?? ""
                dictPayment["txn_id"] = payment.txnId ?? ""
                
                dictPayment["updater_id"] = "\(payment.updaterId ?? 0)"
                if payment.offline == 0{
                    dictPayment["id"] = payment.id ?? 0
                }
                
                if let groupId = payment.orderSplitId{
                    if groupId != 0{
                        dictPayment["order_split_id"] = groupId
                    }
                }
                if payment.groupUniqueId != ""{
                    dictPayment["split_unique_id"] = payment.groupUniqueId
                }
                dictPayment["is_refunded"] = AppConstants.DataSyncMode == "Auto" ? payment.isRefunded == 1 : payment.isRefunded
                arrPayment.append(dictPayment)
            }
            dictOrder["order_payments"] = AppConstants.DataSyncMode == "Auto" ? arrPayment : AppCommonMethods.convertJsontoString(json: arrPayment, shouldEncode: false)
        }
        do {
            if let table =  order.table{
                if #available(iOS 15.0, *) {
                    dictOrder["table"] = try JSONSerialization.jsonObject(with: AppCommonMethods.getjsonDataFromCodable(object: table)!, options:JSONSerialization.ReadingOptions.json5Allowed )
                } else {
                    dictOrder["table"] = try JSONSerialization.jsonObject(with: AppCommonMethods.getjsonDataFromCodable(object: table)!, options:JSONSerialization.ReadingOptions.mutableContainers )
                }
                dictOrder["table_number"] = table.number ?? ""
            }else{
                dictOrder["table"] = ""
            }
        }catch{
            print(error.localizedDescription)
        }
        
        var strURL = AppConstants.APIURL.kCreateOrder
        if order.isNewOrder == 0{
            dictOrder["id"] = order.id ?? 0
            strURL = "\(AppConstants.APIURL.kCreateOrder)/\(order.id ?? 0)"
        }
        if shouldPrint && AppConstants.remoteDevice == "Yes"{
            dictOrder["print"] = 1
        }
        dictOrder["delivery_date"] = order.deliveryDate ?? ""
        
        dictOrder["is_delivery_collection_ask"] = order.isDeliveryCollectionAsk
        dictOrder["delivery_collection_time_slot"] = order.deliveryCollectionTimeSlot
        
        dictOrder["device_id"] = AppConstants.DeviceId
        dictOrder["socket_type"] = "order"
        if isManualPush{
            dictOrder["redirection_type"] = "manual_push"
        }else{
            dictOrder["redirection_type"] = "auto_push"
        }
        if AppConstants.DataSyncMode == "Auto"{
            orderId = order.uniqueId
            SocketService.shared?.sendOrderToSocket(data: dictOrder, id: order.uniqueId)
        }else{
            let request = self.createAPIRequest(strURL: strURL, param: dictOrder)
            
            if urlTask != nil{
                urlTask?.suspend()
                urlTask?.cancel()
                urlTask = nil
            }
            
            urlTask = URLSession.shared.dataTask(with: request) { [self] (data, response, error) in
                self.urlTask = nil
                
                if (error != nil){
                    print(error?.localizedDescription ?? "")
                }
                else{
                    if let httpResponse = response as? HTTPURLResponse, var data = data{
                        if httpResponse.statusCode == 200{
                            if var string = String.init(data: data, encoding: .utf8){
                                if string.count > 87{
                                    for _ in 1...15{
                                        let index = string.index(string.startIndex, offsetBy: string.count - 4, limitedBy: string.endIndex)!
                                        string.remove(at: index)
                                    }
                                    string.removeFirst(15)
                                    for _ in 1...7{
                                        let index = string.index(string.startIndex, offsetBy: 8, limitedBy: string.endIndex)!
                                        string.remove(at: index)
                                    }
                                    for _ in 1...8{
                                        let index = string.index(string.startIndex, offsetBy: 14, limitedBy: string.endIndex)!
                                        string.remove(at: index)
                                    }
                                    for _ in 1...6{
                                        let index = string.index(string.startIndex, offsetBy: 22, limitedBy: string.endIndex)!
                                        string.remove(at: index)
                                    }
                                    for _ in 1...7{
                                        let index = string.index(string.startIndex, offsetBy: 28, limitedBy: string.endIndex)!
                                        string.remove(at: index)
                                    }
                                }
                                if let newData = string.data(using: .utf8){
                                    let aes = EasyAES.init(key: AppConstants.keyForAPI, bit: 256, andIV: AppConstants.ivForAPI)
                                    data = aes.decryptData(newData)
                                }
                            }
                        }
                        let jsonData: Any?
                        do {
                            jsonData = try JSONSerialization.jsonObject(with: data, options:JSONSerialization.ReadingOptions.mutableContainers )
                            if AppConstants.isInDevlopmentMode{
                                print("Order Response:",jsonData ?? "")
                            }
                            if httpResponse.statusCode == 200{
                                if let xRefreshToken = httpResponse.allHeaderFields["x-refresh-token"] as? String {
                                    AppCommonMethods.saveDataIntoUserDefault(value: xRefreshToken, withKey: AppConstants.userDefaultKey.kRefreshHeaderToken)
                                }
                                if let xToken = httpResponse.allHeaderFields["x-token"] as? String {
                                    AppCommonMethods.saveDataIntoUserDefault(value: xToken, withKey: AppConstants.userDefaultKey.kHeaderToken)
                                }
                                if let dictResponse = jsonData as? NSDictionary{
                                    let jsonDecoder = JSONDecoder()
                                    if let data = AppCommonMethods.convertToJson(object: dictResponse), let newOrder = try? jsonDecoder.decode(OrderModel.self, from: data){
                                        if newOrder.id ?? 0 != 0{
                                            self.StartOrderSaveTask(order: newOrder, oldOrder: order, OldCustomerId: order.customerId ?? 0, isFromAgainPush: againCall)
                                            return
                                        }
                                    }
                                }
                            }else{
                                if httpResponse.statusCode == 401{
                                    DispatchQueue.main.async {
                                        AppCommonMethods.stopProgressBar()
                                        AppCommonMethods.removefromUserDefault(withKey: AppConstants.userDefaultKey.kUserData)
                                        AppCommonMethods.removefromUserDefault(withKey: AppConstants.userDefaultKey.kRefreshHeaderToken)
                                        AppCommonMethods.removefromUserDefault(withKey: AppConstants.userDefaultKey.kHeaderToken)
                                        AppConstants.isAdminLogin = false
                                        AppConstants.isSupervisorLogin = false
                                        if let VC = LoginVC.instance(){
                                            let navc = UINavigationController.init(rootViewController: VC)
                                            navc.isNavigationBarHidden = true
                                            AppConstants.appDelegate.window?.rootViewController = navc
                                        }
                                        if let dictResponse = jsonData as? NSDictionary{
                                            AppCommonMethods.showToastAlert(message: dictResponse.getStringValue("message") ?? "")
                                        }
                                    }
                                    return
                                }
                            }
                        } catch let error {
                            print(error.localizedDescription)
                        }
                    }
                }
                if self.allDataPushed != nil{
                    self.arrOrders.removeFirst()
                    self.fetchOrderAndCallOrderAPI()
                }else{
                    if self.orderSaved != nil{
                        self.orderSaved!(order.id ?? 0, "Failed To Save Order.")
                        self.orderSaved = nil
                    }
                }
            }
            urlTask?.resume()
        }
    }
    
    func SaveReservation(reservation:ReservationModel, isDeleted:Bool){
        var dictParam = [String:Any]()
        var strURL = AppConstants.APIURL.kReservations
        
        if !isDeleted{
            let dictCustomer = NSMutableDictionary()
            if reservation.customer?.offline ?? 1 == 0{
                dictCustomer["id"] = reservation.customer?.id ?? 0
                dictParam["customer_id"] = reservation.customer?.id ?? 0
            }else{
                dictParam["customer_id"] = ""
                dictCustomer["id"] = ""
            }
            dictCustomer["name"] = reservation.customer?.name ?? ""
            dictCustomer["mobile"] = reservation.customer?.mobile ?? ""
            dictCustomer["email"] = reservation.customer?.email ?? ""
            dictCustomer["unique_id"] = reservation.customer?.uniqueId ?? ""
            
            dictParam["customer"] = AppCommonMethods.convertJsontoString(json: dictCustomer, shouldEncode: false)
            
            if reservation.tableId ?? 0 != 0{
                dictParam["table_id"] = reservation.tableId ?? 0
            }
            
            dictParam["telephone"] = reservation.customer?.mobile ?? ""
            dictParam["reservation_status_id"] = reservation.reservationStatusId ?? 0
            dictParam["updater_id"] = reservation.updaterId ?? 0
            if reservation.depositTypeId ?? 0 != 0{
                dictParam["deposit_type_id"] = reservation.depositTypeId ?? 0
            }
            if reservation.depositAmount ?? 0 != 0{
                dictParam["deposit_amount"] = reservation.depositAmount ?? 0
            }
            dictParam["diners"] = reservation.diners ?? 0
            dictParam["special_instruction"] = reservation.specialInstruction ?? ""
            dictParam["reservation_date_time"] = reservation.reservationDateTime ?? ""
            
            dictParam["unique_id"] = reservation.uniqueId
            if reservation.offline == 0{
                strURL = "\(AppConstants.APIURL.kReservations)/\(reservation.id ?? 0)"
            }
        }else{
            strURL = "\(AppConstants.APIURL.kReservations)/\(reservation.id ?? 0)"
            
        }
        let request = self.createAPIRequest(strURL: strURL, param: dictParam, method: isDeleted ? "DELETE" : "POST")
        
        if urlTask != nil{
            urlTask?.cancel()
            urlTask?.suspend()
            urlTask = nil
        }
        
        urlTask = URLSession.shared.dataTask(with: request) { (data, response, error) in
            self.urlTask = nil
            
            if (error != nil){
                print(error?.localizedDescription ?? "")
            }
            else{
                if let httpResponse = response as? HTTPURLResponse, var data = data{
                    if httpResponse.statusCode == 200{
                        if var string = String.init(data: data, encoding: .utf8){
                            if string.count > 87{
                                for _ in 1...15{
                                    let index = string.index(string.startIndex, offsetBy: string.count - 4, limitedBy: string.endIndex)!
                                    string.remove(at: index)
                                }
                                string.removeFirst(15)
                                for _ in 1...7{
                                    let index = string.index(string.startIndex, offsetBy: 8, limitedBy: string.endIndex)!
                                    string.remove(at: index)
                                }
                                for _ in 1...8{
                                    let index = string.index(string.startIndex, offsetBy: 14, limitedBy: string.endIndex)!
                                    string.remove(at: index)
                                }
                                for _ in 1...6{
                                    let index = string.index(string.startIndex, offsetBy: 22, limitedBy: string.endIndex)!
                                    string.remove(at: index)
                                }
                                for _ in 1...7{
                                    let index = string.index(string.startIndex, offsetBy: 28, limitedBy: string.endIndex)!
                                    string.remove(at: index)
                                }
                            }
                            if let newData = string.data(using: .utf8){
                                let aes = EasyAES.init(key: AppConstants.keyForAPI, bit: 256, andIV: AppConstants.ivForAPI)
                                data = aes.decryptData(newData)
                            }
                        }
                    }
                    let jsonData: Any?
                    do {
                        jsonData = try JSONSerialization.jsonObject(with: data, options:JSONSerialization.ReadingOptions.mutableContainers )
                        if AppConstants.isInDevlopmentMode{
                            print("Reservation Payment Response:",jsonData ?? "")
                        }
                        if httpResponse.statusCode == 200{
                            if let xRefreshToken = httpResponse.allHeaderFields["x-refresh-token"] as? String {
                                AppCommonMethods.saveDataIntoUserDefault(value: xRefreshToken, withKey: AppConstants.userDefaultKey.kRefreshHeaderToken)
                            }
                            if let xToken = httpResponse.allHeaderFields["x-token"] as? String {
                                AppCommonMethods.saveDataIntoUserDefault(value: xToken, withKey: AppConstants.userDefaultKey.kHeaderToken)
                            }
                            if let dictResponse = jsonData as? NSDictionary{
                                let jsonDecoder = JSONDecoder()
                                if let data = AppCommonMethods.convertToJson(object: dictResponse), let aData = try? jsonDecoder.decode(ReservationModel.self, from: data){
                                    if isDeleted{
                                        CoreDataHelper.shared.DeleteReservation(uniquId: aData.uniqueId, isFromAPI: true)
                                    }else{
                                        aData.offline = 0
                                        CoreDataHelper.shared.SaveReservationToDatabase(reservation: aData, oldCustomerId: reservation.customer?.id, update: 0, oldId: reservation.id ?? 0)
                                    }
                                    self.fetchReservationAndCallAPI()
                                    return
                                }
                            }
                        }else{
                            if httpResponse.statusCode == 401{
                                DispatchQueue.main.async {
                                    AppCommonMethods.removefromUserDefault(withKey: AppConstants.userDefaultKey.kUserData)
                                    AppCommonMethods.removefromUserDefault(withKey: AppConstants.userDefaultKey.kRefreshHeaderToken)
                                    AppCommonMethods.removefromUserDefault(withKey: AppConstants.userDefaultKey.kHeaderToken)
                                    AppConstants.isAdminLogin = false
                                    AppConstants.isSupervisorLogin = false
                                    if let VC = LoginVC.instance(){
                                        let navc = UINavigationController.init(rootViewController: VC)
                                        navc.isNavigationBarHidden = true
                                        AppConstants.appDelegate.window?.rootViewController = navc
                                    }
                                    if let dictResponse = jsonData as? NSDictionary{
                                        AppCommonMethods.showToastAlert(message: dictResponse.getStringValue("message") ?? "")
                                    }
                                }
                            }
                        }
                    } catch let error {
                        print(error.localizedDescription)
                    }
                }
            }
            if self.allDataPushed != nil{
                self.allDataPushed!()
                self.allDataPushed = nil
            }
        }
        urlTask?.resume()
    }
    
    func createAPIRequest(strURL:String, param:[String:Any], method:String = "POST")->URLRequest{
        var request = URLRequest(url:URL(string:strURL)!)
        request.httpMethod = method
        request.timeoutInterval = 60
        
        let jsonString = WebServiceManager().getPostString(params: param)
        
        if AppConstants.isInDevlopmentMode{
            print("Parameter:",jsonString)
            print("URL:",strURL)
        }
        
        let jsonData = jsonString.data(using: .utf8, allowLossyConversion: false)!
        request.httpBody  = jsonData
        
        if let token = AppCommonMethods.readObjfromUserDefault(withKey: AppConstants.userDefaultKey.kRefreshHeaderToken) as? String{
            request.setValue(token, forHTTPHeaderField: "x-refresh-token")
        }
        if let token = AppCommonMethods.readObjfromUserDefault(withKey: AppConstants.userDefaultKey.kHeaderToken) as? String{
            request.setValue(token, forHTTPHeaderField: "x-token")
        }
        
        if let id = AppConstants.businessData?.id{
            request.setValue("\(id)", forHTTPHeaderField: "business-id")
        }
        
        request.setValue(Bundle.main.bundleIdentifier ?? "", forHTTPHeaderField: "package-name")
        request.setValue("\(request.httpBody?.count ?? 0)", forHTTPHeaderField:"Content-Length")
        
        return request
    }
}
