//
//  TableViewCell.swift
//  EPOS
//
//  Created by Apple on 28/08/21.
//

import Foundation
import RangeSeekSlider
import SummerSlider

class PaymentItemCell: UITableViewCell {
    
    @IBOutlet weak var lblAmount:UILabel!
    @IBOutlet weak var lblTitle:UILabel!
    @IBOutlet weak var btnRefund:UIButton!
    
    override class func awakeFromNib() {
        
    }
}

class ReservationItemCell: UITableViewCell {
    
    @IBOutlet weak var lblName:UILabel!
    @IBOutlet weak var lblDiners:UILabel!
    @IBOutlet weak var lblDate:UILabel!
    @IBOutlet weak var lblTableNo:UILabel!
    @IBOutlet weak var lblContactNo:UILabel!
    @IBOutlet weak var btnName:UIButton!
    @IBOutlet weak var btnDiners:UIButton!
    @IBOutlet weak var btnDate:UIButton!
    @IBOutlet weak var btnSelect:UIButton!
    @IBOutlet weak var btnTableNo:UIButton!
    @IBOutlet weak var btnContactNo:UIButton!
    @IBOutlet weak var btnInstruction:UIButton!
    @IBOutlet weak var btnView:UIButton!
    @IBOutlet weak var btnPrint:UIButton!
    @IBOutlet weak var btnCancel:UIButton!
    @IBOutlet weak var btnSeatOnTable:UIButton!
    @IBOutlet weak var lblNoInstruction:UILabel!
    @IBOutlet weak var viewForBG:UIView!
    
    override class func awakeFromNib() {
        
    }
}

class VoucherItemCell: UITableViewCell {
    
    @IBOutlet weak var lblName:UILabel!
    @IBOutlet weak var lblContactNo:UILabel!
    @IBOutlet weak var lblEmail:UILabel!
    @IBOutlet weak var lblType:UILabel!
    @IBOutlet weak var lblStartDate:UILabel!
    @IBOutlet weak var lblEndDate:UILabel!
    @IBOutlet weak var lblAmount:UILabel!
    @IBOutlet weak var btnView:UIButton!
    @IBOutlet weak var btnPrint:UIButton!
    @IBOutlet weak var btnDelete:UIButton!
    @IBOutlet weak var btnCopy:UIButton!
    
    override class func awakeFromNib() {
        
    }
}

class ReservationHeaderCell: UITableViewCell {
    
    @IBOutlet weak var lblTitle:UILabel!
    
    override class func awakeFromNib() {
        
    }
}

class TransactionListCellView: UITableViewCell{
    
    @IBOutlet weak var lblAmount:UILabel!
    @IBOutlet weak var lblDate:UILabel!
    @IBOutlet weak var lblPaymentType:UILabel!
    @IBOutlet weak var btnSelect:UIButton!
    @IBOutlet weak var btnRefund:UIButton!
    @IBOutlet weak var btnReprint:UIButton!
    @IBOutlet weak var constlblTypeLeadingSpace:NSLayoutConstraint!
    
    override class func awakeFromNib() {
        
    }
}

class StatementListCellView: UITableViewCell{
    
    @IBOutlet weak var lblStatement:UILabel!
    @IBOutlet weak var lblPrice:UILabel!
    @IBOutlet weak var lblType:UILabel!
    @IBOutlet weak var btnViewStatement:UIButton!
    @IBOutlet weak var btnDownload:UIButton!
    
    override class func awakeFromNib() {
        
    }
}

class CardReaderViewCell: UITableViewCell {
    
    @IBOutlet weak var lblName:UILabel!
    @IBOutlet weak var imgSelect:UIImageView!
    
    override class func awakeFromNib() {
        
    }
}

class ExclusionsViewCell: UITableViewCell {
    
    @IBOutlet weak var lblName:UILabel!
    @IBOutlet weak var imgSelect:UIImageView!
    @IBOutlet weak var viewForSelect:UIViewX!
    
    override class func awakeFromNib() {
        
    }
}

class SideMenuListCell: UITableViewCell {
    
    @IBOutlet weak var lblTitle:UILabel!
    @IBOutlet weak var lblCount:UILabel!
    @IBOutlet weak var imgView:UIImageViewX!
    @IBOutlet weak var viewNotification:UIView!
    @IBOutlet weak var constCountWidth:NSLayoutConstraint!
    
    override class func awakeFromNib() {
        
    }
}

class BusinessListCell: UITableViewCell {
    @IBOutlet weak var lblName:UILabel!
    @IBOutlet weak var imgSelect:UIImageView!
    
    override class func awakeFromNib() {
        
    }
}

class PrepLocationCell: UITableViewCell {
    
    @IBOutlet weak var lblName:UILabel!
    @IBOutlet weak var imgSelection:UIImageView!
    @IBOutlet weak var btnDelete:UIButton!
    
    override class func awakeFromNib() {
        
    }
}

class CustomerViewCell:UITableViewCell{
    
    @IBOutlet weak var lblName:UILabel!
    @IBOutlet weak var lblMobileNo:UILabel!
    @IBOutlet weak var lblPostcode:UILabel!
    @IBOutlet weak var btnEdit:UIButton!
    
    override class func awakeFromNib() {
        
    }
}

class CartViewCell:UITableViewCell{
    
    @IBOutlet weak var lblItemName:UILabel!
    @IBOutlet weak var lblItemPrice:UILabel!
    @IBOutlet weak var lblItemQuantity:UILabel!
    @IBOutlet weak var lblAddons:UILabel!
    
    override class func awakeFromNib() {
        
    }
}

class ReportListViewCell:UITableViewCell{
    
    @IBOutlet weak var lblTitle:UILabel!
    
    override class func awakeFromNib() {
        
    }
}

class GroupHeaderCell: UITableViewCell {
    
    @IBOutlet weak var btnGroup:UIButton!
    
    override class func awakeFromNib() {
        
    }
}

class ReportDetailViewCell:UITableViewCell{
    
    @IBOutlet weak var lblType:UILabel!
    @IBOutlet weak var lblQuantity:UILabel!
    @IBOutlet weak var lblValue:UILabel!
    
    override class func awakeFromNib() {
        
    }
}

class UserDropdownCell:UITableViewCell{
    
    @IBOutlet weak var lblUserName:UILabel!
    
    override class func awakeFromNib() {
        
    }
}

class OrderPriceInfoCell:UITableViewCell, UITableViewDataSource{
    
    @IBOutlet weak var lblTotalPrice:UILabel!
    @IBOutlet weak var lblPaymentMode:UILabel!
    @IBOutlet weak var lblCardNo:UILabel!
    @IBOutlet weak var lblSubTotal:UILabel!
    @IBOutlet weak var lblWalletAmount:UILabel!
    @IBOutlet weak var lblServiceFee:UILabel!
    @IBOutlet weak var lblDeliveryFee:UILabel!
    @IBOutlet weak var lblDiscount:UILabel!
    @IBOutlet weak var lblDriverTip:UILabel!
    @IBOutlet weak var lblDriverTipTitle:UILabel!
    @IBOutlet weak var lblRestaurantTax:UILabel!
    @IBOutlet weak var lblRewardDiscount:UILabel!
    @IBOutlet weak var lblCharity:UILabel!
    @IBOutlet weak var tblPayments:UITableView!
    @IBOutlet weak var constPaymentHeight:NSLayoutConstraint!
    @IBOutlet weak var lblDiscountTitle:UILabel!
    var arrPayments = [PaymentOrderModel]()
    var arrSurcharge = [SurchargeModel]()
    @IBOutlet weak var tblSurcharge: UITableView!
    @IBOutlet weak var constSurchargeHeight:NSLayoutConstraint!
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        if tblSurcharge != nil{
            if tableView == tblSurcharge{
                return arrSurcharge.count
            }
        }
        return arrPayments.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        if tblSurcharge != nil{
            if tableView == tblSurcharge{
                let cell = tableView.dequeueReusableCell(withIdentifier: "SurchargeCell", for: indexPath) as! SurchargeCell
                let surcharge = arrSurcharge[indexPath.row]
                cell.lblName.text = surcharge.surchargeName
                cell.lblPrice.text = String.init(format: "%@%.2f", AppConstants.currencySign,surcharge.surchargeAmount)
                return cell
            }
        }
        let cell = tableView.dequeueReusableCell(withIdentifier: "PaymentItemCell", for: indexPath) as! PaymentItemCell
        let model = arrPayments[indexPath.row]
        cell.lblTitle.text = "Paid via \(model.paymentMethodName ?? "")"
        cell.lblAmount.text = String.init(format: "%@%.2f", AppConstants.currencySign, model.amount ?? 0)
        cell.btnRefund.tag = indexPath.row
        cell.btnRefund.isSelected = model.isRefunded == 1
        return cell
    }
}

class PaymentDashboardCell: UITableViewCell {
    
    @IBOutlet weak var lblTitle:UILabel!
    @IBOutlet weak var imgArrow:UIImageViewX!
    @IBOutlet weak var viewForBG:UIView!
    
    override class func awakeFromNib() {
        
    }
}

class AddOnsViewCell:UITableViewCell{
    
    @IBOutlet weak var lblAddOnName:UILabel!
    @IBOutlet weak var constLblLeadingSpace:NSLayoutConstraint!
    @IBOutlet weak var viewForBG:UIView!
    @IBOutlet weak var btnSelect:UIButtonX!
    var model:AddOnModel?
    
    override class func awakeFromNib() {
        
    }
}

class UsersListCell: UITableViewCell {
    
    @IBOutlet weak var lblUsers:UILabel!
    @IBOutlet weak var btnUser:UIButton!
    @IBOutlet weak var switchLogin:UISwitch!
    
    override class func awakeFromNib() {
        
    }
}

class ProductsListCell: UITableViewCell, UIScrollViewDelegate {
    
    @IBOutlet weak var txtQuantity:UITextField!
    @IBOutlet weak var lblQuantity:UILabel!
    @IBOutlet weak var lblName:UILabel!
    @IBOutlet weak var lblPrice:UILabel!
    @IBOutlet weak var lblDescription:UILabel!
    @IBOutlet weak var btnDelete:UIButton!
    @IBOutlet weak var btnMinus:UIButton!
    @IBOutlet weak var btnPlus:UIButton!
    @IBOutlet weak var btnView:UIButton!
    @IBOutlet weak var constStackBottomSpace:NSLayoutConstraint!
    @IBOutlet weak var lblMinus:UILabel!
    @IBOutlet weak var imgDelete:UIImageView!
    @IBOutlet weak var btnViewMore:UIButton!
    @IBOutlet weak var btnTopViewMore:UIButton!
    @IBOutlet weak var scrollView:UIScrollView!
    
    override class func awakeFromNib() {
        
    }
    
    override func prepareForReuse() {
        if scrollView != nil{
            scrollView.setContentOffset(.zero, animated: false)
        }
    }
}

class OnlineOptionViewCell: UITableViewCell {
    
    @IBOutlet weak var lblTitle:UILabel!
    @IBOutlet weak var switchOption:UISwitch!
    
    override class func awakeFromNib() {
        
    }
}

class AutoDiscountCell: UITableViewCell {
    
    @IBOutlet weak var lblSpentAmount:UILabel!
    @IBOutlet weak var lblOfferTitle:UILabel!
    @IBOutlet weak var lblOfferAmount:UILabel!
    @IBOutlet weak var lblVoucherCode:UILabel!
    @IBOutlet weak var btnOffer:UIButton!
    @IBOutlet weak var btnSpent:UIButton!
    @IBOutlet weak var btnEditCode:UIButton!
    @IBOutlet weak var btnRemove:UIButton!
    @IBOutlet weak var btnDelivery:UIButton!
    @IBOutlet weak var btnCollection:UIButton!
    @IBOutlet weak var btnDineIn:UIButton!
    @IBOutlet weak var btnToDate:UIButton!
    @IBOutlet weak var btnFromDate:UIButton!
    @IBOutlet weak var lblFromDate:UILabel!
    @IBOutlet weak var lbltoDate:UILabel!
    
    override class func awakeFromNib() {
        
    }
}

class DeliveryFeeCell: UITableViewCell {
    
    @IBOutlet weak var lblDeliveryFee:UILabel!
    @IBOutlet weak var lblDeliveryFeeTitle:UILabel!
    @IBOutlet weak var lblDeliveryDitance:UILabel!
    @IBOutlet weak var btnDeliveryFee:UIButton!
    @IBOutlet weak var btnDeliveryDistance:UIButton!
    @IBOutlet weak var btnRemove:UIButton!
    
    override class func awakeFromNib() {
        
    }
}

class DeliveryHourCell: UITableViewCell {
    
    @IBOutlet weak var lblDayName:UILabel!
    @IBOutlet weak var lblTiming:UILabel!
    @IBOutlet weak var lblStatus:UILabel!
    @IBOutlet weak var switchStatus:UISwitch!
    @IBOutlet weak var btnEditTime:UIButton!
    @IBOutlet weak var viewForSlider:RangeSeekSlider!
    
    override class func awakeFromNib() {
        
    }
}

class ChatListViewCell: UITableViewCell{
    
    @IBOutlet weak var imgProfile:UIImageView!
    @IBOutlet weak var lblUserName:UILabel!
    @IBOutlet weak var lblDate:UILabel!
    @IBOutlet weak var lblImgTag:UILabel!
    @IBOutlet weak var lblUnreadCount:UILabel!
    @IBOutlet weak var lblLastMessage:UILabel!
    
    override class func awakeFromNib() {
        
    }
}

class ChatHeaderViewCell: UITableViewCell {
    
    @IBOutlet weak var lblDate:UILabel!
    
    override class func awakeFromNib() {
        
    }
}

class ChatViewCell: UITableViewCell {

    @IBOutlet weak var lblMessage:UILabel!
    @IBOutlet weak var lblDate:UILabel!
    @IBOutlet weak var lblStartTime:UILabel!
    @IBOutlet weak var lblEndTime:UILabel!
    @IBOutlet weak var btnPlay:UIButtonX!
    @IBOutlet weak var btnFailed:UIButton!
    @IBOutlet weak var constFailedWidth:NSLayoutConstraint!
    @IBOutlet weak var imgMessage:UIImageView!
    @IBOutlet weak var viewForBG:UIViewX!
    @IBOutlet weak var viewForSlider:SummerSlider!
    
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
        if viewForSlider != nil{
            viewForSlider.setThumbImage(UIImage.init(named: "slider_dot"), for: .normal)
        }
    }
}

class PreOrderViewCell:UITableViewCell{
    
    @IBOutlet weak var lblWeekDay:UILabel!
    @IBOutlet weak var lblTakingPreOrder:UILabel!
    @IBOutlet weak var lblPreOrderTime:UILabel!
    @IBOutlet weak var switchPreOrder:UISwitch!
    @IBOutlet weak var btnPreOrder:UIButton!
    @IBOutlet weak var imgDownArrow:UIImageView!
    
    override class func awakeFromNib() {
        
    }
}

class PaymentLinkCell:UITableViewCell{
    
    @IBOutlet weak var lblPhoneNo:UILabel!
    @IBOutlet weak var lblAmount:UILabel!
    @IBOutlet weak var lblDate:UILabel!
    @IBOutlet weak var lblStatus:UILabel!
    @IBOutlet weak var imgStatus:UIImageViewX!
    @IBOutlet weak var btnResend:UIButton!
    
    override class func awakeFromNib() {
        
    }
    
}
