//
//  Protocols.swift
//  EPOS
//
//  Created by Apple on 26/04/21.
//

import Foundation

protocol NewOrderDelegate:AnyObject {
    func orderTypeSelected(orderType:OrderTypesModel?)
    func requestForNewOrder(customer:CustomerModel, orderType:OrderTypesModel?, delivery:DeliveryChargeModel?, table:TableModel?, noOfGuest:Int?)
}

protocol OrderTypeDelegate:AnyObject {
    func orderTypeChange(orderType:OrderTypesModel,oldTable:TableModel?)
}

protocol SwapTableDelegate:AnyObject {
    func tableSelected(table:TableModel, orderType:OrderTypesModel?, isMergedTable:Bool)
}

protocol AlertControllerDelegate: AnyObject {
    func alertButtonAction(index:Int,data:alertViewData,type:AlertType)
}

protocol AddGratuityDelegate: AnyObject {
    func cancelCliked()
    func amountAdded(amount:Double,type:GratityViewType)
}

protocol PrepLocationDelegate:AnyObject {
    func prepLocationSelected(product:OrderProductModel?)
}

protocol SendOrderDelegate:AnyObject {
    func sendOrder(index:Int)
}

protocol ProductDelegate:AnyObject {
    func productModified(product:OrderProductModel,index:Int?)
    func deleteProduct()
    func assignToProduct(isAddon:Bool, product:ProductModel?)
}

protocol CommentDelegate:AnyObject {
    func cancelClicked()
    func commentAdded(comment:String)
}

protocol PaymentDelegate:AnyObject {
    func paymentDone()
}

protocol ReservationTimeDelegate:AnyObject {
    func timeSelected(selectedTime:String)
}

protocol CardReaderDelegate:AnyObject {
    func cardReaderSelected(reader:Any?)
}

protocol OrderCreditCardDelegate:AnyObject {
    func creditCardSelection(index:Int)
}

protocol CardInfoDelegate:AnyObject {
    func cardData(cardNumber:String,expYear:UInt,expMonth:UInt,cardHolder:String,cvc:String)
}

protocol OrderActionDelegate:AnyObject {
    func timeSlotSelected(strTimeslot:String?,isDelayTime:Bool)
    func reminderDateSet()
}

protocol DateRangeDelegate:AnyObject {
    func dateSelected(toDate:String,fromDate:String)
}

protocol pageRefreshDelegate:AnyObject {
    func pageNeedToRefresh()
}

protocol ReservationDelegate:AnyObject {
    func cancelReservation()
    func AcceptReservation()
}

protocol AddDiscountCodeDelegate: AnyObject {
    func discountCodeAdded(voucher:RestaurantVoucherModel)
}

protocol EditRestaurantDelegate: AnyObject {
    func restaurantUpdated()
}

protocol SelectOrderDelegate:AnyObject {
    func orderSelected(order:WebOrderModel)
}
