//
//  PrinterManager.swift
//  TiffinTomPartner
//
//  Created by Tushar Premal on 18/02/21.
//

import Foundation
import UIKit

class PrintManager:NSObject {
    
    static let shared = PrintManager()
    private var printerObject:Any?
    var shouldPrintKitchenCopy = true
    var orderType = ""
    private let portNumber = 9100
    private let printer = ThermalPrinterFactory.create()
    var parentViewController:UIViewController!
    var isCustomerCopy = false
    var isReprint = false
    var amount = 0.0
    var tipAmount = 0.0
    var refundAmount = 0.0
    var cardNumber = ""
    var cardBrand = ""
    var TID = ""
    var status = ""
    var entryMode = ""
    var arrOrderPrepId = [String]()
    var selectedPrepId = ""
    var dictProduct = [String:[OrderProductModel]]()
    var dictFailedProduct = [String:[OrderProductModel]]()
    var isPrintingBill = false
    var isPrintAll = false
    var shouldOpenDrawer = false
    var reportType = RerportType.kFullReport
    var selectedUserName:String?
    var strHeaderDate = ""
    var splitGroup:OrderGroupModel?
    var arrGroups = [OrderGroupModel]()
    var isSplitBillCopy = false
    var arrReservationDay = [String]()
    var orderSendAction = 0
    var stopPrintForNotification: ((_ orderId:Int?) -> Void)?
    var printingStoped: (() -> Void)?
    var isPrinterConnected = false
    var isBanquetOrder = false
    var isFromNotification = false
    var isFromSuccess = false
    
    override init() {
        super.init()
        addObserver()
    }
    
    func addObserver(){
        NotificationCenter.default.addObserver(self, selector: #selector(connectedToPrinter), name: NSNotification.Name.PrinterConnected, object: nil)
        NotificationCenter.default.addObserver(self, selector: #selector(disconnectedToPrinter), name: NSNotification.Name.PrinterDisconnected, object: nil)
    }
    
    @objc private func connectedToPrinter() {
        print("Printer is connected")
        isPrinterConnected = true
        
        showPrinterConnectionStatus(isConnected: true)

        guard let printerObject = printerObject else {
            if AppConstants.isInDevlopmentMode {
                AppCommonMethods.showToastAlert(message: "Printer object not found")
            }
            self.printerObject = nil
            return
        }

        switch printerObject {
        case let obj as WebOrderModel:
            if AppConstants.businessData?.printLogo ?? false {
                downloadImageAndPrint(object: obj)
            } else {
                shouldPrintKitchenCopy ? printWebOrderCopy(orderDetail: obj) : printWebOrderCopy(orderDetail: obj, isKitchenCopy: false)
            }

        case let obj as OnlineReservationModel:
            printOnlineBookingCopy(bookingDetail: obj)

        case let obj as OrderModel:
            
            downloadImageAndPrint(object: obj)
        case is PaymentOrderModel:
            openCashDrawer()
        case let obj as MerchantReportModel:
            downloadImageAndPrint(object: obj)

        default:
            downloadImageAndPrint(object: printerObject)
        }
    }

    // MARK: - Handle Disconnection

    @objc private func disconnectedToPrinter() {
        print("Printer is disconnected")
        showPrinterConnectionStatus(isConnected: false)

        switch printerObject {
        case is BusinessModel:
//            AppCommonMethods.stopProgressBar()
            if status != "Declined" && !isFromNotification {
                parentViewController.navigationController?.popToRootViewController(animated: true)
            }

        case let model as OrderModel:
            handleOrderDisconnection(model: model)

        default:
//            AppCommonMethods.stopProgressBar()
            cleanupAfterDisconnection()
        }
    }

    // MARK: - Helper Functions

    private func showPrinterConnectionStatus(isConnected: Bool) {
        guard AppConstants.isInDevlopmentMode else { return }

        let statusMessage = isConnected ? "Printer Connected" : "Printer Disconnected"
        let printerIP = AppConstants.selectedPrinter?.ip ?? ""

        if let _ = printerObject as? OrderModel {
            if isPrintingBill {
                AppCommonMethods.showToastAlert(message: "\(statusMessage), Printer IP: \(printerIP)")
            } else if let location = CoreDataHelper.shared.fetchPrepLocationData(id: Int(selectedPrepId) ?? 0),
                      let ip = location.printerIP {
                AppCommonMethods.showToastAlert(message: "\(statusMessage), Printer IP: \(ip)")
            }
        } else {
            AppCommonMethods.showToastAlert(message: "\(statusMessage), Printer IP: \(printerIP)")
        }
    }

    private func printOrderCopyIfAvailable(order: OrderModel, image:UIImage?) {
        if let arr = dictProduct[selectedPrepId] {
            printOrderCopy(order: order, arrProduct: arr, image: image)
        }
    }

    private func handleOrderDisconnection(model: OrderModel) {
        if isPrintingBill {
            stopPrintForNotification?(model.id)
            cleanupAfterDisconnection()
            self.printingStoped?()
        } else {
            printNextOrderCopy(isFromFailed: !isFromSuccess)
        }
    }

    private func cleanupAfterDisconnection() {
        DispatchQueue.main.async {
            AppCommonMethods.stopProgressBar()
        }
        splitGroup = nil
        printerObject = nil
    }
    
    func connectToPrinterWithPrint(model: Any, controller: UIViewController) {
        var printerIP = AppConstants.selectedPrinter?.ip ?? ""

        if let _ = model as? PaymentOrderModel{
            if let prepId = Int(AppCommonMethods.fetchSiteSettingValue(key: "default_printer_for_cash_drawer") ?? ""),
               let printer = AppConstants.businessData?.printers?.first(where: { $0.id == prepId }) {
                printerIP = printer.ip ?? ""
            }
        }else if let _ = model as? BusinessModel, self.entryMode == "MOTO" || self.entryMode == "Terminal"{
            if let prepId = Int(AppCommonMethods.fetchSiteSettingValue(key: "default_printer_for_card_payment") ?? ""),
               let printer = AppConstants.businessData?.printers?.first(where: { $0.id == prepId }) {
                printerIP = printer.ip ?? ""
            }
        }else if let _ = model as? WebOrderModel, self.shouldPrintKitchenCopy {
            if let prepId = Int(AppCommonMethods.fetchSiteSettingValue(key: "default_prep_location_for_web") ?? ""),
               let printer = AppConstants.businessData?.printers?.first(where: { $0.id == prepId }) {
                printerIP = printer.ip ?? ""
            } else {
                DispatchQueue.main.async {
                    AppCommonMethods.stopProgressBar()
                    AppCommonMethods.showToastAlert(message: "No prep location found")
                }
                return
            }
        }

        guard !printerIP.isEmpty else {
            self.printingStoped?()
            AppCommonMethods.showToastAlert(message: "Printer IP not found")
            return
        }

//        DispatchQueue.main.async {
//            AppCommonMethods.startProgressBar()
//        }

        self.parentViewController = controller
        self.printerObject = model

        let interface = WIFIFactory.create()
        interface?.address = printerIP
        interface?.port = portNumber
        interface?.printerCmdtype = PrinterCmdESC

        printer?.printerPi = interface
        printer?.open()
        isPrinterConnected = false
    }
    
    func connectToPrinterWithPrintOrder(order: OrderModel, controller: UIViewController, isPrintAll: Bool = false) {
        DispatchQueue.main.async {
            AppCommonMethods.startProgressBar()
        }
        isFromSuccess = false
        self.isSplitBillCopy = false
        self.isPrintingBill = false
        self.isPrintAll = isPrintAll
        self.parentViewController = controller
        self.printerObject = order
        self.isPrinterConnected = false
        self.dictProduct.removeAll()

        var prepIds = Set<String>()

        for product in order.arrProducts {
            if !product.isDelete{
                guard let prepLocationId = getPreparationLocationId(for: product, order: order) else { continue }
                
                
                    if order.orderActionId == 3 || order.orderActionId == 4, product.sentToKitchenQuantity == 0 {
                        continue
                    }
                

                if var arr = dictProduct[prepLocationId]{
                    arr.append(product)
                    dictProduct[prepLocationId] = arr
                }else{
                    dictProduct[prepLocationId] = [product]
                    prepIds.insert(prepLocationId)
                }
            }
        }

        updateOrderPrepIds(from: prepIds)

        if let selectedPrepId = arrOrderPrepId.first {
            self.selectedPrepId = selectedPrepId
            connectToPrinter()
        } else {
            handleNoPrepLocationFound(order)
        }
    }

    // MARK: - Helper Functions

    private func getPreparationLocationId(for product: OrderProductModel, order: OrderModel) -> String? {
        if product.misc == 1 { return nil } // Ignore miscellaneous items

        if isBanquetOrder {
            return "\(product.product?.banquetPreparationLocationId ?? 0)"
        }

        switch order.orderTypeId {
        case 2, 5:
            return "\(product.product?.takeawayPreparationLocationId ?? 0)"
        case 3:
            return "\(product.product?.deliveryPreparationLocationId ?? 0)"
        default:
            return "\(product.product?.preparationLocationId ?? 0)"
        }
    }

    private func updateOrderPrepIds(from prepIds: Set<String>) {
        arrOrderPrepId = CoreDataHelper.shared.fetchPrepLocationData()
            .compactMap { loc in prepIds.contains(loc.id?.description ?? "") ? loc.id?.description : nil }
    }

    private func handleNoPrepLocationFound(_ order: OrderModel) {
        if AppConstants.isInDevlopmentMode {
            AppCommonMethods.showToastAlert(message: "Prep location not found")
        }

        if isPrintAll, AppConstants.userData?.permissions?.printBill?.actions?.list == 1 {
            isPrintingBill = true
            connectToPrinterWithPrint(model: printerObject!, controller: parentViewController)
        } else {
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
            }
            self.printerObject = nil
            self.stopPrintForNotification?(order.id)
            self.printingStoped?()
            DispatchQueue.main.asyncAfter(deadline: .now() + 0.1) {
                NotificationCenter.default.post(name: AppConstants.notifications.kDatabasePushed, object: nil)
            }
        }
    }
    
    func connectToPrinterWithPrintOrder(order: OrderModel, dictProducts: [String:[OrderProductModel]]) {
        DispatchQueue.main.async {
            AppCommonMethods.startProgressBar()
        }
        isFromSuccess = false
        self.dictProduct = dictProducts
        self.isPrinterConnected = false
        self.arrOrderPrepId = getValidPrepIds(from: dictProducts)

        if let selectedPrepId = arrOrderPrepId.first {
            self.selectedPrepId = selectedPrepId
            connectToPrinter()
        } else {
            handleNoPrepLocationFound()
        }
    }

    // MARK: - Helper Functions
    private func getValidPrepIds(from dictProducts: [String: [OrderProductModel]]) -> [String] {
        let prepIds = Set(dictProducts.keys) // Directly access keys as Set<String>
        
        return CoreDataHelper.shared.fetchPrepLocationData()
            .compactMap { $0.id?.description }
            .filter(prepIds.contains) // More concise and efficient check
    }


    private func handleNoPrepLocationFound() {
        if AppConstants.isInDevlopmentMode {
            AppCommonMethods.showToastAlert(message: "Prep location not found")
        }

        if shouldPrintBill() {
            isPrintingBill = true
            connectToPrinterWithPrint(model: printerObject!, controller: parentViewController)
        } else {
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
            }
            completePrintingProcess()
        }
    }

    private func shouldPrintBill() -> Bool {
        return isPrintAll && (AppConstants.userData?.permissions?.printBill?.actions?.list ?? 0) == 1 && !isPrintingBill
    }

    private func completePrintingProcess() {
        self.printerObject = nil
        self.printingStoped?()
        
        DispatchQueue.main.asyncAfter(deadline: .now() + 0.1) {
            NotificationCenter.default.post(name: AppConstants.notifications.kDatabasePushed, object: nil)
        }
    }

    // MARK: - Printing Next Copy

    func printNextOrderCopy(isFromFailed: Bool) {
        if !arrOrderPrepId.isEmpty {
            if isFromFailed {
                dictFailedProduct[selectedPrepId] = dictProduct[selectedPrepId]
            }

            arrOrderPrepId.removeFirst()

            if let nextPrepId = arrOrderPrepId.first {
                selectedPrepId = nextPrepId
                connectToPrinter()
            } else {
                finalizePrinting()
            }
        } else {
            finalizePrinting()
        }
    }

    private func finalizePrinting() {
        if shouldPrintBill() {
            isPrintingBill = true
            connectToPrinterWithPrint(model: printerObject!, controller: parentViewController)
        }

        if shouldOpenCashDrawer() {
            openCashDrawer()
        }

        isPrinterConnected = false
        notifyPrintingCompletion()
    }

    private func shouldOpenCashDrawer() -> Bool {
        return (AppCommonMethods.fetchSiteSettingValue(key: "open_cash_drawer_after_send_to_kitchen") ?? "") == "yes" &&
               (AppConstants.userData?.permissions?.cashdrawer?.actions?.list ?? 0) == 1
    }

    private func notifyPrintingCompletion() {
        if let orderId = (printerObject as? OrderModel)?.id {
            stopPrintForNotification?(orderId)
        }
        printingStoped?()
    }
    
    func connectToPrinter(){
        if let location = CoreDataHelper.shared.fetchPrepLocationData(id: Int(selectedPrepId) ?? 0),let ip = location.printerIP, ip != ""{
            isFromSuccess = false
            let interface = WIFIFactory.create()
            interface?.address = ip
            interface?.port = portNumber
            interface?.printerCmdtype = PrinterCmdESC
            printer?.printerPi = interface
            printer?.open()
        }else{
            self.printNextOrderCopy(isFromFailed: true)
        }
        
    }
    
    func printMotoPrint(object:BusinessModel,image:UIImage?){
        let footerA = AppCommonMethods.fetchSiteSettingValue(key: "footer_a", lowercased: false) ?? ""
        let footerB = AppCommonMethods.fetchSiteSettingValue(key: "footer_b", lowercased: false) ?? ""
        let header = AppCommonMethods.fetchSiteSettingValue(key: "ticket_header", lowercased: false) ?? ""
        let type = AppCommonMethods.fetchSiteSettingValue(key: "ticket_header_type") ?? ""
        let curencyCode = AppConstants.businessData?.country?.currencyCode ?? ""
        if image != nil{
            let imageCMD = ESCFactory.create()
            imageCMD?.clear()
            imageCMD?.encodingType = Encoding_UTF8
            imageCMD?.append(imageCMD?.getHeaderCmd())
            let bitmapSetting = self.printer?.bitmapSetts
            bitmapSetting?.alignmode = Align_Center
            bitmapSetting?.limitWidth = 30*8
            imageCMD?.append(imageCMD?.getBitMapCmd(bitmapSetting, image: image))
            imageCMD?.append(imageCMD?.getPrintEnd(1))
            printer?.write(imageCMD?.getCmd())
        }
        
        let textCMD = ESCFactory.create()
        textCMD?.clear()
        textCMD?.encodingType = Encoding_GBK
        textCMD?.append(textCMD?.getHeaderCmd())
        
        let textst = self.printer?.textSets
        textst?.isUnderline = Set_DisEnable
        
        textst?.isBold = Set_Enabled
        textst?.isTimes_Wide = Set_DisEnable
        textst?.isTimes_Heigh = Set_DisEnable
        
        if type == "center"{
            textst?.alignmode = Align_Center
        }else if type == "right"{
            textst?.alignmode = Align_Right
        }else{
            textst?.alignmode = Align_Left
        }
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "\(header)\n"))
        
        
        textst?.alignmode = Align_Center
        textst?.isTimes_Wide = Set_Enabled
        textst?.isTimes_Heigh = Set_Enabled
        
        if self.isCustomerCopy{
            textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "Customer Copy\n"))
        }else{
            textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "Merchant Copy\n"))
        }
        if self.isReprint{
            textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "Reprint\n"))
        }
        textst?.isBold = Set_DisEnable
        textst?.isTimes_Wide = Set_DisEnable
        textst?.isTimes_Heigh = Set_DisEnable
        textst?.alignmode = Align_Left
        
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "\n------------------------------------------------\n"))
        
        textst?.isBold = Set_Enabled
        textst?.isTimes_Wide = Set_Enabled
        textst?.isTimes_Heigh = Set_Enabled
        
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: String.init(format: "%.2f %@\n", self.amount, curencyCode)))
        if self.tipAmount > 0{
            textCMD?.append(textCMD?.getCmdWithPrint(textst, text: String.init(format: "Tip %.2f %@\n", self.tipAmount, curencyCode)))
        }
        
        textst?.isTimes_Wide = Set_DisEnable
        textst?.isTimes_Heigh = Set_DisEnable
        textst?.isBold = Set_DisEnable
        
        if self.cardBrand != ""{
            textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "\nCard         :\(self.cardBrand)\n"))
        }
        if self.cardNumber != ""{
            textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "Account      :\(self.cardNumber)\n"))
        }
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "TID          :\(self.TID)\n"))
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "Entry Mode   :\(self.entryMode)\n"))
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "Status       :\(self.status)\n\n"))
        
        textst?.alignmode = Align_Center
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "\(Date().getDateInString(format: "dd-MM-yyyy hh:mm a"))\n\n"))
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "Please Retain Receipt\nFor Your Record"))
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "\n------------------------------------------------\n"))
        
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "\(footerA)\n"))
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "\(footerB)\n\n\n"))
        
        textCMD?.append(textCMD?.getLFCmd())
        textCMD?.append(textCMD?.getLFCmd())
        textCMD?.append(textCMD?.getLFCmd())
        textCMD?.append(textCMD?.getLFCmd())
        
        textCMD?.append(textCMD?.getCutPaperCmd(CutterMode_Full))
        
        self.printer?.write(textCMD?.getCmd())
        
        self.printerObject = nil
        self.printer?.close()
        
        DispatchQueue.main.async {
            AppCommonMethods.stopProgressBar()
            if self.isCustomerCopy{
                //self.parentViewController.navigationController?.popToRootViewController(animated: true)
            }else{
                AppValidation().showAlertView(parentVC: self.parentViewController, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.ALERT_CUSTOMER_COPY, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_NO,AppConstants.GlobalAlert.ALERT_BTN_YES]) { (index) in
                    if index == 1{
                        self.isCustomerCopy = true
                        self.connectToPrinterWithPrint(model: object, controller: self.parentViewController)
                    }else{
                        if self.status != "Declined" && !self.isFromNotification{
                            self.parentViewController.navigationController?.popToRootViewController(animated: true)
                        }
                    }
                }
            }
        }
    }
    
    func downloadImageAndPrint(object: Any) {
        let logoURL = AppCommonMethods.fetchSiteSettingValue(key: "logo", lowercased: false) ?? ""
        
        AppCommonMethods.DownloadImageFromURL(strURL: logoURL) { (image, error) in
            if let error = error {
                AppCommonMethods.showToastAlert(message: error)
                return
            }

            switch object {
            case let obj as BusinessModel:
                self.printMotoPrint(object: obj, image: image)

            case let obj as FullReportModel:
                self.printReport(report: obj, image: image)

            case let obj as [ReportModel]:
                self.printReportList(arrReports: obj, image: image)

            case let obj as ReservationModel:
                self.printBookingCopy(bookingDetail: obj, image: image)

            case let obj as WebOrderModel:
                self.shouldPrintKitchenCopy
                    ? self.printWebOrderCopy(orderDetail: obj)
                    : self.printWebOrderCopy(orderDetail: obj, isKitchenCopy: false)

            case let obj as OrderModel:
                self.isPrintingBill ? self.processOrderPrinting(order: obj, image: image) : self.printOrderCopyIfAvailable(order: obj, image: image)
            case let obj as VoucherModel:
                self.printVoucher(voucher: obj, image: image)
            case let obj as MerchantReportModel:
                self.printTransactionReport(object: obj, image: image)

            case let obj as [String: [Any]]:
                self.printReservation(dictReservation: obj, image: image)

            default:
                if AppConstants.isInDevlopmentMode {
                    AppCommonMethods.showToastAlert(message: "Printing object not found")
                }
            }
        }
    }

    // MARK: - Order Processing Helper Function
    private func processOrderPrinting(order: OrderModel, image: UIImage?) {
        if !arrGroups.isEmpty {
            let serialQueue = DispatchQueue(label: "com.queue.PrintBillCopy")

            for (index, group) in arrGroups.enumerated() {
                serialQueue.sync {
                    self.splitGroup = group
                    self.printOrderBill(order: order, image: image)
                }

                if index == arrGroups.count - 1 {
                    serialQueue.sync {
                        self.cleanupAfterPrinting()
                    }
                }
            }
        } else if let splitCount = order.splitCount, splitCount > 0, isSplitBillCopy {
            let serialQueue = DispatchQueue(label: "com.queue.PrintBillCopy")
            for _ in 1...splitCount {
                serialQueue.sync {
                    self.printOrderBill(order: order, image: image)
                }
            }
        } else {
            self.printOrderBill(order: order, image: image)
        }
    }

    // MARK: - Cleanup Function
    private func cleanupAfterPrinting() {
        isPrinterConnected = false
        printer?.close()
        DispatchQueue.main.async {
            AppCommonMethods.stopProgressBar()
        }
        arrGroups.removeAll()
    }
    
    func printOnlineBookingCopy(bookingDetail:OnlineReservationModel){
        //        if printer?.isOpen ?? false{
        let imageCMD = ESCFactory.create()
        imageCMD?.clear()
        imageCMD?.encodingType = Encoding_UTF8
        imageCMD?.append(imageCMD?.getHeaderCmd())
        let bitmapSetting = printer?.bitmapSetts
        bitmapSetting?.alignmode = Align_Center
        bitmapSetting?.limitWidth = 30*8
        
        let img = UIImage.init(named: "ic_logo")!
        imageCMD?.append(imageCMD?.getBitMapCmd(bitmapSetting, image: img))
        imageCMD?.append(imageCMD?.getPrintEnd(1))
        printer?.write(imageCMD?.getCmd())
        
        let textCMD = ESCFactory.create()
        textCMD?.clear()
        textCMD?.encodingType = Encoding_GBK
        textCMD?.append(textCMD?.getHeaderCmd())
        
        let textst = printer?.textSets
        textst?.isUnderline = Set_DisEnable
        textst?.isTimes_Wide = Set_DisEnable
        textst?.isTimes_Heigh = Set_DisEnable
        
        textCMD?.append(textCMD?.getTextCmd(textst, text: "\n\(AppConstants.restaurantData?.storename ?? "")\n"))
        textCMD?.append(textCMD?.getTextCmd(textst, text: "Tel : \(AppConstants.restaurantData?.storePhone ?? "")\n"))
        textCMD?.append(textCMD?.getTextCmd(textst, text: "Email : \(AppConstants.restaurantData?.email ?? "")\n\n"))
        
        textCMD?.append(textCMD?.getTextCmd(textst, text: "------------------------------------------------\n"))
        
        textst?.alignmode = Align_Center
        textst?.isBold = Set_Enabled
        
        let date = "\(bookingDetail.bookingDate ?? "")/\(bookingDetail.bookingTime ?? "")\n"
        textCMD?.append(textCMD?.getTextCmd(textst, text: date))
        
        textst?.alignmode = Align_Left
        textst?.isBold = Set_DisEnable
        
        textCMD?.append(textCMD?.getTextCmd(textst, text: "------------------------------------------------\n"))
        
        textCMD?.append(textCMD?.getTextCmd(textst, text: "Customer Name : \(bookingDetail.customerName ?? "")\n"))
        
        textCMD?.append(textCMD?.getTextCmd(textst, text: "Guest Count : \(bookingDetail.guestCount ?? 0)\n"))
        
        textCMD?.append(textCMD?.getTextCmd(textst, text: "Booking Email : \(bookingDetail.bookingEmail ?? "")\n"))
        
        textCMD?.append(textCMD?.getTextCmd(textst, text: "Booking Phone : \(bookingDetail.bookingPhone ?? "")\n"))
        
        textCMD?.append(textCMD?.getTextCmd(textst, text: "Booking Status : \(bookingDetail.status ?? "")\n"))
        
        textCMD?.append(textCMD?.getTextCmd(textst, text: "Booking Date/Time : \(date)\n"))
        
        if bookingDetail.bookingInstruction ?? "" != ""{
            textCMD?.append(textCMD?.getTextCmd(textst, text: "Instruction : \(bookingDetail.bookingInstruction ?? "")\n\n\n"))
        }else{
            textCMD?.append(textCMD?.getTextCmd(textst, text: "\n\n"))
        }
        
        textCMD?.append(textCMD?.getLFCmd())
        textCMD?.append(textCMD?.getLFCmd())
        textCMD?.append(textCMD?.getLFCmd())
        textCMD?.append(textCMD?.getLFCmd())
        
        textCMD?.append(textCMD?.getCutPaperCmd(CutterMode_Full))
        
        printer?.write(textCMD?.getCmd())
        //            self.disconnectedToPrinter()
        self.printer?.close()
        DispatchQueue.main.async {
            AppCommonMethods.stopProgressBar()
        }
        self.printerObject = nil
        
        //        }
    }
    
    func printBookingCopy(bookingDetail:ReservationModel, image:UIImage?){
        //        if printer?.isOpen ?? false{
        if image != nil{
            let imageCMD = ESCFactory.create()
            imageCMD?.clear()
            imageCMD?.encodingType = Encoding_UTF8
            imageCMD?.append(imageCMD?.getHeaderCmd())
            let bitmapSetting = self.printer?.bitmapSetts
            bitmapSetting?.alignmode = Align_Center
            bitmapSetting?.limitWidth = 30*8
            imageCMD?.append(imageCMD?.getBitMapCmd(bitmapSetting, image: image))
            imageCMD?.append(imageCMD?.getPrintEnd(1))
            printer?.write(imageCMD?.getCmd())
        }
        
        let textCMD = ESCFactory.create()
        textCMD?.clear()
        textCMD?.encodingType = Encoding_GBK
        textCMD?.append(textCMD?.getHeaderCmd())
        
        let textst = printer?.textSets
        textst?.isUnderline = Set_DisEnable
        textst?.isTimes_Wide = Set_DisEnable
        textst?.isTimes_Heigh = Set_DisEnable
        
        let header = AppCommonMethods.fetchSiteSettingValue(key: "ticket_header", lowercased: false) ?? ""
        
        let type = AppCommonMethods.fetchSiteSettingValue(key: "ticket_header_type") ?? ""
        
        if type == "center"{
            textst?.alignmode = Align_Center
        }else if type == "right"{
            textst?.alignmode = Align_Right
        }else{
            textst?.alignmode = Align_Left
        }
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "\(header)\n"))
        
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "------------------------------------------------\n"))
        
        textst?.alignmode = Align_Center
        textst?.isBold = Set_Enabled
        
        let date = "\((bookingDetail.reservationDateTime ?? "").changeDateFormat(fromFormat: "yyyy-MM-dd HH:mm:ss", toFormat: "dd/MM/yyyy HH:mm:ss") ?? "")\n"
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: date))
        
        textst?.alignmode = Align_Left
        textst?.isBold = Set_DisEnable
        
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "------------------------------------------------\n"))
        
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "Customer Name : \(bookingDetail.customer?.name ?? "")\n"))
        
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "Guest Count : \(bookingDetail.diners ?? 0)\n"))
        
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "Booking Email : \(bookingDetail.customer?.email ?? "")\n"))
        
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "Booking Phone : \(bookingDetail.customer?.mobile ?? "")\n"))
        
        if bookingDetail.reservationStatusId ?? 0 == 1{
            textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "Booking Status : Booked\n"))
        }else{
            textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "Booking Status : Cancelled\n"))
        }
        
        
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "Booking Date/Time : \(date)"))
        
        if bookingDetail.specialInstruction ?? "" != ""{
            textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "Instruction : \(bookingDetail.specialInstruction ?? "")\n"))
        }
        
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "------------------------------------------------\n"))
        
        let footerA = AppCommonMethods.fetchSiteSettingValue(key: "footer_a", lowercased: false) ?? ""
        let footerB = AppCommonMethods.fetchSiteSettingValue(key: "footer_b", lowercased: false) ?? ""
        
        textst?.alignmode = Align_Center
        
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "\(footerA)\n"))
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "\(footerB)\n\n\n"))
        
        textCMD?.append(textCMD?.getLFCmd())
        textCMD?.append(textCMD?.getLFCmd())
        textCMD?.append(textCMD?.getLFCmd())
        textCMD?.append(textCMD?.getLFCmd())
        
        textCMD?.append(textCMD?.getCutPaperCmd(CutterMode_Full))
        
        printer?.write(textCMD?.getCmd())
        
        self.printer?.close()
        //            self.disconnectedToPrinter()
        DispatchQueue.main.async {
            AppCommonMethods.stopProgressBar()
        }
        self.printerObject = nil
        //        }
    }
    
    func printWebOrderCopy(orderDetail:WebOrderModel, isKitchenCopy:Bool = true){
        var isCustom = false
        let printModel = AppConstants.printSettings?.filter({ model in
            if model.name.contains("Custom"){
                isCustom = true
            }
            return model.name == (isKitchenCopy ? "Custom Online Kitchen" : "Custom Online Bill") || model.name == (isKitchenCopy ? "Online Kitchen" : "Online Bill")
        }).first

        let imageCMD = ESCFactory.create()
        imageCMD?.clear()
        imageCMD?.encodingType = Encoding_UTF8
        imageCMD?.append(imageCMD?.getHeaderCmd())
        let bitmapSetting = printer?.bitmapSetts
        bitmapSetting?.alignmode = Align_Center
        bitmapSetting?.limitWidth = 30*8
        
        let img = UIImage.init(named: orderDetail.user.roleId == 5 ? "go_grubz_logo" : "ic_logo")!
        
        imageCMD?.append(imageCMD?.getBitMapCmd(bitmapSetting, image: img))
        imageCMD?.append(imageCMD?.getPrintEnd(1))
        printer?.write(imageCMD?.getCmd())
        
        if printModel != nil{
            let textCMD = ESCFactory.create()
            textCMD?.clear()
            textCMD?.encodingType = Encoding_GBK
            textCMD?.append(textCMD?.getHeaderCmd())

            let textst = printer?.textSets
            
            let arrStructure = printModel!.structure
            
            var cDate = ""
            if (self.orderType).lowercased() == "dine in"{
                let created = orderDetail.created ?? ""
                cDate = (created.components(separatedBy: ".").first ?? "").changeDateFormat(fromFormat: "yyyy-MM-dd'T'HH:mm:ss", toFormat: "yyyy-MM-dd") ?? ""
            }else{
                cDate = (orderDetail.deliveryDate ?? "").components(separatedBy: "T").first ?? ""
            }
            
            var isTimePrint = false
            let dateStruct = arrStructure.filter { $0.type == .onlineOrderDate }.first
            let timeStruct = arrStructure.filter { $0.type == .onlineOrderTime }.first
            
            for structure in arrStructure{
                if structure.type == .onlineTitle{
                    if let date = cDate.getDateFromString(format: "yyyy-MM-dd", locale: nil){
                        let currentDate = Date().getDateInString(format: "yyyy-MM-dd").getDateFromString(format: "yyyy-MM-dd", locale: nil)!
                        if date > currentDate{
                            textCMD?.addCmdWithPrint(textst, text: "This order is not for today\n", structure: structure)
                        }
                    }
                }
                if structure.type == .onlineSite{
                    textCMD?.addCmdWithPrint(textst, text: orderDetail.user.roleId == 5 ? "Gogrubz.com sent you order\n" : "Tiffintom.com sent you order\n", structure: structure)
                }
                if structure.type == .onlineOrderType{
                    textCMD?.addCmdWithPrint(textst, text: "\(orderDetail.displayOrderType.capitalized)\n", structure: structure)
                }
                if structure.type == .onlineOrderNo{
                    textCMD?.addCmdWithPrint(textst, text: "ORDER NO: \(orderDetail.orderNumber ?? "")\n", structure: structure)
                }
                if (structure.type == .onlineOrderDate || structure.type == .onlineOrderTime) && !isTimePrint{
                    if dateStruct?.visibility ?? 0 == 1{
                        if dateStruct?.alignment ?? "" == "center"{
                            textst?.alignmode = Align_Center
                        }else if dateStruct?.alignment ?? "" == "right"{
                            textst?.alignmode = Align_Right
                        }else{
                            textst?.alignmode = Align_Left
                        }
                        if dateStruct?.size ?? "" == "size0" || dateStruct?.size ?? "" == ""{
                            textst?.isTimes_Wide = Set_DisEnable
                            textst?.isTimes_Heigh = Set_DisEnable
                        }else{
                            textst?.isTimes_Wide = Set_Enabled
                            textst?.isTimes_Heigh = Set_Enabled
                        }
                        if dateStruct?.style ?? "" == "bold"{
                            textst?.isBold = Set_Enabled
                            textst?.isUnderline = Set_DisEnable
                            textst?.isInverse = Set_DisEnable
                        }else if dateStruct?.style ?? "" == "underline"{
                            textst?.isBold = Set_DisEnable
                            textst?.isUnderline = Set_Enabled
                            textst?.isInverse = Set_DisEnable
                        }else if dateStruct?.style ?? "" == "reverse"{
                            textst?.isBold = Set_DisEnable
                            textst?.isInverse = Set_Enabled
                            textst?.isUnderline = Set_DisEnable
                        }else{
                            textst?.isInverse = Set_DisEnable
                            textst?.isBold = Set_DisEnable
                            textst?.isUnderline = Set_DisEnable
                        }
                        let dDate = "\((orderDetail.deliveryDate ?? "").components(separatedBy: "T").first ?? "") "
                        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: dDate))
                    }
                    if timeStruct?.visibility ?? 0 == 1{
                        if dateStruct?.visibility ?? 0 == 0{
                            if timeStruct?.alignment ?? "" == "center"{
                                textst?.alignmode = Align_Center
                            }else if timeStruct?.alignment ?? "" == "right"{
                                textst?.alignmode = Align_Right
                            }else{
                                textst?.alignmode = Align_Left
                            }
                        }
                        if timeStruct?.size ?? "" == "size0" || timeStruct?.size ?? "" == ""{
                            textst?.isTimes_Wide = Set_DisEnable
                            textst?.isTimes_Heigh = Set_DisEnable
                        }else{
                            textst?.isTimes_Wide = Set_Enabled
                            textst?.isTimes_Heigh = Set_Enabled
                        }
                        if timeStruct?.style ?? "" == "bold"{
                            textst?.isBold = Set_Enabled
                            textst?.isUnderline = Set_DisEnable
                            textst?.isInverse = Set_DisEnable
                        }else if timeStruct?.style ?? "" == "underline"{
                            textst?.isBold = Set_DisEnable
                            textst?.isUnderline = Set_Enabled
                            textst?.isInverse = Set_DisEnable
                        }else if timeStruct?.style ?? "" == "reverse"{
                            textst?.isBold = Set_DisEnable
                            textst?.isInverse = Set_Enabled
                            textst?.isUnderline = Set_DisEnable
                        }else{
                            textst?.isInverse = Set_DisEnable
                            textst?.isBold = Set_DisEnable
                            textst?.isUnderline = Set_DisEnable
                        }
                        var time = ""
                        if (orderDetail.assoonas ?? "" == "now"){
                            time = "ASAP\n"
                        }else{
                            time = "\(orderDetail.deliveryTime ?? "")\n"
                        }
                        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: time))
                    }
                    if timeStruct?.visibility ?? 0 == 1 || dateStruct?.visibility ?? 0 == 1{
                        if (dateStruct?.separator ?? false) || (timeStruct?.separator ?? false){
                            textCMD?.addLinePrintCommand(textst!)
                        }
                    }
                    isTimePrint = true
                }
                if structure.type == .onlineItems && orderDetail.arrProducts != nil{
                    let eachSeparator = structure.allSeparator == 1
                    for item in orderDetail.arrProducts!{
                        let strName = self.getTitleForOnlineOrder(product: item, size: structure.size, showPrice: structure.price == 1, isCustom: isCustom)
                        textCMD?.addCmdWithPrint(textst, text: strName, structure: structure, showLine: false)
                        
                        if item.subAddonsName ?? "" != ""{
                            let subaddon = self.getSubAddons(subAddons: item.subAddonsName ?? "", size: structure.size)
                            textCMD?.addCmdWithPrint(textst, text: subaddon, structure: structure, showLine: eachSeparator)
                        }
                        
                        if eachSeparator && !structure.separator{
                            textCMD?.addLinePrintCommand(textst!)
                        }
                    }
                    if !eachSeparator && structure.separator{
                        textCMD?.addLinePrintCommand(textst!)
                    }
                }
                
                if structure.type == .onlineSubTotal{
                    textCMD?.addCmdWithPrint(textst, text: isCustom ? self.getPriceText(title: "SubTotal:", price: orderDetail.subTotal ?? 0, size: structure.size) : String.init(format: "SubTotal: %.2f\n", orderDetail.subTotal ?? 0), structure: structure)
                }
                
                if structure.type == .onlineDeliveryCharge && orderDetail.deliveryFee ?? 0 > 0{
                    textCMD?.addCmdWithPrint(textst, text: isCustom ? self.getPriceText(title: "Delivery Charge:", price: orderDetail.deliveryFee ?? 0, size: structure.size) : String.init(format: "Delivery Charge: %.2f\n", orderDetail.deliveryFee ?? 0), structure: structure)
                }
                
                if structure.type == .onlineOffer{
                    if orderDetail.offerPrice ?? 0 > 0{
                        textCMD?.addCmdWithPrint(textst, text: isCustom ? self.getPriceText(title: "Offer:", price: orderDetail.offerPrice ?? 0, size: structure.size) : String.init(format: "Offer: %.2f\n", orderDetail.offerPrice ?? 0), structure: structure)
                    }
                    if orderDetail.voucherAmount ?? 0 > 0{
                        textCMD?.addCmdWithPrint(textst, text: isCustom ? self.getPriceText(title: "Offer:", price: orderDetail.voucherAmount ?? 0, size: structure.size) : String.init(format: "Offer: %.2f\n", orderDetail.voucherAmount ?? 0), structure: structure)
                    }
                }
                
                if structure.type == .onlineLoyalty && orderDetail.rewardOffer ?? 0 > 0{
                    textCMD?.addCmdWithPrint(textst, text:  isCustom ? self.getPriceText(title: "Loyalty Point Discount:", price: orderDetail.rewardOffer ?? 0, size: structure.size) : String.init(format: "Loyalty Point Discount: %.2f\n", orderDetail.rewardOffer ?? 0), structure: structure)
                }
                
                if structure.type == .onlineServiceCharge && orderDetail.serviceCharge ?? 0 > 0{
                    textCMD?.addCmdWithPrint(textst, text: isCustom ? self.getPriceText(title: "Service Charge:", price: orderDetail.serviceCharge ?? 0, size: structure.size) : String.init(format: "Service Charge: %.2f\n", orderDetail.serviceCharge ?? 0), structure: structure)
                    
                    for surcharge in orderDetail.surcharges{
                        textCMD?.addCmdWithPrint(textst, text: isCustom ? self.getPriceText(title: "\(surcharge.surchargeName):", price: surcharge.surchargeAmount, size: structure.size) : String.init(format: "%@: %.2f\n", surcharge.surchargeName , surcharge.surchargeAmount), structure: structure)
                    }
                }
                
                if structure.type == .onlineDriverTip && orderDetail.driverTip ?? 0 > 0{
                    textCMD?.addCmdWithPrint(textst, text: isCustom ? self.getPriceText(title: "Driver Tip:", price: orderDetail.driverTip ?? 0, size: structure.size) : String.init(format: "Driver Tip: %.2f\n", orderDetail.driverTip ?? 0), structure: structure)
                }
                
                if structure.type == .onlineGrandTotal{
                    textCMD?.addCmdWithPrint(textst, text: isCustom ? self.getPriceText(title: "Total:", price: orderDetail.orderGrandTotal ?? 0, size: structure.size) : String.init(format: "Total: %.2f\n", orderDetail.orderGrandTotal ?? 0), structure: structure)
                }
                
                if structure.type == .onlineComment && !(orderDetail.orderInstruction ?? "").isEmpty{
                    let comment = self.getMultipleLineText(name: "Comments: \(orderDetail.orderInstruction ?? "")", size: structure.size)
                    textCMD?.addCmdWithPrint(textst, text: comment, structure: structure)
                }
                
                if structure.type == .onlineCustomerDetails{
                    textCMD?.addCmdWithPrint(textst, text: isCustom ? "\(orderDetail.customerName ?? "")\n\(orderDetail.phone ?? "")\n" : "Cust Name: \(orderDetail.customerName ?? "")\nCust No: \(orderDetail.phone ?? "")\n", structure: structure)
                }
                
                if structure.type == .onlineDeliveryAddress && self.orderType.lowercased() == "delivery"{
                    let address = self.getMultipleLineText(name: isCustom ? "\(orderDetail.address ?? "")" : "Del. address: \(orderDetail.address ?? "")", size: structure.size)
                    textCMD?.addCmdWithPrint(textst, text: address, structure: structure)
                }
                
                if structure.type == .onlineRequestedFor{
                    if orderDetail.assoonas ?? "" == "now"{
                        textCMD?.addCmdWithPrint(textst, text: isCustom ? "Requested for:ASAP\n" : "Requested for:\nASAP\n", structure: structure)
                    }else{
                        textCMD?.addCmdWithPrint(textst, text: isCustom ? "Requested for:\(orderDetail.deliveryTime ?? "")\n" : "Requested for:\n\(orderDetail.deliveryTime ?? "")\n", structure: structure)
                    }
                    if (orderDetail.status ?? "").lowercased()  == "accepted" && orderDetail.preparation ?? "" != ""{
                        textCMD?.addCmdWithPrint(textst, text: isCustom ? "\(orderDetail.preparation ?? "") \(cDate)\n" : "Confirmed for:\(orderDetail.preparation ?? "") \(cDate)\n", structure: structure)
                    }
                }
                
                if structure.type == .onlinePaymentStatus{
                    textCMD?.addCmdWithPrint(textst, text: isCustom ? "\((orderDetail.paymentType ?? "").lowercased() == "p" ? "Paid" : "Unpaid")\n" : "Order \((orderDetail.paymentType ?? "").lowercased() == "p" ? "Paid" : "Unpaid")\n", structure: structure)
                }
                
                
                if structure.type == .onlinePaymentMethod{
                    var paymentMode = (orderDetail.paymentMethod ?? "").uppercased()
                    if paymentMode == "STRIPE"{
                        paymentMode = "ONLINE"
                    }
                    textCMD?.addCmdWithPrint(textst, text: "Payment Type: \(paymentMode)\n", structure: structure)
                }
                
                if structure.type == .onlineReceiptTime{
                    textCMD?.addCmdWithPrint(textst, text: "Receipt Time:\n\(Date().getDateInString(format: "dd/MM/yyyy hh:mm a"))\n", structure: structure)
                }
                
                if structure.type == .onlineOrderStatus{
                    textCMD?.addCmdWithPrint(textst, text: "Order Status:\((orderDetail.status ?? "").capitalized)\n", structure: structure)
                }
                
                if structure.type == .onlineOrderStatus && !(orderDetail.failedReason ?? "").isEmpty{
                    let reason = self.getMultipleLineText(name: "Cancel Reason: \(orderDetail.failedReason ?? "")", size: structure.size)
                    textCMD?.addCmdWithPrint(textst, text: reason, structure: structure)
                }
                
                if structure.type == .onlineRestaurantAddress{
                    let address = self.getMultipleLineText(name: "\(AppConstants.restaurantData?.storename ?? ""),\(AppConstants.restaurantData?.address ?? "")", size: structure.size)
                    textCMD?.addCmdWithPrint(textst, text: address, structure: structure)
                }
                
                if structure.type == .onlineFooter{
                    let footerA = AppCommonMethods.fetchSiteSettingValue(key: "footer_a", lowercased: false) ?? ""
                    let footerB = AppCommonMethods.fetchSiteSettingValue(key: "footer_b", lowercased: false) ?? ""
                    textCMD?.addCmdWithPrint(textst, text: "\(footerA)\n", structure: structure, showLine: false)
                    textCMD?.addCmdWithPrint(textst, text: "\(footerB)\n\n", structure: structure)
                }
                
            }
            
            textCMD?.append(textCMD?.getLFCmd())
            textCMD?.append(textCMD?.getLFCmd())
            textCMD?.append(textCMD?.getLFCmd())
            textCMD?.append(textCMD?.getLFCmd())
            
            textCMD?.append(textCMD?.getCutPaperCmd(CutterMode_Full))
            
            printer?.write(textCMD?.getCmd())
            printer?.close()
        }else{
            self.printWebOrderCopyForNormal(orderDetail: orderDetail, isKitchenCopy: isKitchenCopy)
        }
        
        if shouldPrintKitchenCopy{
            DispatchQueue.main.asyncAfter(deadline: .now()+1) {
                self.shouldPrintKitchenCopy = false
                self.connectToPrinterWithPrint(model: orderDetail, controller: self.parentViewController)
            }
        }else{
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
            }
        }
    }
    
    func printWebOrderCopyForNormal(orderDetail:WebOrderModel,isKitchenCopy:Bool = true){
        
        let textCMD = ESCFactory.create()
        textCMD?.clear()
        textCMD?.encodingType = Encoding_GBK
        textCMD?.append(textCMD?.getHeaderCmd())
        
        let textst = printer?.textSets
        var cDate = ""
        if (self.orderType).lowercased() == "dine in"{
            let created = orderDetail.created ?? ""
            cDate = (created.components(separatedBy: ".").first ?? "").changeDateFormat(fromFormat: "yyyy-MM-dd'T'HH:mm:ss", toFormat: "yyyy-MM-dd") ?? ""
        }else{
            cDate = (orderDetail.deliveryDate ?? "").components(separatedBy: "T").first ?? ""
        }
        textst?.isUnderline = Set_DisEnable
        textst?.alignmode = Align_Center
        if let date = cDate.getDateFromString(format: "yyyy-MM-dd", locale: nil){
            let currentDate = Date().getDateInString(format: "yyyy-MM-dd").getDateFromString(format: "yyyy-MM-dd", locale: nil)!
            if date > currentDate{
                textst?.isTimes_Wide = Set_Enabled
                textst?.isTimes_Heigh = Set_Enabled
                
                textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "This order is not for today\n"))
            }
        }
        
        textst?.isTimes_Wide = Set_DisEnable
        textst?.isTimes_Heigh = Set_DisEnable
        
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: orderDetail.user.roleId == 5 ? "Gogrubz.com sent you order\n" : "Tiffintom.com sent you order\n"))
        textst?.alignmode = Align_Left
        
        textst?.isTimes_Wide = Set_Enabled
        textst?.isTimes_Heigh = Set_Enabled
        textst?.isBold = Set_Enabled
        
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "\(orderDetail.displayOrderType.capitalized)  \n"))
        
        textst?.isTimes_Wide = Set_DisEnable
        textst?.isTimes_Heigh = Set_DisEnable
        textst?.isBold = Set_DisEnable
        
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "------------------------------------------------\n"))
        textst?.isTimes_Heigh = Set_Enabled
        textst?.isBold = Set_Enabled
        textst?.isTimes_Wide = Set_Enabled
        
        let dDate = (orderDetail.deliveryDate ?? "").components(separatedBy: "T").first ?? ""
        if (orderDetail.assoonas ?? "" == "now"){
            textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "ORDER NO: \(orderDetail.orderNumber ?? "")\nASAP \(dDate)\n"))
        }else{
            textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "ORDER NO: \(orderDetail.orderNumber ?? "")\n\("\(orderDetail.deliveryTime ?? "") \(dDate)".uppercased())\n"))
        }
        textst?.isTimes_Heigh = Set_DisEnable
        textst?.isBold = Set_DisEnable
        textst?.isTimes_Wide = Set_DisEnable
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "------------------------------------------------\n"))
        
        if isKitchenCopy{
            textst?.isTimes_Wide = Set_Enabled
            textst?.isTimes_Heigh = Set_Enabled
        }
        
        textst?.isBold = Set_Enabled
        
        if orderDetail.arrProducts != nil{
            var strProduct = ""
            for item in orderDetail.arrProducts!{
                if strProduct == ""{
                    strProduct = getItemName(price: item.totalPrice ?? 0, name: item.menuName ?? "", qty: item.quantity ?? 0, isKitchenCopy: isKitchenCopy, size: "")
                }else{
                    strProduct = "\(strProduct)\(getItemName(price: item.totalPrice ?? 0, name: item.menuName ?? "", qty: item.quantity ?? 0, isKitchenCopy: isKitchenCopy, size: ""))"
                }
                if item.subAddonsName ?? "" != ""{
                    strProduct = "\(strProduct)\(getSubAddons(subAddons: item.subAddonsName ?? ""))"
                }
            }
            textCMD?.append(textCMD?.getCmdWithPrint(textst, text: strProduct))
            textst?.isBold = Set_DisEnable
            if isKitchenCopy{
                textst?.isTimes_Wide = Set_DisEnable
                textst?.isTimes_Heigh = Set_DisEnable
            }
            textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "------------------------------------------------\n"))
        }
        
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: String.init(format: "Sub Total:        %.2f\n", orderDetail.subTotal ?? 0)))
        
        if orderDetail.deliveryFee ?? 0 > 0{
            textCMD?.append(textCMD?.getCmdWithPrint(textst, text: String.init(format: "Delivery Charge: %.2f\n", orderDetail.deliveryFee ?? 0)))
        }
        
        if orderDetail.offerPrice ?? 0 > 0 || orderDetail.voucherAmount ?? 0 > 0{
            if orderDetail.offerPrice ?? 0 > 0{
                textCMD?.append(textCMD?.getCmdWithPrint(textst, text: String.init(format: "Offer:       %.2f\n", orderDetail.offerPrice ?? 0)))
            }else{
                textCMD?.append(textCMD?.getCmdWithPrint(textst, text: String.init(format: "Offer:       %.2f\n", orderDetail.voucherAmount ?? 0)))
            }
        }
        
        if orderDetail.rewardOffer ?? 0 > 0{
            textCMD?.append(textCMD?.getCmdWithPrint(textst, text: String.init(format: "Loyalty Point Discount: %.2f\n", orderDetail.rewardOffer ?? 0)))
        }
        
        if orderDetail.serviceCharge ?? 0 > 0{
            textCMD?.append(textCMD?.getCmdWithPrint(textst, text: String.init(format: "Service Charge:  %.2f\n", orderDetail.serviceCharge ?? 0)))
        }
        
        for surcharge in orderDetail.surcharges{
            textCMD?.append(textCMD?.getCmdWithPrint(textst, text: String.init(format: "%@:  %.2f\n", surcharge.surchargeName, surcharge.surchargeAmount)))
        }
        
        if orderDetail.driverTip ?? 0 > 0{
            textCMD?.append(textCMD?.getCmdWithPrint(textst, text: String.init(format: "Driver Tip:      %.2f\n", orderDetail.driverTip ?? 0)))
        }
        
        textst?.isTimes_Heigh = Set_Enabled
        textst?.isTimes_Wide = Set_Enabled
        textst?.isBold = Set_Enabled
        
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: String.init(format: "Total: %.2f\n", orderDetail.orderGrandTotal ?? 0)))
        
        textst?.isTimes_Heigh = Set_DisEnable
        textst?.isTimes_Wide = Set_DisEnable
        textst?.isBold = Set_DisEnable
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "------------------------------------------------\n"))
        
        if orderDetail.orderInstruction ?? "" != ""{
            textst?.isTimes_Heigh = Set_Enabled
            textst?.isTimes_Wide = Set_Enabled
            textst?.isBold = Set_Enabled
            
            textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "Comments: \(orderDetail.orderInstruction ?? "")\n"))
            
            textst?.isTimes_Heigh = Set_DisEnable
            textst?.isTimes_Wide = Set_DisEnable
            textst?.isBold = Set_DisEnable
            textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "------------------------------------------------\n"))
        }
        
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "Cust Name: \(orderDetail.customerName ?? "")\nCust No: \(orderDetail.phone ?? "")\n"))
        
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "------------------------------------------------\n"))
        
        if self.orderType.lowercased() == "delivery"{
            textst?.isTimes_Heigh = Set_Enabled
            textst?.isTimes_Wide = Set_Enabled
            textst?.isBold = Set_Enabled
            
            textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "Del. address: \(orderDetail.address ?? "")\n"))
            
            textst?.isTimes_Heigh = Set_DisEnable
            textst?.isTimes_Wide = Set_DisEnable
            textst?.isBold = Set_DisEnable
            
            textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "------------------------------------------------\n"))
        }
        
        
        if (orderDetail.status ?? "").lowercased()  == "accepted" && orderDetail.preparation ?? "" != ""{
            textst?.isTimes_Heigh = Set_Enabled
            textst?.isTimes_Wide = Set_Enabled
            textst?.isBold = Set_Enabled
            
            textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "Confirmed for:\n\(orderDetail.preparation ?? "") \(cDate)\n"))
            
            textst?.isTimes_Heigh = Set_DisEnable
            textst?.isTimes_Wide = Set_DisEnable
            textst?.isBold = Set_DisEnable
            
            textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "------------------------------------------------\n"))
            
            
        }
        
        textst?.isTimes_Heigh = Set_Enabled
        textst?.isTimes_Wide = Set_Enabled
        textst?.isBold = Set_Enabled
        
        var paymentMode = (orderDetail.paymentStatus ?? "").uppercased()
        if paymentMode == "STRIPE"{
            paymentMode = "ONLINE"
        }
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "Order \((orderDetail.paymentType ?? "").lowercased() == "p" ? "Paid" : "Unpaid")\n"))
        
        textst?.isBold = Set_DisEnable
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "Payment Type:    \(paymentMode)\n"))
        
        textst?.isTimes_Heigh = Set_DisEnable
        textst?.isTimes_Wide = Set_DisEnable
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "------------------------------------------------\n"))
        
        textst?.isTimes_Heigh = Set_Enabled
        textst?.isTimes_Wide = Set_Enabled
        textst?.isBold = Set_Enabled
        
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "Receipt Time:\n"))
        textst?.isBold = Set_DisEnable
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "\(Date().getDateInString(format: "dd/MM/yyyy hh:mm a"))\n"))
        
        textst?.isBold = Set_Enabled
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "Order Status:"))
        textst?.isBold = Set_DisEnable
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "\((orderDetail.status ?? "").capitalized)\n"))
        
        if orderDetail.failedReason ?? "" != ""{
            textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "Cancel Reason: \(orderDetail.failedReason ?? "")\n"))
        }
        textst?.isBold = Set_Enabled
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "\(AppConstants.restaurantData?.storename ?? ""),\(AppConstants.restaurantData?.address ?? "")\n\n"))
        
        textst?.isBold = Set_DisEnable
        textst?.isTimes_Heigh = Set_DisEnable
        textst?.isTimes_Wide = Set_DisEnable
        
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "------------------------------------------------\n"))
        
        textst?.alignmode = Align_Center
        
        let footerA = AppCommonMethods.fetchSiteSettingValue(key: "footer_a", lowercased: false) ?? ""
        let footerB = AppCommonMethods.fetchSiteSettingValue(key: "footer_b", lowercased: false) ?? ""
        
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "\(footerA)\n"))
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "\(footerB)\n\n\n"))
        
        textCMD?.append(textCMD?.getLFCmd())
        textCMD?.append(textCMD?.getLFCmd())
        textCMD?.append(textCMD?.getLFCmd())
        textCMD?.append(textCMD?.getLFCmd())
        
        textCMD?.append(textCMD?.getCutPaperCmd(CutterMode_Full))
        
        printer?.write(textCMD?.getCmd())
        printer?.close()
    }
    
    func printOrderCopy(order:OrderModel,arrProduct:[OrderProductModel], image:UIImage?){
        var isCustomCopy = false
        let printModel = AppConstants.printSettings?.filter({ model in
            if model.name == "Custom Prep Ticket"{
                isCustomCopy = true
            }
            return model.name == "Custom Prep Ticket" || model.name == "Prep Ticket"
        }).first
        let textCMD = ESCFactory.create()
        textCMD?.clear()
        
        textCMD?.encodingType = Encoding_GBK
        textCMD?.append(textCMD?.getHeaderCmd())
        
        let textst = printer?.textSets
        
        var isOrderUpdate = false
        var strOrderAction = "Full Order"
        if order.orderActionId ?? 0 == 3{
            strOrderAction = "Full Order Update"
            isOrderUpdate = true
        }else if order.orderActionId ?? 0 == 2{
            strOrderAction = "Duplicate Order"
        }else if order.orderActionId ?? 0 == 4{
            strOrderAction = "Duplicate Order Update"
            isOrderUpdate = true
        }
        
        let orderNo = "\(AppConstants.userData?.preffix ?? "")\(order._id)\n"
        let tableNo = "Table No: \(order.table?.number ?? "")\n"
        let dinerNo = "No of Diner: \(order.noGuest ?? 0)\n"
        let orderType = "Order Type: \(order.orderType ?? "")\n"
        
        var dateFormat = ""
        if AppCommonMethods.fetchSiteSettingValue(key: "date_time_in_receipt_printing") ?? "" == "date_time"{
            dateFormat = "yyyy-MM-dd HH:mm:ss"
        }else if AppCommonMethods.fetchSiteSettingValue(key: "date_time_in_receipt_printing") ?? "" == "date"{
            dateFormat = "yyyy-MM-dd"
        }else if AppCommonMethods.fetchSiteSettingValue(key: "date_time_in_receipt_printing") ?? "" == "time"{
            dateFormat = "HH:mm:ss"
        }
        
        let orderDate = "Order Time: \((order.deliveryDate ?? "").changeDateFormat(fromFormat: "yyyy-MM-dd HH:mm:ss", toFormat: dateFormat) ?? "")\n"
        
        
        let header = AppCommonMethods.fetchSiteSettingValue(key: "ticket_header", lowercased: false) ?? ""

        
        let footerA = AppCommonMethods.fetchSiteSettingValue(key: "footer_a", lowercased: false) ?? ""
        let footerB = AppCommonMethods.fetchSiteSettingValue(key: "footer_b", lowercased: false) ?? ""
        
        var arrNotAssignProduct = [OrderProductModel]()
        var dictOrders = [String:[String:Any]]()
        
        var arrBlockIds = [Int]()
        for product in arrProduct{
            if let block = CoreDataHelper.shared.fetchPrintBlockObject(categoryId: product.product?.categoryId ?? 0){
                if var data = dictOrders["\(block.sequence ?? 0)"], var arr = data["data"] as? [OrderProductModel]{
                    arr.append(product)
                    data["data"] = arr
                    dictOrders["\(block.sequence ?? 0)"] = data
                }else{
                    arrBlockIds.append(block.sequence ?? 0)
                    dictOrders["\(block.sequence ?? 0)"] = ["name":block.name ?? "", "data":[product]]
                }
            }else{
                arrNotAssignProduct.append(product)
            }
        }
        
        arrBlockIds.sort { (id1, id2) -> Bool in
            return id2 > id1
        }
        
        var paymentStatus = ""
        if order.totalPaid ?? 0 >= (order.total ?? 0) && order.total ?? 0 > 0{
            let status = AppCommonMethods.fetchSiteSettingValue(key: "paid_payment_title", lowercased: false) ?? ""
            if status != ""{
                paymentStatus = status
            }else{
                paymentStatus = "Paid"
            }
        }else if order.totalPaid ?? 0 > 0{
            let status = AppCommonMethods.fetchSiteSettingValue(key: "partial_payment_title", lowercased: false) ?? ""
            if status != ""{
                paymentStatus = status
            }else{
                paymentStatus = "Partially Paid"
            }
        }else{
            let status = AppCommonMethods.fetchSiteSettingValue(key: "unpaid_payment_title", lowercased: false) ?? ""
            if status != ""{
                paymentStatus = status
            }else{
                paymentStatus = "Unpaid"
            }
        }
        paymentStatus = "\(paymentStatus)\n"
        
        if printModel != nil{
            
            let arrStructure = printModel!.structure
            
            let subAddon = arrStructure.filter { model in
                return model.type == .itemsSubaddon
            }.first
            
            let orderTime = arrStructure.filter { model in
                return model.type == .orderTime
            }.first
            
            let noOfDiners = arrStructure.filter { model in
                return model.type == .noOfDiners
            }.first
            
            let itemsHeader = arrStructure.filter { model in
                return model.type == .itemsHeader
            }.first
            
            let paymentDetailHeader = arrStructure.filter { model in
                return model.type == .paymentDetailHeader
            }.first
            
            let dueAmount = (order.totalPaid ?? 0) - (order.total ?? 0)
            
            for structure in arrStructure {
//                print("name: \(structure.type?.rawValue ?? ""), visibility: \(structure.visibility), alignment: \(structure.alignment), style: \(structure.style), size: \(structure.size), sequence: \(structure.sequence)")
                if structure.type == .logo && image != nil && structure.visibility == 1{
                    let imageCMD = ESCFactory.create()
                    imageCMD?.clear()
                    imageCMD?.encodingType = Encoding_UTF8
                    imageCMD?.append(imageCMD?.getHeaderCmd())
                    let bitmapSetting = self.printer?.bitmapSetts
                    bitmapSetting?.alignmode = imageCMD?.getAlignment(structure.alignment.lowercased()) ?? Align_Center
                    bitmapSetting?.limitWidth = 30*8
                    imageCMD?.append(imageCMD?.getBitMapCmd(bitmapSetting, image: image))
                    imageCMD?.append(imageCMD?.getPrintEnd(1))
                    printer?.write(imageCMD?.getCmd())
                }
                
//                if structure.type == .ticketHeader && !header.isEmpty{
//                    textCMD?.addCmdWithPrint(textst, text: "\(header)\n", structure: structure)
//                }
                
                if structure.type == .title{
                    textCMD?.addCmdWithPrint(textst, text: "\(strOrderAction)\n", structure: structure)
                }
                
                if structure.type == .headerOrderType{
                    textCMD?.addCmdWithPrint(textst, text: isCustomCopy ? "\((order.orderType?.uppercased() ?? ""))\n" : "** \((order.orderType ?? "")) **\n", structure: structure)
                }
                
                if structure.type == .headerCustomerName && !(order.customerName ?? "").removeSpace.isEmpty{
                    textCMD?.addCmdWithPrint(textst, text: "\(order.customerName ?? "")\n", structure: structure)
                }
                
                if structure.type == .orderNo{
                    textCMD?.addCmdWithPrint(textst, text: isCustomCopy ? orderNo : "Order No: \(orderNo)", structure: structure)
                }
                
                if structure.type == .tableNo && order.orderTypeId ?? 0 == 1{
                    var tableNo = "Table No: \(order.table?.number ?? "")\n"
                    if noOfDiners != nil && !isCustomCopy{
                        tableNo = "Table No: \(order.table?.number ?? "")"
                        let dinerNo = " Diner: \(order.noGuest ?? 0)\n"
                        textCMD?.addCmdWithPrint(textst, text: tableNo, structure: structure, showLine: false)
                        textCMD?.addCmdWithPrint(textst, text: dinerNo, structure: noOfDiners!)
                        continue
                    }
                    textCMD?.addCmdWithPrint(textst, text: tableNo, structure: structure)
                }
                
                if structure.type == .noOfDiners && isCustomCopy && order.orderTypeId ?? 0 == 1{
                    textCMD?.addCmdWithPrint(textst, text: "Diner: \(order.noGuest ?? 0)\n", structure: structure)
                }
                
                if structure.type == .orderDate{
                    let date = (order.deliveryDate ?? "").components(separatedBy: "T").first?.changeDateFormat(fromFormat: "yyyy-MM-dd", toFormat: "dd-MM-yyyy") ?? ""
                    if orderTime != nil{
                        textCMD?.addCmdWithPrint(textst, text: "Date: \(date)", structure: structure, showLine: false)
                        let time = order.deliveryDate?.components(separatedBy: "T").last?.components(separatedBy: ".").first?.changeDateFormat(fromFormat: "HH:mm:ss", toFormat: "hh:mm a") ?? ""
                        textCMD?.addCmdWithPrint(textst, text: " Time: \(time)\n", structure: orderTime!)
                        continue
                    }
                    textCMD?.addCmdWithPrint(textst, text: "Date: \(date)\n", structure: structure)
                }
                
                if structure.type == .itemsHeader && isCustomCopy{
                    textCMD?.addCmdWithPrint(textst, text: "Qty  Name\n", structure: structure)
                }
                
                if structure.type == .items && structure.visibility == 1{
                    let allSeparator = structure.allSeparator == 1
                    if itemsHeader != nil && !isCustomCopy{
                        textCMD?.addCmdWithPrint(textst, text: "Qty  Name\n", structure: itemsHeader!, showLine: false)
                    }
                    for product in arrNotAssignProduct{
                        let strName = self.getTitleForOrder(product: product, size: structure.size, showPrice: structure.price == 1 && isCustomCopy, isCustom: isCustomCopy, isOrderUpdate: isOrderUpdate)
                        textCMD?.addCmdWithPrint(textst, text: strName, structure: structure, showLine: false)
                        
                        if let subAddon{
                            let strDesc = self.getAddonForPrepTicket(product: product, size: subAddon.size, isBill: false, contain: structure.contain)
                            if strDesc != ""{
                                textCMD?.addCmdWithPrint(textst, text: strDesc, structure: subAddon, showLine: false)
                            }
                        }
                        if allSeparator{
                            textCMD?.addLinePrintCommand(textst!, isForPrep: !isCustomCopy)
                        }
                        _ = SQLiteManage.ExecuteQuery("UPDATE OrderProducts SET sent_to_kitchen = '1',  sent_to_kitchen_quantity = '0' WHERE item_unique_id = '\(product.uniqueId)'")
                        
                    }
                    for i in 0..<arrBlockIds.count{
                        let id = arrBlockIds[i]
                        if let data = dictOrders["\(id)"], let name = data["name"] as? String, let arr = data["data"] as? [OrderProductModel]{
                            if structure.block && !allSeparator{
                                if name.count < 33{
                                    textCMD?.addCmdWithPrint(textst, text: formatBlockName(name), alignment: "center", size: "size0", style: "")
                                }else{
                                    textCMD?.addCmdWithPrint(textst, text: "\n\(name)\n", alignment: "center", size: "size0", style: "")
                                }
                            }
                            for product in arr{
                                let strName = self.getTitleForOrder(product: product, size: structure.size, showPrice: structure.price == 1 && isCustomCopy, isCustom: isCustomCopy, isOrderUpdate: isOrderUpdate)
                                textCMD?.addCmdWithPrint(textst, text: strName, structure: structure, showLine: false)
                                
                                if let subAddon{
                                    let strDesc = self.getAddonForPrepTicket(product: product, size: subAddon.size, isBill: false, contain: structure.contain)
                                    if strDesc != ""{
                                        textCMD?.addCmdWithPrint(textst, text: strDesc, structure: subAddon, showLine: false)
                                    }
                                }
                                if allSeparator{
                                    textCMD?.addLinePrintCommand(textst!, isForPrep: !isCustomCopy)
                                }
                                _ = SQLiteManage.ExecuteQuery("UPDATE OrderProducts SET sent_to_kitchen = '1',  sent_to_kitchen_quantity = '0' WHERE item_unique_id = '\(product.uniqueId)'")
                            }
                            
                        }
                    }
                    if !allSeparator && structure.separator{
                        textCMD?.addLinePrintCommand(textst!)
                    }
                }
                
                if structure.type == .subtotal{
                    textCMD?.addCmdWithPrint(textst, text: isCustomCopy ? self.getPriceText(title: "SUB TOTAL", price: order.subTotal ?? 0, size: structure.size) : String(format: "Sub Total: %.2f\n", order.subTotal ?? 0), structure: structure)
                }
                
                if structure.type == .discount && order.discount ?? 0 > 0{
                    textCMD?.addCmdWithPrint(textst, text: isCustomCopy ? self.getPriceText(title: "DISCOUNT", price: order.discount ?? 0, size: structure.size) : String(format: "Discount: %.2f\n", order.discount ?? 0), structure: structure)
                }
                
                if structure.type == .serviceCharge && order.serviceCharge ?? 0 > 0{
                    textCMD?.addCmdWithPrint(textst, text: isCustomCopy ? self.getPriceText(title: "SERVICE CHARGE", price: order.serviceCharge ?? 0, size: structure.size) : String(format: "Service Charge: %.2f\n", order.serviceCharge ?? 0), structure: structure)
                }
                
                if structure.type == .gratuity && order.gratuity ?? 0 > 0{
                    textCMD?.addCmdWithPrint(textst, text: isCustomCopy ? self.getPriceText(title: "GRATUITY", price: order.gratuity ?? 0, size: structure.size) : String(format: "Gratuity: %.2f\n", order.gratuity ?? 0), structure: structure)
                }
                
                if structure.type == .deliveryCharge && order.deliveryCharge ?? 0 > 0{
                    textCMD?.addCmdWithPrint(textst, text: isCustomCopy ? self.getPriceText(title: "DELIVERY CHARGE", price: order.deliveryCharge ?? 0, size: structure.size) : String(format: "Delivery Charge: %.2f\n", order.deliveryCharge ?? 0), structure: structure)
                }
                
                if structure.type == .dueAmount && dueAmount > 0{
                    textCMD?.addCmdWithPrint(textst, text: isCustomCopy ? self.getPriceText(title: "CHANGE", price: dueAmount, size: structure.size) : String(format: "Change: %.2f\n", dueAmount), structure: structure)
                }
                
                if structure.type == .grandTotal{
                    textCMD?.addCmdWithPrint(textst, text: isCustomCopy ? self.getPriceText(title: "TOTAL", price: order.total ?? 0, size: structure.size) : String(format: "Total: %.2f\n", order.total ?? 0), structure: structure)
                }
                
                if structure.type == .serveBy{
                    textCMD?.addCmdWithPrint(textst, text: "Served By: \(AppConstants.userData?.username ?? "")\n", structure: structure)
                }
                
                if structure.type == .paymentDetail && order.arrOrderPayments.count > 0 && structure.visibility == 1{
                    if paymentDetailHeader != nil{
                        textCMD?.addCmdWithPrint(textst, text: "Payment Details: \n", structure: paymentDetailHeader!, showLine: false)
                    }
                    order.arrOrderPayments.forEach { model in
                        if model.paymentMethodId ?? 0 == 5{
                            textCMD?.addCmdWithPrint(textst, text: String.init(format: "Paid Via Voucher: %.2f\n", model.amount ?? 0), structure: structure, showLine: false)
                        }else{
                            textCMD?.addCmdWithPrint(textst, text: String.init(format: "%@ Payment: %.2f\n", model.paymentMethodName ?? "" , model.amount ?? 0), structure: structure, showLine: false)
                        }
                    }
                    if structure.separator{
                        textCMD?.addLinePrintCommand(textst!)
                    }
                }
                
                if structure.type == .customerDetail && structure.visibility == 1{
                    var isCustomerAdded = false
                    if order.customer?.name ?? "" != ""{
                        textCMD?.addCmdWithPrint(textst, text: isCustomCopy ? "\(order.customer?.name ?? "")\n" : "Cust Name: \(order.customer?.name ?? "")\n", structure: structure, showLine: false)
                        isCustomerAdded = true
                    }
                    if order.orderTypeId ?? 0 == 3{
                        let arrAddress = [order.customer?.houseNo, order.customer?.street, order.customer?.city, order.customer?.postcode].compactMap{ $0 }.filter{ $0.removeSpace.isEmpty }
                        if arrAddress.count > 0{
                            let address = self.getMultipleLineText(name: isCustomCopy ? arrAddress.joined(separator: ", ") : "Address: \(arrAddress.joined(separator: ", "))", size: structure.size)
                            textCMD?.addCmdWithPrint(textst, text: address, structure: structure, showLine: false)
                            isCustomerAdded = true
                        }
                    }
                    if order.customer?.mobile ?? "" != ""{
                        textCMD?.addCmdWithPrint(textst, text: isCustomCopy ? "\(order.customer?.mobile ?? "")\n" : "Cust No: \(order.customer?.mobile ?? "")\n", structure: structure, showLine: false)
                        isCustomerAdded = true
                    }
                    if structure.separator && structure.visibility == 1 && isCustomerAdded{
                        textCMD?.addLinePrintCommand(textst!)
                    }
                }
                
                if structure.type == .paymentStatus{
                    textCMD?.addCmdWithPrint(textst, text: isCustomCopy ? paymentStatus.uppercased() : "Payment Status:\(paymentStatus)", structure: structure)
                }
                
                if structure.type == .orderComment && !(order.comment ?? "").isEmpty{
                    let comment = self.getMultipleLineText(name: isCustomCopy ? "Comment: \(order.comment ?? "")" :"Order Comment: \(order.comment ?? "")", size: structure.size)
                    textCMD?.addCmdWithPrint(textst, text: comment, structure: structure)
                }
                
                if structure.type == .receiptTime{
                    textCMD?.addCmdWithPrint(textst, text: "Receipt Date: \(Date().getDateInString(format: "dd-MM-yyyy hh:mm a"))\n", structure: structure)
                }
                
                if structure.type == .footerOrderType{
                    textCMD?.addCmdWithPrint(textst, text: isCustomCopy ? "\((order.orderType ?? "").uppercased())\n" : "** \((order.orderType ?? "")) **\n", structure: structure)
                }
                
                if structure.type == .footerTableNumber && order.orderTypeId ?? 0 == 1{
                    textCMD?.addCmdWithPrint(textst, text: "Table No: \(order.table?.number ?? "")\n", structure: structure)
                }
                
                if structure.type == .footerOrderNumber{
                    textCMD?.addCmdWithPrint(textst, text: "Order No: \(order.id ?? 0)\n", structure: structure)
                }
                
                if structure.type == .footer{
                    let footerA = AppCommonMethods.fetchSiteSettingValue(key: "footer_a", lowercased: false) ?? ""
                    let footerB = AppCommonMethods.fetchSiteSettingValue(key: "footer_b", lowercased: false) ?? ""
                    textCMD?.addCmdWithPrint(textst, text: "\(footerA)\n", structure: structure, showLine: false)
                    textCMD?.addCmdWithPrint(textst, text: "\(footerB)\n", structure: structure)
                }
            }
        }else{
            textCMD?.addCmdWithPrint(textst, text: "** \((order.orderType ?? "").uppercased()) **\n",alignment: "center",size: "size1",style: "bold")
            
            if order.orderTypeId ?? 0 == 2{
                if order.customer?.name ?? "" != ""{
                    textCMD?.addCmdWithPrint(textst, text: "\(order.customer?.name ?? "")\n",alignment: "center")
                }
            }
            textCMD?.addCmdWithPrint(textst, text: "\(strOrderAction)\n")
            
            let useOrderNo = AppCommonMethods.fetchSiteSettingValue(key: "use_table_number_or_order_number") ?? ""
            if useOrderNo == "order_number" || useOrderNo == "both" || (useOrderNo == "table_number" && order.orderTypeId ?? 0 == 1){
                textCMD?.append(textCMD?.getTextCmd(textst, text: "------------------------------------------------\n"))
            }
            
            textCMD?.addCmdWithPrint(textst, text: orderNo, size: "size1", visibility: (useOrderNo == "order_number" || useOrderNo == "both") ? 1 : 0)
            if order.orderTypeId ?? 0 == 1{
                textCMD?.addCmdWithPrint(textst, text: tableNo, visibility: (useOrderNo == "table_number" || useOrderNo == "both") ? 1 : 0)
            }else{
                textCMD?.addCmdWithPrint(textst, text: orderType, size: "size1", style: "bold")
            }
            if useOrderNo == "order_number" || useOrderNo == "both" || (useOrderNo == "table_number" && order.orderTypeId ?? 0 == 1){
                textCMD?.append(textCMD?.getTextCmd(textst, text: "------------------------------------------------\n"))
            }
            textCMD?.addCmdWithPrint(textst, text: orderDate, style: "bold")
            
            textCMD?.addCmdWithPrint(textst, text: "Qty  Name\n")
            
            for product in arrNotAssignProduct{
                let strName = self.getTitleForOrder(product: product, isCustom: isCustomCopy, isOrderUpdate: isOrderUpdate)
                textCMD?.addCmdWithPrint(textst, text: "\(strName)",size: "size1", style: "bold")
                
                let strDesc = self.getAddonForPrepTicket(product: product, size: "size1", isBill: false, contain: true)
                if strDesc != ""{
                    textCMD?.addCmdWithPrint(textst, text: "\(strDesc.replacingOccurrences(of: AppConstants.currencySign, with: ""))")
                }
                
                _ = SQLiteManage.ExecuteQuery("UPDATE OrderProducts SET sent_to_kitchen = '1',  sent_to_kitchen_quantity = '0' WHERE item_unique_id = '\(product.uniqueId)'")
            }
            
            if arrNotAssignProduct.count > 0{
                textCMD?.addCmdWithPrint(textst, text: "--------------------\n", alignment: "center")
            }
            
            for i in 0..<arrBlockIds.count{
                let id = arrBlockIds[i]
                if let data = dictOrders["\(id)"], let name = data["name"] as? String, let arr = data["data"] as? [OrderProductModel]{
                    for product in arr{
                        let strName = self.getTitleForOrder(product: product, isCustom: isCustomCopy, isOrderUpdate: isOrderUpdate)
                        textCMD?.addCmdWithPrint(textst, text: "\(strName)",size: "size1", style: "bold")
                        
                        let strDesc = self.getAddonForPrepTicket(product: product, size: "size1", isBill: false, contain: true)
                        if strDesc != ""{
                            textCMD?.addCmdWithPrint(textst, text: "\(strDesc.replacingOccurrences(of: AppConstants.currencySign, with: ""))")
                        }
                        
                        _ = SQLiteManage.ExecuteQuery("UPDATE OrderProducts SET sent_to_kitchen = '1',  sent_to_kitchen_quantity = '0' WHERE item_unique_id = '\(product.uniqueId)'")
                    }
                    if arr.count > 0 && i != (arrBlockIds.count-1){
                        textCMD?.addCmdWithPrint(textst, text: "--------------------\n", alignment: "center")
                    }
                }
            }
            
            if AppCommonMethods.fetchSiteSettingValue(key: "kitchen_total_visible", lowercased: false) ?? "" == "yes"{
                textCMD?.addCmdWithPrint(textst, text: "------------------------------------------------\n")
                
                textst?.alignmode = Align_Right
                
                textCMD?.addCmdWithPrint(textst, text: self.getPriceText(title: "Sub Total", price: order.subTotal ?? 0), alignment: "right")
                
                if order.discount ?? 0 > 0{
                    textCMD?.addCmdWithPrint(textst, text: self.getPriceText(title: "Discount", price: order.discount ?? 0), alignment: "right")
                }
                if order.serviceCharge ?? 0 > 0{
                    textCMD?.addCmdWithPrint(textst, text: self.getPriceText(title: "Service Charge", price: order.serviceCharge ?? 0), alignment: "right")
                }
                if order.gratuity ?? 0 > 0{
                    textCMD?.addCmdWithPrint(textst, text: self.getPriceText(title: "Gratuity", price: order.gratuity ?? 0), alignment: "right")
                }
                if order.deliveryCharge ?? 0 > 0{
                    textCMD?.addCmdWithPrint(textst, text: self.getPriceText(title: "Delivery Charge", price: order.deliveryCharge ?? 0), alignment: "right")
                }
                
                textCMD?.addCmdWithPrint(textst, text: self.getPriceText(title: "Total", price: order.total ?? 0), alignment: "right", style: "bold")
                
            }
            
            textCMD?.addCmdWithPrint(textst, text: "------------------------------------------------\n")
            
            textCMD?.addCmdWithPrint(textst, text: "Served By: \(AppConstants.userData?.username ?? "")\n", style: "bold")
            
            textCMD?.addCmdWithPrint(textst, text: "------------------------------------------------\n")
            
            if order.customer?.name ?? "" != ""{
                textCMD?.addCmdWithPrint(textst, text: "Customer Name: \(order.customer?.name ?? "")\n", style: "bold")
            }
            if order.customer?.mobile ?? "" != ""{
                textCMD?.addCmdWithPrint(textst, text: "Customer Phone No: \(order.customer?.mobile ?? "")\n", style: "bold")
            }
            if order.orderTypeId ?? 0 == 3{
                let address = "Address: \(order.customer?.houseNo ?? ""), \(order.customer?.street ?? ""), \(order.customer?.postcode ?? ""), \(order.customer?.city ?? "")\n"
                textCMD?.addCmdWithPrint(textst, text: address, style: "bold")
                if order.customer?.distance ?? 0 != 0{
                    let distance = String.init(format: "Distance: %.1f miles\n", order.customer?.distance ?? 0)
                    textCMD?.addCmdWithPrint(textst, text: distance, style: "bold")
                }
            }
            
            textCMD?.addCmdWithPrint(textst, text: "------------------------------------------------\n")
            
            textCMD?.addCmdWithPrint(textst, text: paymentStatus, style: "bold")
            
            textCMD?.addCmdWithPrint(textst, text: "------------------------------------------------\n")
            
            if order.comment ?? "" != ""{
                textCMD?.addCmdWithPrint(textst, text: "Order Comment: \(order.comment ?? "")\n")
                textCMD?.addCmdWithPrint(textst, text: "------------------------------------------------\n")
            }
            
            textCMD?.addCmdWithPrint(textst, text: "** \((order.orderType ?? "").uppercased()) **\n",alignment: "center",size: "size1",style: "bold")
            
            textCMD?.addCmdWithPrint(textst, text: "Table No: \(order.table?.number ?? "")\n", alignment: "center", size: "size1", style: "bold")
            
            textCMD?.addCmdWithPrint(textst, text: "------------------------------------------------\n")
            
            textCMD?.addCmdWithPrint(textst, text: "Order No: \(order.id ?? 0)\n", alignment: "center", size: "size1", style: "bold")
            
            textCMD?.addCmdWithPrint(textst, text: "\(footerA)\n", alignment: "center")
            textCMD?.addCmdWithPrint(textst, text: "\(footerB)\n\n\n", alignment: "center")
        }
        
        textCMD?.append(textCMD?.getLFCmd())
        textCMD?.append(textCMD?.getLFCmd())
        textCMD?.append(textCMD?.getLFCmd())
        textCMD?.append(textCMD?.getLFCmd())
        
        textCMD?.append(textCMD?.getCutPaperCmd(CutterMode_Full))
        
        printer?.write(textCMD?.getCmd())
        isFromSuccess = true
        printer?.close()
        
        DispatchQueue.main.asyncAfter(deadline: .now()+1) {
            self.printNextOrderCopy(isFromFailed: false)
        }
        
    }
    
    func getTitleForOrder(product:OrderProductModel, size:String = "size1", showPrice:Bool = false, isForBill:Bool = false, isCustom:Bool, isOrderUpdate:Bool = false)->String{
        var strName = ""
        var quantity = product.quantity ?? 0
        if isOrderUpdate{
            quantity = product.sentToKitchenQuantity
        }
        var strQuantity = isCustom ? "\(quantity)x  " : "\(quantity)  "
        if quantity > 9{
            strQuantity = isCustom ? "\(quantity)x " : "\(quantity) "
        }
        if product.misc ?? 0 == 1 || isForBill{
            strName = "\(strQuantity)\(product.productName ?? "")"
        }else{
            strName = "\(strQuantity)\(product.product?.shortName ?? "")"
        }
        if showPrice{
            return self.getMultipleLineText(name: strName, size: size, price: String.init(format: " %.2f", (product.total ?? 0) - (product.addonPrice ?? 0)), isQuantity: true)
        }else{
            return self.getMultipleLineText(name: strName, size: size, isQuantity: true)
        }
    }
    
    func getTitleForOnlineOrder(product:WebProductDetailModel, size:String = "size1", showPrice:Bool = false, isCustom:Bool)->String{
        var quantity = product.quantity ?? 0
        var strQuantity = isCustom ? "\(quantity)x  " : "\(quantity)  "
        if quantity > 9{
            strQuantity = isCustom ? "\(quantity)x " : "\(quantity) "
        }
        let strName = "\(strQuantity)\(product.menuName ?? "")"
        if showPrice{
            return self.getMultipleLineText(name: strName, size: size, price: String.init(format: " %.2f", product.totalPrice ?? 0), isQuantity: true)
        }else{
            return self.getMultipleLineText(name: strName, size: size, isQuantity: true)
        }
    }
    
    func getAddonForPrepTicket(product:OrderProductModel, size:String, isBill:Bool, contain:Bool)->String{
        var strDesc = ""
        if product.specialInstruction ?? "" != ""{
            let instruction = self.getMultipleLineText(name: String.init(format: "Instruction: %@", product.specialInstruction ?? ""), size: size)
            
            if strDesc == ""{
                strDesc = instruction
            }else{
                strDesc = "\(strDesc)\(instruction)"
            }
        }
        
        var arrAddon = [AddOnModel]()
        for addon in product.arrAddons{
            if let model = CoreDataHelper.shared.fetchAddOnData(addonId: addon.AddonId ?? 0), let addon2 = CoreDataHelper.shared.fetchAddOnData(addonId: model.parentId ?? 0){
                let index = arrAddon.firstIndex(where: { object in
                    return object.id ?? 0 == addon2.id ?? 0
                })
                if index != nil{
                    arrAddon[index!].selectedAddon.append(addon)
                }else{
                    addon2.selectedAddon.append(addon)
                    arrAddon.append(addon2)
                }
            }
        }
        
        arrAddon.forEach({ (addon) in
            if AppCommonMethods.fetchSiteSettingValue(key: "prep_location_subaddon_status") ?? "" == "show"{
                var strAddon = String.init(format: "   %@", addon.name ?? "")
                strAddon = self.getMultipleLineText(name: strAddon, size: size, isQuantity: true)
                
                if strDesc == ""{
                    strDesc = strAddon
                }else{
                    strDesc = "\(strDesc)\(strAddon)"
                }
            }
            
            addon.selectedAddon.forEach({ (addon) in
                var strAddon = ""
                if addon.quantity > 9{
                    strAddon =  String.init(format: "%d %@", addon.quantity, addon.name ?? "")
                }else if addon.quantity > 1{
                    strAddon =  String.init(format: "%d  %@", addon.quantity, addon.name ?? "")
                }else{
                    strAddon =  String.init(format: "   %@", addon.name ?? "")
                }
                let price = isBill && (addon.total ?? 0) > 0 ? String.init(format: "%0.2f", addon.total ?? 0) : ""
                strAddon = self.getMultipleLineText(name: strAddon, size: size, price: price, isQuantity: true)
                if strDesc == ""{
                    strDesc = strAddon
                }else{
                    strDesc = "\(strDesc)\(strAddon)"
                }
            })
            
        })
        
        product.arrIngriedent.forEach({ (ingrident) in
            var strIngrident = ""
            if contain{
                if ingrident.with ?? 0 == 0{
                    strIngrident = String.init(format: "No %@", ingrident.name ?? "")
                }else{
                    if ingrident.quantity ?? 0 > 9{
                        strIngrident = String.init(format: "%d Extra %@", ingrident.quantity ?? 0, ingrident.name ?? "")
                    }else{
                        strIngrident = String.init(format: "%d  Extra %@", ingrident.quantity ?? 0, ingrident.name ?? "")
                    }
                }
            }else{
                if ingrident.with ?? 0 == 0{
                    strIngrident = ingrident.name ?? ""
                }else{
                    if ingrident.quantity ?? 0 > 9{
                        strIngrident = String.init(format: "%d %@", ingrident.quantity ?? 0, ingrident.name ?? "")
                    }else{
                        strIngrident = String.init(format: "%d  %@", ingrident.quantity ?? 0, ingrident.name ?? "")
                    }
                }
            }
//            let price = isBill && (ingrident.total ?? 0) > 0 ? String.init(format: "%0.2f", ingrident.total ?? 0) : ""
            strIngrident = self.getMultipleLineText(name: strIngrident, size: size, isQuantity: true)
            if strDesc == ""{
                strDesc = strIngrident
            }else{
                strDesc = "\(strDesc)\(strIngrident)"
            }
        })
        
        return strDesc
    }
    
    func printOrderBill(order:OrderModel,image:UIImage?){
        var isCustomCopy = false
        let printModel = AppConstants.printSettings?.filter({ model in
            if model.name == "Custom Bill"{
                isCustomCopy = true
            }
            return model.name == "Custom Bill" || model.name == "Bill"
        }).first
        
        let textCMD = ESCFactory.create()
        textCMD?.clear()
        
        textCMD?.encodingType = Encoding_GBK
        textCMD?.append(textCMD?.getHeaderCmd())
        
        let textst = printer?.textSets
        
        let header = AppCommonMethods.fetchSiteSettingValue(key: "ticket_header", lowercased: false) ?? ""
        
        
        
        let orderNo = "\(AppConstants.userData?.preffix ?? "")\(order._id)\n"
        let tableNo = "Table No: \(order.table?.number ?? "")\n"
        let dinerNo = "No of Diner: \(order.noGuest ?? 0)\n"
        let orderType = "Order Type: \(order.orderType ?? "")\n"
        
        var dateFormat = ""
        if AppCommonMethods.fetchSiteSettingValue(key: "date_time_in_receipt_printing") ?? "" == "date_time"{
            dateFormat = "yyyy-MM-dd HH:mm:ss"
        }else if AppCommonMethods.fetchSiteSettingValue(key: "date_time_in_receipt_printing") ?? "" == "date"{
            dateFormat = "yyyy-MM-dd"
        }else if AppCommonMethods.fetchSiteSettingValue(key: "date_time_in_receipt_printing") ?? "" == "time"{
            dateFormat = "HH:mm:ss"
        }
        
        let orderDate = "Order Date: \((order.deliveryDate ?? "").changeDateFormat(fromFormat: "yyyy-MM-dd HH:mm:ss", toFormat: dateFormat) ?? "")\n"
        
        
        var arrNotAssignProduct = [OrderProductModel]()
        var dictOrders = [String:[OrderProductModel]]()
        
        var arrBlockIds = [Int]()
        var arrProducts = order.arrProducts
        if self.splitGroup != nil{
            arrProducts = order.arrProducts.filter({ (model) -> Bool in
                return model.orderSplitId == self.splitGroup?.id ?? 0
            })
        }
        
        for product in arrProducts{
            if let block = CoreDataHelper.shared.fetchPrintBlockObject(categoryId: product.product?.categoryId ?? 0){
                if var arr = dictOrders["\(block.sequence ?? 0)"]{
                    arr.append(product)
                    dictOrders["\(block.sequence ?? 0)"] = arr
                }else{
                    arrBlockIds.append(block.sequence ?? 0)
                    dictOrders["\(block.sequence ?? 0)"] = [product]
                }
            }else{
                arrNotAssignProduct.append(product)
            }
        }
        
        arrBlockIds.sort { (id1, id2) -> Bool in
            return id2 > id1
        }
        
        var strCustomer = ""
        if order.customer?.name ?? "" != ""{
            strCustomer = "Customer Name: \(order.customer?.name ?? "")\n"
        }
        if order.customer?.mobile ?? "" != ""{
            strCustomer = "\(strCustomer)Phone No: \(order.customer?.mobile ?? "")\n"
        }
        if order.orderTypeId ?? 0 == 3{
            let address = "Address: \(order.customer?.houseNo ?? ""), \(order.customer?.street ?? ""), \(order.customer?.postcode ?? ""), \(order.customer?.city ?? "")\n"
            strCustomer = "\(strCustomer)\(address)"
            if order.customer?.distance ?? 0 != 0{
                let distance = String.init(format: "Distance: %.1f miles\n", order.customer?.distance ?? 0)
                strCustomer = "\(strCustomer)\(distance)"
            }
        }
        
        var paymentStatus = ""
        if order.totalPaid ?? 0 >= (order.total ?? 0) && order.total ?? 0 > 0{
            let status = AppCommonMethods.fetchSiteSettingValue(key: "paid_payment_title", lowercased: false) ?? ""
            if status != ""{
                paymentStatus = status
            }else{
                paymentStatus = "Paid"
            }
        }else if order.totalPaid ?? 0 > 0{
            let status = AppCommonMethods.fetchSiteSettingValue(key: "partial_payment_title", lowercased: false) ?? ""
            if status != ""{
                paymentStatus = status
            }else{
                paymentStatus = "Partially Paid"
            }
        }else{
            let status = AppCommonMethods.fetchSiteSettingValue(key: "unpaid_payment_title", lowercased: false) ?? ""
            if status != ""{
                paymentStatus = status
            }else{
                paymentStatus = "Unpaid"
            }
        }
        paymentStatus = "\(paymentStatus)\n"
        
        let footerA = AppCommonMethods.fetchSiteSettingValue(key: "footer_a", lowercased: false) ?? ""
        let footerB = AppCommonMethods.fetchSiteSettingValue(key: "footer_b", lowercased: false) ?? ""
        
        if printModel != nil{
            let arrStructure = printModel!.structure
            
            let subAddon = arrStructure.filter { model in
                return model.type == .itemsSubaddon && model.visibility == 1
            }.first
            
            let orderTime = arrStructure.filter { model in
                return model.type == .orderTime && model.visibility == 1
            }.first
            
            let noOfDiners = arrStructure.filter { model in
                return model.type == .noOfDiners && model.visibility == 1
            }.first
            
            let paymentDetailHeader = arrStructure.filter { model in
                return model.type == .paymentDetailHeader && model.visibility == 1
            }.first
            
            let itemsHeader = arrStructure.filter { model in
                return model.type == .itemsHeader && model.visibility == 1
            }.first
            
            let dueAmount = (order.totalPaid ?? 0) - (order.total ?? 0)
            
            for structure in arrStructure {
//                print("name: \(structure.type?.rawValue ?? ""), visibility: \(structure.visibility), alignment: \(structure.alignment), style: \(structure.style), size: \(structure.size), sequence: \(structure.sequence)")
                if structure.type == .logo && image != nil && structure.visibility == 1{
                    let imageCMD = ESCFactory.create()
                    imageCMD?.clear()
                    imageCMD?.encodingType = Encoding_UTF8
                    imageCMD?.append(imageCMD?.getHeaderCmd())
                    let bitmapSetting = self.printer?.bitmapSetts
                    bitmapSetting?.alignmode = imageCMD?.getAlignment(structure.alignment.lowercased()) ?? Align_Center
                    bitmapSetting?.limitWidth = 30*8
                    imageCMD?.append(imageCMD?.getBitMapCmd(bitmapSetting, image: image))
                    imageCMD?.append(imageCMD?.getPrintEnd(1))
                    printer?.write(imageCMD?.getCmd())
                }
                
                if structure.type == .ticketHeader && !header.isEmpty{
                    textCMD?.addCmdWithPrint(textst, text: "\(header)\n", structure: structure)
                }
                
                
                if structure.type == .orderType && isCustomCopy{
                    textCMD?.addCmdWithPrint(textst, text: isCustomCopy ? "\((order.orderType?.uppercased() ?? ""))\n" : "** \((order.orderType ?? "")) **\n", structure: structure)
                }
                
                if structure.type == .headerCustomerName && !(order.customerName ?? "").removeSpace.isEmpty{
                    textCMD?.addCmdWithPrint(textst, text: "\(order.customerName ?? "")\n", structure: structure)
                }
                
                if structure.type == .orderNo{
                    textCMD?.addCmdWithPrint(textst, text: isCustomCopy ? orderNo : "Order No: \(orderNo)", structure: structure)
                }
                
                if structure.type == .tableNo && order.orderTypeId ?? 0 == 1{
                    var tableNo = "Table No: \(order.table?.number ?? "")\n"
                    if noOfDiners != nil && !isCustomCopy{
                        tableNo = "Table No: \(order.table?.number ?? "")"
                        let dinerNo = " Diner: \(order.noGuest ?? 0)\n"
                        textCMD?.addCmdWithPrint(textst, text: tableNo, structure: structure, showLine: false)
                        textCMD?.addCmdWithPrint(textst, text: dinerNo, structure: noOfDiners!)
                        continue
                    }
                    textCMD?.addCmdWithPrint(textst, text: tableNo, structure: structure)
                }
                
                if structure.type == .noOfDiners && isCustomCopy && order.orderTypeId ?? 0 == 1{
                    textCMD?.addCmdWithPrint(textst, text: "Diner: \(order.noGuest ?? 0)\n", structure: structure)
                }
                
                if structure.type == .orderDate{
                    let date = (order.deliveryDate ?? "").components(separatedBy: "T").first?.changeDateFormat(fromFormat: "yyyy-MM-dd", toFormat: "dd-MM-yyyy") ?? ""
                    if orderTime != nil{
                        textCMD?.addCmdWithPrint(textst, text: "Date: \(date)", structure: structure, showLine: false)
                        let time = order.deliveryDate?.components(separatedBy: "T").last?.components(separatedBy: ".").first?.changeDateFormat(fromFormat: "HH:mm:ss", toFormat: "hh:mm a") ?? ""
                        textCMD?.addCmdWithPrint(textst, text: " Time: \(time)\n", structure: orderTime!)
                        continue
                    }
                    textCMD?.addCmdWithPrint(textst, text: "Date: \(date)\n", structure: structure)
                }
                
                if structure.type == .itemsHeader && isCustomCopy{
                    textCMD?.addCmdWithPrint(textst, text: "Qty  Name\n", structure: structure)
                }
                
                if structure.type == .items && structure.visibility == 1{
                    if itemsHeader != nil && !isCustomCopy{
                        textCMD?.addCmdWithPrint(textst, text: "Qty  Name\n", structure: itemsHeader!, showLine: false)
                    }
                    let allSeparator = structure.allSeparator == 1
                    for product in arrNotAssignProduct{
                        let strName = self.getTitleForOrder(product: product, size: structure.size, showPrice: structure.price == 1, isForBill: true, isCustom: isCustomCopy)
                        textCMD?.addCmdWithPrint(textst, text: strName, structure: structure, showLine: false)
                        
                        if let subAddon{
                            let strDesc = self.getAddonForPrepTicket(product: product, size: subAddon.size, isBill: true, contain: structure.contain)
                            if strDesc != ""{
                                textCMD?.addCmdWithPrint(textst, text: strDesc, structure: subAddon, showLine: false)
                            }
                        }
                        if allSeparator{
                            textCMD?.addLinePrintCommand(textst!)
                        }
                    }
                    for i in 0..<arrBlockIds.count{
                        let id = arrBlockIds[i]
                        if let arr = dictOrders["\(id)"]{
                            for product in arr{
                                let strName = self.getTitleForOrder(product: product, size: structure.size, showPrice: structure.price == 1, isForBill: true, isCustom: isCustomCopy)
                                textCMD?.addCmdWithPrint(textst, text: strName, structure: structure, showLine: false)
                                
                                if let subAddon{
                                    let strDesc = self.getAddonForPrepTicket(product: product, size: subAddon.size, isBill: true, contain: structure.contain)
                                    if strDesc != ""{
                                        textCMD?.addCmdWithPrint(textst, text: strDesc, structure: subAddon, showLine: false)
                                    }
                                }
                                if allSeparator{
                                    textCMD?.addLinePrintCommand(textst!)
                                }
                            }
                        }
                    }
                    if !allSeparator && structure.separator{
                        textCMD?.addLinePrintCommand(textst!)
                    }
                }
                
                
                if structure.type == .subtotal{
                    textCMD?.addCmdWithPrint(textst, text: isCustomCopy ? self.getPriceText(title: "SUB TOTAL", price: order.subTotal ?? 0, size: structure.size) : String(format: "Sub Total: %.2f\n", order.subTotal ?? 0), structure: structure)
                }
                
                if structure.type == .discount && order.discount ?? 0 > 0{
                    textCMD?.addCmdWithPrint(textst, text: isCustomCopy ? self.getPriceText(title: "DISCOUNT", price: order.discount ?? 0, size: structure.size) : String(format: "Discount: %.2f\n", order.discount ?? 0), structure: structure)
                }
                
                if structure.type == .serviceCharge && order.serviceCharge ?? 0 > 0{
                    textCMD?.addCmdWithPrint(textst, text: isCustomCopy ? self.getPriceText(title: "SERVICE CHARGE", price: order.serviceCharge ?? 0, size: structure.size) : String(format: "Service Charge: %.2f\n", order.serviceCharge ?? 0), structure: structure)
                }
                
                if structure.type == .gratuity && order.gratuity ?? 0 > 0{
                    textCMD?.addCmdWithPrint(textst, text: isCustomCopy ? self.getPriceText(title: "GRATUITY", price: order.gratuity ?? 0, size: structure.size) : String(format: "Gratuity: %.2f\n", order.gratuity ?? 0), structure: structure)
                }
                
                if structure.type == .deliveryCharge && order.deliveryCharge ?? 0 > 0{
                    textCMD?.addCmdWithPrint(textst, text: isCustomCopy ? self.getPriceText(title: "DELIVERY CHARGE", price: order.deliveryCharge ?? 0, size: structure.size) : String(format: "Delivery Charge: %.2f\n", order.deliveryCharge ?? 0), structure: structure)
                }
                
                if structure.type == .dueAmount && dueAmount > 0{
                    textCMD?.addCmdWithPrint(textst, text: isCustomCopy ? self.getPriceText(title: "CHANGE", price: dueAmount, size: structure.size) : String(format: "Change: %.2f\n", dueAmount), structure: structure)
                }
                
                if structure.type == .grandTotal{
                    textCMD?.addCmdWithPrint(textst, text: isCustomCopy ? self.getPriceText(title: "TOTAL", price: order.total ?? 0, size: structure.size) : String(format: "Total: %.2f\n", order.total ?? 0), structure: structure)
                }
                
                if structure.type == .serveBy{
                    textCMD?.addCmdWithPrint(textst, text: "Served By: \(AppConstants.userData?.username ?? "")\n", structure: structure)
                }
                
                if structure.type == .paymentDetail && order.arrOrderPayments.count > 0 && structure.visibility == 1{
                    if paymentDetailHeader != nil{
                        textCMD?.addCmdWithPrint(textst, text: "Payment Details: \n", structure: paymentDetailHeader!, showLine: false)
                    }
                    order.arrOrderPayments.forEach { model in
                        if model.paymentMethodId ?? 0 == 5{
                            textCMD?.addCmdWithPrint(textst, text: String.init(format: "Paid Via Voucher: %.2f\n", model.amount ?? 0), structure: structure, showLine: false)
                        }else{
                            textCMD?.addCmdWithPrint(textst, text: String.init(format: "%@ Payment: %.2f\n", model.paymentMethodName ?? "" , model.amount ?? 0), structure: structure, showLine: false)
                        }
                    }
                    if structure.separator{
                        textCMD?.addLinePrintCommand(textst!)
                    }
                }
                
                if structure.type == .customerDetail && structure.visibility == 1{
                    var isCustomerAdded = false
                    if order.customer?.name ?? "" != ""{
                        textCMD?.addCmdWithPrint(textst, text: isCustomCopy ? "\(order.customer?.name ?? "")\n" : "Cust Name: \(order.customer?.name ?? "")\n", structure: structure, showLine: false)
                        isCustomerAdded = true
                    }
                    if order.orderTypeId ?? 0 == 3{
                        let arrAddress = [order.customer?.houseNo, order.customer?.street, order.customer?.city, order.customer?.postcode].compactMap{ $0 }.filter{ $0.removeSpace.isEmpty }
                        if arrAddress.count > 0{
                            let address = self.getMultipleLineText(name: isCustomCopy ? arrAddress.joined(separator: ", ") : "Address: \(arrAddress.joined(separator: ", "))", size: structure.size)
                            textCMD?.addCmdWithPrint(textst, text: address, structure: structure, showLine: false)
                            isCustomerAdded = true
                        }
                    }
                    if order.customer?.mobile ?? "" != ""{
                        textCMD?.addCmdWithPrint(textst, text: isCustomCopy ? "\(order.customer?.mobile ?? "")\n" : "Cust No: \(order.customer?.mobile ?? "")\n", structure: structure, showLine: false)
                        isCustomerAdded = true
                    }
                    if structure.separator && structure.visibility == 1 && isCustomerAdded{
                        textCMD?.addLinePrintCommand(textst!)
                    }
                }
                
                if structure.type == .paymentStatus{
                    textCMD?.addCmdWithPrint(textst, text: isCustomCopy ? paymentStatus.uppercased() : "Payment Status:\(paymentStatus)", structure: structure)
                }
                
                if structure.type == .orderComment && !(order.comment ?? "").isEmpty{
                    let comment = self.getMultipleLineText(name: isCustomCopy ? "Comment: \(order.comment ?? "")" :"Order Comment: \(order.comment ?? "")", size: structure.size)
                    textCMD?.addCmdWithPrint(textst, text: comment, structure: structure)
                }
                
                if structure.type == .receiptTime{
                    textCMD?.addCmdWithPrint(textst, text: "Receipt Date: \(Date().getDateInString(format: "dd-MM-yyyy hh:mm a"))\n", structure: structure)
                }
                
                if structure.type == .footerOrderType{
                    textCMD?.addCmdWithPrint(textst, text: isCustomCopy ? "\((order.orderType ?? "").uppercased())\n" : "** \((order.orderType ?? "")) **\n", structure: structure)
                }
                
                if structure.type == .footerTableNumber && order.orderTypeId ?? 0 == 1{
                    textCMD?.addCmdWithPrint(textst, text: "Table No: \(order.table?.number ?? "")\n", structure: structure)
                }
                
                if structure.type == .footerOrderNumber{
                    textCMD?.addCmdWithPrint(textst, text: "Order No: \(order.id ?? 0)\n", structure: structure)
                }
                
                if structure.type == .footer{
                    let footerA = AppCommonMethods.fetchSiteSettingValue(key: "footer_a", lowercased: false) ?? ""
                    let footerB = AppCommonMethods.fetchSiteSettingValue(key: "footer_b", lowercased: false) ?? ""
                    textCMD?.addCmdWithPrint(textst, text: "\(footerA)\n", structure: structure, showLine: false)
                    textCMD?.addCmdWithPrint(textst, text: "\(footerB)\n", structure: structure)
                }
            }
        }else{
            
            let type = AppCommonMethods.fetchSiteSettingValue(key: "ticket_header_type") ?? ""
            if type == "center"{
                textst?.alignmode = Align_Center
            }else if type == "right"{
                textst?.alignmode = Align_Right
            }else{
                textst?.alignmode = Align_Left
            }
            textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "\(header)\n"))
            let useOrderNo = AppCommonMethods.fetchSiteSettingValue(key: "use_table_number_or_order_number") ?? ""
            if useOrderNo == "order_number" || useOrderNo == "both" || (useOrderNo == "table_number" && order.orderTypeId ?? 0 == 1){
                textCMD?.append(textCMD?.getTextCmd(textst, text: "------------------------------------------------\n"))
            }
            textCMD?.append(textCMD?.getTextCmd(textst, text: "------------------------------------------------\n"))
            textCMD?.addCmdWithPrint(textst, text: orderNo, size: "size1", visibility: (useOrderNo == "order_number" || useOrderNo == "both") ? 1 : 0)
            if order.orderTypeId ?? 0 == 1{
                textCMD?.addCmdWithPrint(textst, text: tableNo, visibility: (useOrderNo == "table_number" || useOrderNo == "both") ? 1 : 0)
            }else{
                textCMD?.addCmdWithPrint(textst, text: orderType, size: "size1", style: "bold")
            }
            if useOrderNo == "order_number" || useOrderNo == "both" || (useOrderNo == "table_number" && order.orderTypeId ?? 0 == 1){
                textCMD?.append(textCMD?.getTextCmd(textst, text: "------------------------------------------------\n"))
            }
            textCMD?.addCmdWithPrint(textst, text: orderDate)
            
            textCMD?.addCmdWithPrint(textst, text: "Qty  Name\n")
            
            for product in arrNotAssignProduct{
                let title = self.getTitleForOrder(product: product, size: "size0", showPrice: true, isForBill: true, isCustom: isCustomCopy)
                textCMD?.addCmdWithPrint(textst, text: title)
                
                let addon = self.getAddonForPrepTicket(product: product, size: "size0", isBill: true, contain: true)
                if addon != ""{
                    textCMD?.addCmdWithPrint(textst, text: "\(addon)")
                }
            }
            if arrNotAssignProduct.count > 0 && AppCommonMethods.fetchSiteSettingValue(key: "print_block_bill") ?? "" == "yes"{
                textCMD?.addCmdWithPrint(textst, text: "            -----\n")
            }
            for i in 0..<arrBlockIds.count{
                let id = arrBlockIds[i]
                if let arr = dictOrders["\(id)"]{
                    for product in arr{
                        let title = self.getTitleForOrder(product: product, size: "size0", showPrice: true, isForBill: true, isCustom: isCustomCopy)
                        textCMD?.addCmdWithPrint(textst, text: title)
                        
                        let addon = self.getAddonForPrepTicket(product: product, size: "size0", isBill: true, contain: true)
                        if addon != ""{
                            textCMD?.addCmdWithPrint(textst, text: "\(addon)")
                        }
                    }
                    if AppCommonMethods.fetchSiteSettingValue(key: "print_block_bill") ?? "" == "yes" && arr.count > 0 && i < (arrBlockIds.count-1){
                        textCMD?.addCmdWithPrint(textst, text: "            -----\n")
                    }
                }
            }
            
            textCMD?.addCmdWithPrint(textst, text: "------------------------------------------------\n")
            
            if splitGroup != nil{
                textCMD?.addCmdWithPrint(textst, text: self.getPriceText(title: "Sub Total", price: splitGroup!.total ?? 0), alignment: "right")
                
                textCMD?.addCmdWithPrint(textst, text: self.getPriceText(title: "Total", price: splitGroup!.total ?? 0), alignment: "right", style: "bold")
            }else{
                textCMD?.addCmdWithPrint(textst, text: self.getPriceText(title: "Sub Total", price: order.subTotal ?? 0), alignment: "right")
                
                if order.discount ?? 0 > 0{
                    textCMD?.addCmdWithPrint(textst, text: self.getPriceText(title: "Discount", price: order.discount ?? 0), alignment: "right")
                }
                if order.serviceCharge ?? 0 > 0{
                    textCMD?.addCmdWithPrint(textst, text: self.getPriceText(title: "Service Charge", price: order.serviceCharge ?? 0), alignment: "right")
                }
                if order.gratuity ?? 0 > 0{
                    textCMD?.addCmdWithPrint(textst, text: self.getPriceText(title: "Gratuity", price: order.gratuity ?? 0), alignment: "right")
                }
                if order.deliveryCharge ?? 0 > 0{
                    textCMD?.addCmdWithPrint(textst, text: self.getPriceText(title: "Delivery Charge", price: order.deliveryCharge ?? 0), alignment: "right")
                }
                textst?.isBold = Set_Enabled
                
                textCMD?.addCmdWithPrint(textst, text: self.getPriceText(title: "Total", price: order.total ?? 0), alignment: "right", style: "bold")
            }
            
            textCMD?.addCmdWithPrint(textst, text: "------------------------------------------------\n")
            
            if order.totalPaid ?? 0 > 0{
                textCMD?.addCmdWithPrint(textst, text: "Payment Details\n")
                for model in order.arrOrderPayments{
                    var method = model.paymentMethodName ?? ""
                    if model.paymentMethodId ?? 0 == 2 || model.id ?? 0 == 10 || model.id ?? 0 == 9{
                        let title = AppCommonMethods.fetchSiteSettingValue(key: "card_payment_type", lowercased: false) ?? ""
                        if title != ""{
                            method = title
                        }
                    }
                    if model.paymentMethodId ?? 0 == 1{
                        let title = AppCommonMethods.fetchSiteSettingValue(key: "cash_payment_type", lowercased: false) ?? ""
                        if title != ""{
                            method = title
                        }
                    }
                    textCMD?.addCmdWithPrint(textst, text: "\(method) : \(String.init(format: "%.2f", model.amount ?? 0))\n")
                }
                textCMD?.addCmdWithPrint(textst, text: "\n")
                textCMD?.addCmdWithPrint(textst, text: "------------------------------------------------\n")
            }
            textCMD?.addCmdWithPrint(textst, text: "Served By: \(AppConstants.userData?.username ?? "")\n")
            
            textCMD?.addCmdWithPrint(textst, text: "------------------------------------------------\n")
            
            if strCustomer != ""{
                textCMD?.addCmdWithPrint(textst, text: "\(strCustomer)\n")
                textCMD?.addCmdWithPrint(textst, text: "------------------------------------------------\n")
            }
            
            textCMD?.addCmdWithPrint(textst, text: paymentStatus, style: "bold")
            
            textCMD?.addCmdWithPrint(textst, text: "------------------------------------------------\n")
            
            if order.comment ?? "" != ""{
                textCMD?.addCmdWithPrint(textst, text: "Order Comment: \(order.comment ?? "")\n")
                textCMD?.addCmdWithPrint(textst, text: "------------------------------------------------\n")
            }
            
            textCMD?.addCmdWithPrint(textst, text: "\(footerA)\n", alignment: "center")
            textCMD?.addCmdWithPrint(textst, text: "\(footerB)\n\n\n", alignment: "center")
        }
        
        textCMD?.append(textCMD?.getLFCmd())
        textCMD?.append(textCMD?.getLFCmd())
        textCMD?.append(textCMD?.getLFCmd())
        textCMD?.append(textCMD?.getLFCmd())
        
        textCMD?.append(textCMD?.getCutPaperCmd(CutterMode_Full))
        
        printer?.write(textCMD?.getCmd())
        
        if self.arrGroups.count == 0{
            isPrinterConnected = false
            if shouldOpenDrawer && AppConstants.userData?.permissions?.cashdrawer?.actions?.list ?? 0 == 1{
                openCashDrawer()
            }else{
                //                self.disconnectedToPrinter()
                self.printer?.close()
            }
            
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
                DispatchQueue.main.asyncAfter(deadline: .now()+0.1) {
                    NotificationCenter.default.post(name: AppConstants.notifications.kDatabasePushed, object: nil)
                }
            }
        }
    }
    
    func getItemAddonForBill(product:OrderProductModel, size:String)->String{
        var strDesc = ""
        product.arrAddons.forEach({ (addon) in
            var strAddon = ""
            if addon.quantity > 9{
                strAddon = String.init(format: "%dx %@", addon.quantity, addon.name ?? "")
            }else{
                strAddon = String.init(format: " %dx %@", addon.quantity, addon.name ?? "")
            }
            strAddon = self.getMultipleLineText(name: strAddon, size: size, isQuantity: true, isAddon: true)
            
            if strDesc == ""{
                strDesc = strAddon
            }else{
                strDesc = "\(strDesc)\(strAddon)"
            }
        })
        
        product.arrIngriedent.forEach({ (ingrident) in
            var strIngrident = ""
            if ingrident.quantity ?? 0 > 9{
                if ingrident.with ?? 0 == 1{
                    strIngrident = String.init(format: "%dx - Add %@", ingrident.quantity ?? 0, ingrident.name ?? "")
                }else{
                    strIngrident = String.init(format: "%dx - Remove %@", ingrident.quantity ?? 0, ingrident.name ?? "")
                }
            }else{
                if ingrident.with ?? 0 == 1{
                    strIngrident = String.init(format: " %dx - Add %@", ingrident.quantity ?? 0, ingrident.name ?? "")
                }else{
                    strIngrident = String.init(format: " %dx - Remove %@", ingrident.quantity ?? 0, ingrident.name ?? "")
                }
            }
            strIngrident = self.getMultipleLineText(name: strIngrident, size: size, isQuantity: true, isAddon: true)
            
            if strDesc == ""{
                strDesc = strIngrident
            }else{
                strDesc = "\(strDesc)\(strIngrident)"
            }
        })
        
        if product.specialInstruction ?? "" != ""{
            let instruction = self.getMultipleLineText(name: String.init(format: "Instruction: %@", product.specialInstruction ?? ""), size: size, isAddon: true)
            
            if strDesc == ""{
                strDesc = instruction
            }else{
                strDesc = "\(strDesc)\(instruction)"
            }
        }
        return strDesc
    }
    
    func setReportData(report:FullReportModel)->[ReportModel]{
        var arrReports = [ReportModel]()
        arrReports.insert(ReportModel.init(status: "Orders", count: report.onlineOrderCount, rowType: 1), at: 0)
        arrReports.insert(ReportModel.init(status: "Reservations", count: report.onlineReservationCount, rowType: 1), at: 1)
        arrReports.insert(ReportModel.init(status: "Order Businesses", total: report.onlineOrderTotalBusiness), at: 2)
        arrReports.insert(ReportModel.init(status: "Order Commission", total: report.onlineOrderCalculatedCommission), at: 3)
        if report.onlineOrderType?.count ?? 0 > 0{
            arrReports.append(ReportModel.init(status: "Order Type", count: 0, rowType: 2))
            for model in report.onlineOrderType!{
                arrReports.append(ReportModel.init(status: "\(model.status ?? "")", count: model.count ?? 0, rowType: 1))
                arrReports.append(ReportModel.init(status: "\(model.status ?? "")", total: model.total ?? 0))
            }
        }
        if report.onlineOrderPayment?.count ?? 0 > 0{
            arrReports.append(ReportModel.init(status: "Order Payment", count: 0, rowType: 2))
            for model in report.onlineOrderPayment!{
                arrReports.append(ReportModel.init(status: "\(model.status ?? "")", count: model.count ?? 0, rowType: 1))
                arrReports.append(ReportModel.init(status: "\(model.status ?? "")", total: model.total ?? 0))
            }
        }
        
        return arrReports
    }
    
    func printReport(report:FullReportModel,image:UIImage?){
        if image != nil{
            let imageCMD = ESCFactory.create()
            imageCMD?.clear()
            imageCMD?.encodingType = Encoding_UTF8
            imageCMD?.append(imageCMD?.getHeaderCmd())
            let bitmapSetting = self.printer?.bitmapSetts
            bitmapSetting?.alignmode = Align_Center
            bitmapSetting?.limitWidth = 30*8
            imageCMD?.append(imageCMD?.getBitMapCmd(bitmapSetting, image: image))
            imageCMD?.append(imageCMD?.getPrintEnd(1))
            printer?.write(imageCMD?.getCmd())
        }
        
        let textCMD = ESCFactory.create()
        textCMD?.clear()
        textCMD?.encodingType = Encoding_GBK
        textCMD?.append(textCMD?.getHeaderCmd())
        
        let textst = self.printer?.textSets
        textst?.isUnderline = Set_DisEnable
        textst?.alignmode = Align_Left
        textst?.isTimes_Wide = Set_DisEnable
        textst?.isTimes_Heigh = Set_DisEnable
        textst?.isBold = Set_DisEnable
        
        let header = AppCommonMethods.fetchSiteSettingValue(key: "ticket_header", lowercased: false) ?? ""
        
        let type = AppCommonMethods.fetchSiteSettingValue(key: "ticket_header_type") ?? ""
        
        if type == "center"{
            textst?.alignmode = Align_Center
        }else if type == "right"{
            textst?.alignmode = Align_Right
        }else{
            textst?.alignmode = Align_Left
        }
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "\(header)\n"))
        
        
        textst?.alignmode = Align_Center
        textst?.isTimes_Wide = Set_Enabled
        textst?.isTimes_Heigh = Set_Enabled
        textst?.isBold = Set_Enabled
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "Online Order Report\n"))
        
        textst?.alignmode = Align_Left
        textst?.isTimes_Wide = Set_DisEnable
        textst?.isTimes_Heigh = Set_DisEnable
        textst?.isBold = Set_DisEnable
        
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "------------------------------------------------\n"))
        
        textst?.alignmode = Align_Center
        textst?.isTimes_Wide = Set_Enabled
        textst?.isTimes_Heigh = Set_Enabled
        textst?.isBold = Set_Enabled
        
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "Date: \(Date().getDateInString(format: "dd-MM-yyyy"))\n"))
        
        textst?.alignmode = Align_Left
        textst?.isTimes_Wide = Set_DisEnable
        textst?.isTimes_Heigh = Set_DisEnable
        textst?.isBold = Set_DisEnable
        
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "------------------------------------------------\n"))
        
        if reportType == RerportType.kSelectedUserReport{
            textst?.isBold = Set_Enabled
            
            textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "User Name: \(self.selectedUserName ?? "")\n"))
            
            textst?.isBold = Set_DisEnable
            
            textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "------------------------------------------------\n"))
        }
        
        let arrReports = self.setReportData(report: report)
        for report in arrReports{
            if report.showAll{
                textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "\(self.getNameWithPrice(name: report.status ?? "", strPrice: String.init(format: " %.2f", report.total ?? 0), count: report.count?.description ?? ""))"))
            }else{
                if report.rowType == 0{
                    textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "\(self.getNameWithPrice(name: report.status ?? "", strPrice: String.init(format: " %.2f", report.total ?? 0), count: "-"))"))
                }else if report.rowType == 1{
                    textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "\(self.getNameWithPrice(name: report.status ?? "", strPrice: "-", count: report.count?.description ?? ""))"))
                }else{
                    textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "------------------------------------------------\n"))
                    textst?.isBold = Set_Enabled
                    textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "\(report.status ?? "")\n"))
                    textst?.isBold = Set_DisEnable
                    textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "------------------------------------------------\n"))
                }
            }
        }
        
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "------------------------------------------------\n"))
        
        textst?.alignmode = Align_Center
        
        let footerA = AppCommonMethods.fetchSiteSettingValue(key: "footer_a", lowercased: false) ?? ""
        let footerB = AppCommonMethods.fetchSiteSettingValue(key: "footer_b", lowercased: false) ?? ""
        
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "\(footerA)\n"))
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "\(footerB)\n\n\n"))
        
        
        textCMD?.append(textCMD?.getLFCmd())
        textCMD?.append(textCMD?.getLFCmd())
        textCMD?.append(textCMD?.getLFCmd())
        textCMD?.append(textCMD?.getLFCmd())
        
        textCMD?.append(textCMD?.getCutPaperCmd(CutterMode_Full))
        
        printer?.write(textCMD?.getCmd())
        //        self.disconnectedToPrinter()
        self.printer?.close()
        self.printerObject = nil
        DispatchQueue.main.async {
            AppCommonMethods.stopProgressBar()
        }
    }
    
    func printReportList(arrReports:[ReportModel],image:UIImage?){
        if image != nil{
            let imageCMD = ESCFactory.create()
            imageCMD?.clear()
            imageCMD?.encodingType = Encoding_UTF8
            imageCMD?.append(imageCMD?.getHeaderCmd())
            let bitmapSetting = self.printer?.bitmapSetts
            bitmapSetting?.alignmode = Align_Center
            bitmapSetting?.limitWidth = 30*8
            imageCMD?.append(imageCMD?.getBitMapCmd(bitmapSetting, image: image))
            imageCMD?.append(imageCMD?.getPrintEnd(1))
            printer?.write(imageCMD?.getCmd())
        }
        
        let textCMD = ESCFactory.create()
        textCMD?.clear()
        textCMD?.encodingType = Encoding_GBK
        textCMD?.append(textCMD?.getHeaderCmd())
        
        let textst = self.printer?.textSets
        textst?.isUnderline = Set_DisEnable
        textst?.isTimes_Wide = Set_DisEnable
        textst?.isTimes_Heigh = Set_DisEnable
        textst?.isBold = Set_DisEnable
        
        let header = AppCommonMethods.fetchSiteSettingValue(key: "ticket_header", lowercased: false) ?? ""
        
        let type = AppCommonMethods.fetchSiteSettingValue(key: "ticket_header_type") ?? ""
        
        if type == "center"{
            textst?.alignmode = Align_Center
        }else if type == "right"{
            textst?.alignmode = Align_Right
        }else{
            textst?.alignmode = Align_Left
        }
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "\(header)\n"))
        
        textst?.alignmode = Align_Center
        textst?.isTimes_Wide = Set_Enabled
        textst?.isTimes_Heigh = Set_Enabled
        textst?.isBold = Set_Enabled
        if reportType == RerportType.kProductSaleReport{
            textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "Product Sales Report\n"))
        }else if reportType == RerportType.kProductCategoryReport{
            textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "Product Category Report\n"))
        }else if reportType == RerportType.kFullReport || reportType == RerportType.FullReportBeta{
            textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "Full Report\n"))
        }else if reportType == RerportType.kFullArchivedReport{
            textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "Full Archived Report\n"))
        }else if reportType == RerportType.kSelectedUserReport{
            textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "User Report\n"))
        }
        
        textst?.alignmode = Align_Left
        textst?.isTimes_Wide = Set_DisEnable
        textst?.isTimes_Heigh = Set_DisEnable
        textst?.isBold = Set_DisEnable
        
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "------------------------------------------------\n"))
        
        textst?.alignmode = Align_Center
        
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "\(strHeaderDate)\n"))
        
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "------------------------------------------------\n"))
        
        textst?.isBold = Set_Enabled
        
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "\(AppCommonMethods.readStringfromUserDefault(withKey: AppConstants.userDefaultKey.kDeviceName) ?? "")\n"))
        
        textst?.isBold = Set_DisEnable
        
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "------------------------------------------------\n"))
        
        if reportType == RerportType.kSelectedUserReport{
            textst?.alignmode = Align_Left
            
            textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "User Name: \(self.selectedUserName ?? "")\n"))
            
            textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "------------------------------------------------\n"))
        }
        
        textst?.alignmode = Align_Right
        
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "Orders     Price\n"))
        
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "------------------------------------------------\n"))
        
        textst?.alignmode = Align_Left
        
        for i in 0..<arrReports.count{
            let report = arrReports[i]
            if report.showAll{
                textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "\(self.getNameWithPrice(name: report.status ?? "", strPrice: String.init(format: " %.2f", report.total ?? 0), count: report.count?.description ?? ""))"))
            }else{
                if report.rowType == 0{
                    textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "\(self.getNameWithPrice(name: report.status ?? "", strPrice: String.init(format: " %.2f", report.total ?? 0), count: "-"))"))
                }else if report.rowType == 1{
                    textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "\(self.getNameWithPrice(name: report.status ?? "", strPrice: "-", count: report.count?.description ?? ""))"))
                }else{
                    if i != 0{
                        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "------------------------------------------------\n"))
                    }
                    textst?.isBold = Set_Enabled
                    textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "\(report.status ?? "")\n"))
                    textst?.isBold = Set_DisEnable
                    textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "------------------------------------------------\n"))
                }
            }
        }
        
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "------------------------------------------------\n"))
        
        textst?.alignmode = Align_Center
        
        let footerA = AppCommonMethods.fetchSiteSettingValue(key: "footer_a", lowercased: false) ?? ""
        let footerB = AppCommonMethods.fetchSiteSettingValue(key: "footer_b", lowercased: false) ?? ""
        
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "\(footerA)\n"))
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "\(footerB)\n\n\n"))
        
        textCMD?.append(textCMD?.getLFCmd())
        textCMD?.append(textCMD?.getLFCmd())
        textCMD?.append(textCMD?.getLFCmd())
        textCMD?.append(textCMD?.getLFCmd())
        
        textCMD?.append(textCMD?.getCutPaperCmd(CutterMode_Full))
        
        printer?.write(textCMD?.getCmd())
        
        //        self.disconnectedToPrinter()
        self.printer?.close()
        self.printerObject = nil
        DispatchQueue.main.async {
            AppCommonMethods.stopProgressBar()
        }
    }
    
    func printVoucher(voucher:VoucherModel,image:UIImage?){
        if image != nil{
            let imageCMD = ESCFactory.create()
            imageCMD?.clear()
            imageCMD?.encodingType = Encoding_UTF8
            imageCMD?.append(imageCMD?.getHeaderCmd())
            let bitmapSetting = self.printer?.bitmapSetts
            bitmapSetting?.alignmode = Align_Center
            bitmapSetting?.limitWidth = 30*8
            imageCMD?.append(imageCMD?.getBitMapCmd(bitmapSetting, image: image))
            imageCMD?.append(imageCMD?.getPrintEnd(1))
            printer?.write(imageCMD?.getCmd())
        }
        
        let textCMD = ESCFactory.create()
        textCMD?.clear()
        textCMD?.encodingType = Encoding_GBK
        textCMD?.append(textCMD?.getHeaderCmd())
        
        let textst = self.printer?.textSets
        textst?.isUnderline = Set_DisEnable
        textst?.isTimes_Wide = Set_DisEnable
        textst?.isTimes_Heigh = Set_DisEnable
        textst?.isBold = Set_DisEnable
        
        let header = AppCommonMethods.fetchSiteSettingValue(key: "ticket_header", lowercased: false) ?? ""
        
        let type = AppCommonMethods.fetchSiteSettingValue(key: "ticket_header_type") ?? ""
        
        if type == "center"{
            textst?.alignmode = Align_Center
        }else if type == "right"{
            textst?.alignmode = Align_Right
        }else{
            textst?.alignmode = Align_Left
        }
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "\(header)\n"))
        
        textst?.alignmode = Align_Center
        textst?.isTimes_Wide = Set_Enabled
        textst?.isTimes_Heigh = Set_Enabled
        textst?.isBold = Set_Enabled
        
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "Voucher\n"))
        
        textst?.isBold = Set_DisEnable
        
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "\(voucher.voucherCode ?? "")\n"))
        
        textst?.isTimes_Wide = Set_DisEnable
        textst?.isTimes_Heigh = Set_DisEnable
        
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "------------------------------------------------\n"))
        
        textst?.isTimes_Wide = Set_Enabled
        textst?.isTimes_Heigh = Set_Enabled
        textst?.isBold = Set_Enabled
        
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: String.init(format: "%.2f %@\n", voucher.voucherAmount ?? 0, AppConstants.businessData?.country?.currencyCode ?? "")))
        
        
        textst?.isTimes_Wide = Set_DisEnable
        textst?.isTimes_Heigh = Set_DisEnable
        textst?.isBold = Set_DisEnable
        
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "------------------------------------------------\n\n"))
        
        textst?.isBold = Set_Enabled
        
        if voucher.minimumOrderValue ?? 0 > 0{
            textCMD?.append(textCMD?.getCmdWithPrint(textst, text: String.init(format: "Min Order Value: %.2f %@\n", voucher.minimumOrderValue ?? 0, AppConstants.businessData?.country?.currencyCode ?? "")))
            textst?.isBold = Set_DisEnable
            textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "------------------------------------------------\n"))
            textst?.isBold = Set_Enabled
        }
        
        textst?.alignmode = Align_Left
        
        let startDate = (voucher.startDate ?? "").getDateFromString(format: "yyyy-MM-dd HH:mm:ss") ?? Date()
        
        if voucher.customer?.name ?? "" != ""{
            textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "Customer Name: \(voucher.customer?.name ?? "")\n"))
        }
        
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "Start Date: \(startDate.getDateInString(format: "dd/MM/yyyy"))\n"))
        
        let endDate = (voucher.endDate ?? "").getDateFromString(format: "yyyy-MM-dd HH:mm:ss") ?? Date()
        
        if voucher.endDate ?? "" == "" || voucher.endDate ?? "" == "0000-00-00 00:00:00"{
            textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "No Expiry Date\n"))
        }else{
            textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "End Date: \(endDate.getDateInString(format: "dd/MM/yyyy"))\n"))
        }
        
        let arrWeekDay = (voucher.weekDay ?? "").components(separatedBy: ",")
        
        var strDays = "All day"
        if arrWeekDay.count > 0{
            strDays = ""
            for day in arrWeekDay{
                if !day.contains("0"){
                    strDays = "Sunday"
                }
                if !day.contains("1"){
                    if strDays == ""{
                        strDays = "Monday"
                    }else{
                        strDays = "\(strDays), Monday"
                    }
                }
                if !day.contains("2"){
                    if strDays == ""{
                        strDays = "Tuesday"
                    }else{
                        strDays = "\(strDays), Tuesday"
                    }
                }
                if !day.contains("3"){
                    if strDays == ""{
                        strDays = "Wednesday"
                    }else{
                        strDays = "\(strDays), Wednesday"
                    }
                }
                if !day.contains("4"){
                    if strDays == ""{
                        strDays = "Thursday"
                    }else{
                        strDays = "\(strDays), Thursday"
                    }
                }
                if !day.contains("5"){
                    if strDays == ""{
                        strDays = "Friday"
                    }else{
                        strDays = "\(strDays), Friday"
                    }
                }
                if !day.contains("6"){
                    if strDays == ""{
                        strDays = "Saturday"
                    }else{
                        strDays = "\(strDays), Saturday"
                    }
                }
            }
        }
        if strDays != ""{
            textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "Valid On: \(strDays)\n"))
        }
        
        var strTypes = "All"
        
        let arrTypesId = (voucher.orderTypeId ?? "").components(separatedBy: ",")
        if arrTypesId.count > 0{
            for model in AppConstants.arrOrderTypes{
                if !arrTypesId.contains("\(model.id ?? 0)"){
                    if strTypes == ""{
                        strTypes = model.type ?? ""
                    }else{
                        strTypes = "\(strTypes), \(model.type ?? "")"
                    }
                }
            }
        }
        if strTypes != ""{
            textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "Valid Order Type: \(strTypes)\n"))
        }
        
        textst?.isBold = Set_DisEnable
        
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "\n------------------------------------------------\n"))
        
        textst?.alignmode = Align_Center
        
        let footerA = AppCommonMethods.fetchSiteSettingValue(key: "footer_a", lowercased: false) ?? ""
        let footerB = AppCommonMethods.fetchSiteSettingValue(key: "footer_b", lowercased: false) ?? ""
        
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "\(footerA)\n"))
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "\(footerB)\n\n\n"))
        
        textCMD?.append(textCMD?.getLFCmd())
        textCMD?.append(textCMD?.getLFCmd())
        textCMD?.append(textCMD?.getLFCmd())
        textCMD?.append(textCMD?.getLFCmd())
        
        textCMD?.append(textCMD?.getCutPaperCmd(CutterMode_Full))
        
        printer?.write(textCMD?.getCmd())
        
        //        self.disconnectedToPrinter()
        self.printer?.close()
        self.printerObject = nil
        DispatchQueue.main.async {
            AppCommonMethods.stopProgressBar()
        }
    }
    
    func printTransactionReport(object:MerchantReportModel, image:UIImage?){
        if image != nil{
            let imageCMD = ESCFactory.create()
            imageCMD?.clear()
            imageCMD?.encodingType = Encoding_UTF8
            imageCMD?.append(imageCMD?.getHeaderCmd())
            let bitmapSetting = self.printer?.bitmapSetts
            bitmapSetting?.alignmode = Align_Center
            bitmapSetting?.limitWidth = 30*8
            imageCMD?.append(imageCMD?.getBitMapCmd(bitmapSetting, image: image))
            imageCMD?.append(imageCMD?.getPrintEnd(1))
            printer?.write(imageCMD?.getCmd())
        }
        
        let textCMD = ESCFactory.create()
        textCMD?.clear()
        textCMD?.encodingType = Encoding_GBK
        textCMD?.append(textCMD?.getHeaderCmd())
        
        let textst = self.printer?.textSets
        textst?.isUnderline = Set_DisEnable
        textst?.alignmode = Align_Center
        textst?.isBold = Set_Enabled
        textst?.isTimes_Wide = Set_DisEnable
        textst?.isTimes_Heigh = Set_DisEnable
        
        let footerA = AppCommonMethods.fetchSiteSettingValue(key: "footer_a", lowercased: false) ?? ""
        let footerB = AppCommonMethods.fetchSiteSettingValue(key: "footer_b", lowercased: false) ?? ""
        let header = AppCommonMethods.fetchSiteSettingValue(key: "ticket_header", lowercased: false) ?? ""
        
        let type = AppCommonMethods.fetchSiteSettingValue(key: "ticket_header_type") ?? ""
        
        if type == "center"{
            textst?.alignmode = Align_Center
        }else if type == "right"{
            textst?.alignmode = Align_Right
        }else{
            textst?.alignmode = Align_Left
        }
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "\(header)\n"))
        
        
        textst?.isTimes_Wide = Set_DisEnable
        textst?.isTimes_Heigh = Set_DisEnable
        textst?.isBold = Set_DisEnable
        textst?.alignmode = Align_Center
        
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "UBSIDI\n"))
        
        
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "------------------------------------------------\n"))
        
        textst?.isBold = Set_Enabled
        
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "Transaction Report\n\n"))
        
        
        if strHeaderDate != ""{
            textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "\(self.strHeaderDate)\n"))
        }
        
        textst?.alignmode = Align_Left
        textst?.isBold = Set_DisEnable
        
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "------------------------------------------------\n"))
        
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "Total Transaction             :\(object.totalTransaction)\n"))
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "Total Refund Amount           :\(String.init(format: "%.2f GBP", object.totalRefundAmount/100))\n"))
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "Total Refund Transactions     :\(object.totalRefundTransactions)\n"))
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "Total Successful Amount       :\(String.init(format: "%.2f GBP", object.totalSuccessfulAmount/100))\n"))
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "Total Successful Transactions :\(object.totalSuccessfulTransactions)\n"))
        
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "\n------------------------------------------------\n"))
        
        textst?.alignmode = Align_Center
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "\(footerA)\n"))
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "\(footerB)\n\n\n"))
        
        textCMD?.append(textCMD?.getLFCmd())
        textCMD?.append(textCMD?.getLFCmd())
        textCMD?.append(textCMD?.getLFCmd())
        textCMD?.append(textCMD?.getLFCmd())
        
        textCMD?.append(textCMD?.getCutPaperCmd(CutterMode_Full))
        
        self.printer?.write(textCMD?.getCmd())
        
        self.printer?.close()
        self.printerObject = nil
        DispatchQueue.main.async {
            AppCommonMethods.stopProgressBar()
        }
    }
    
    func printReservation(dictReservation:[String:[Any]],image:UIImage?){
        if image != nil{
            let imageCMD = ESCFactory.create()
            imageCMD?.clear()
            imageCMD?.encodingType = Encoding_UTF8
            imageCMD?.append(imageCMD?.getHeaderCmd())
            let bitmapSetting = self.printer?.bitmapSetts
            bitmapSetting?.alignmode = Align_Center
            bitmapSetting?.limitWidth = 30*8
            imageCMD?.append(imageCMD?.getBitMapCmd(bitmapSetting, image: image))
            imageCMD?.append(imageCMD?.getPrintEnd(1))
            printer?.write(imageCMD?.getCmd())
        }
        
        let textCMD = ESCFactory.create()
        textCMD?.clear()
        textCMD?.encodingType = Encoding_GBK
        textCMD?.append(textCMD?.getHeaderCmd())
        
        let textst = self.printer?.textSets
        textst?.isUnderline = Set_DisEnable
        textst?.isTimes_Wide = Set_DisEnable
        textst?.isTimes_Heigh = Set_DisEnable
        textst?.isBold = Set_DisEnable
        
        let header = AppCommonMethods.fetchSiteSettingValue(key: "ticket_header", lowercased: false) ?? ""
        
        let type = AppCommonMethods.fetchSiteSettingValue(key: "ticket_header_type") ?? ""
        
        if type == "center"{
            textst?.alignmode = Align_Center
        }else if type == "right"{
            textst?.alignmode = Align_Right
        }else{
            textst?.alignmode = Align_Left
        }
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "\(header)\n"))
        
        textst?.alignmode = Align_Center
        textst?.isTimes_Wide = Set_Enabled
        textst?.isTimes_Heigh = Set_Enabled
        textst?.isBold = Set_Enabled
        
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "Reservation List\n"))
        
        textst?.alignmode = Align_Left
        textst?.isBold = Set_DisEnable
        textst?.isTimes_Wide = Set_DisEnable
        textst?.isTimes_Heigh = Set_DisEnable
        
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "------------------------------------------------\n"))
        
        textst?.isTimes_Wide = Set_Enabled
        textst?.isTimes_Heigh = Set_Enabled
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "\(strHeaderDate)\n"))
        
        textst?.isTimes_Wide = Set_DisEnable
        textst?.isTimes_Heigh = Set_DisEnable
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "------------------------------------------------\n\n"))
        
        for day in arrReservationDay{
            
            textst?.isBold = Set_Enabled
            textst?.alignmode = Align_Center
            
            textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "\(day)\n"))
            
            textst?.alignmode = Align_Left
            textst?.isBold = Set_DisEnable
            
            for model in dictReservation[day]!{
                if let obj = model as? ReservationModel{
                    let strName = "Name: \(obj.customer?.name ?? "")"
                    let strNumber = "Number: \(obj.customer?.mobile ?? "")"
                    var strTable = "Table: \(obj.tableNumber ?? "")"
                    if obj.tableNumber ?? "" == ""{
                        strTable = "Table: -"
                    }
                    let strDiner = "Diner: \(obj.diners ?? 0)"
                    let strDate = (obj.reservationDateTime ?? "").changeDateFormat(fromFormat: "yyyy-MM-dd HH:mm:ss", toFormat: "dd/MM/yyyy") ?? ""
                    let strTime = (obj.reservationDateTime ?? "").components(separatedBy: " ").last ?? ""
                    
                    let arrName = strName.split(every: (32))
                    let arrNumber = strNumber.split(every: (32))
                    let arrTable = strTable.split(every: (32))
                    var strNewName = ""
                    var strNewNumber = ""
                    var strNewTable = ""
                    
                    for i in 0..<arrName.count{
                        if i == 0{
                            if arrName[i].count < 32{
                                var strSpace = ""
                                for _ in 0...(32-(arrName[i].count)){
                                    strSpace += " "
                                }
                                strNewName = "\(arrName[i])\(strSpace) \(strDate)\n"
                            }else{
                                strNewName = "\(arrName[i]) \(strDate)\n"
                            }
                        }else{
                            strNewName = "\(arrName[i])\n"
                        }
                    }
                    
                    for i in 0..<arrNumber.count{
                        if i == 0{
                            if arrNumber[i].count < 32{
                                var strSpace = ""
                                for _ in 0...(32-(arrNumber[i].count)){
                                    strSpace += " "
                                }
                                strNewNumber = "\(arrNumber[i])\(strSpace) \(strTime)\n"
                            }else{
                                strNewNumber = "\(arrNumber[i]) \(strTime)\n"
                            }
                        }else{
                            strNewNumber = "\(arrNumber[i])\n"
                        }
                    }
                    
                    for i in 0..<arrTable.count{
                        if i == 0{
                            if arrTable[i].count < 32{
                                var strSpace = ""
                                for _ in 0...(32-(arrTable[i].count)){
                                    strSpace += " "
                                }
                                strNewTable = "\(arrTable[i])\(strSpace) \(strDiner)\n"
                            }else{
                                strNewTable = "\(arrTable[i]) \(strDiner)\n"
                            }
                        }else{
                            strNewTable = "\(arrTable[i])\n"
                        }
                    }
                    
                    textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "\(strNewName)\n"))
                    textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "\(strNewNumber)\n"))
                    textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "\(strNewTable)\n"))
                    
                    if obj.specialInstruction ?? "" != ""{
                        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "Instuction: \(obj.specialInstruction ?? "")\n"))
                    }
                }else if let obj = model as? OnlineReservationModel{
                    let strName = "Name: \(obj.customerName ?? "")"
                    let strNumber = "Number: \(obj.bookingPhone ?? "")"
                    let strTable = "Table: -"
                    
                    let strDiner = "Diner: \(obj.guestCount ?? 0)"
                    let strDate = (obj.bookingDate ?? "").changeDateFormat(fromFormat: "yyyy-MM-dd", toFormat: "dd/MM/yyyy") ?? ""
                    let strTime = obj.bookingTime ?? ""
                    
                    let arrName = strName.split(every: (32))
                    let arrNumber = strNumber.split(every: (32))
                    let arrTable = strTable.split(every: (32))
                    var strNewName = ""
                    var strNewNumber = ""
                    var strNewTable = ""
                    
                    for i in 0..<arrName.count{
                        if i == 0{
                            if arrName[i].count < 32{
                                var strSpace = ""
                                for _ in 0...(32-(arrName[i].count)){
                                    strSpace += " "
                                }
                                strNewName = "\(arrName[i])\(strSpace) \(strDate)\n"
                            }else{
                                strNewName = "\(arrName[i]) \(strDate)\n"
                            }
                        }else{
                            strNewName = "\(arrName[i])\n"
                        }
                    }
                    
                    for i in 0..<arrNumber.count{
                        if i == 0{
                            if arrNumber[i].count < 32{
                                var strSpace = ""
                                for _ in 0...(32-(arrNumber[i].count)){
                                    strSpace += " "
                                }
                                strNewNumber = "\(arrNumber[i])\(strSpace) \(strTime)\n"
                            }else{
                                strNewNumber = "\(arrNumber[i]) \(strTime)\n"
                            }
                        }else{
                            strNewNumber = "\(arrNumber[i])\n"
                        }
                    }
                    
                    for i in 0..<arrTable.count{
                        if i == 0{
                            if arrTable[i].count < 32{
                                var strSpace = ""
                                for _ in 0...(32-(arrTable[i].count)){
                                    strSpace += " "
                                }
                                strNewTable = "\(arrTable[i])\(strSpace) \(strDiner)\n"
                            }else{
                                strNewTable = "\(arrTable[i]) \(strDiner)\n"
                            }
                        }else{
                            strNewTable = "\(arrTable[i])\n"
                        }
                    }
                    
                    textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "\(strNewName)\n"))
                    textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "\(strNewNumber)\n"))
                    textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "\(strNewTable)\n"))
                    
                    if obj.bookingInstruction ?? "" != ""{
                        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "Instuction: \(obj.bookingInstruction ?? "")\n"))
                    }
                }
            }
            
            textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "------------------------------------------------\n\n"))
        }
        
        textst?.alignmode = Align_Center
        
        let footerA = AppCommonMethods.fetchSiteSettingValue(key: "footer_a", lowercased: false) ?? ""
        let footerB = AppCommonMethods.fetchSiteSettingValue(key: "footer_b", lowercased: false) ?? ""
        
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "\(footerA)\n"))
        textCMD?.append(textCMD?.getCmdWithPrint(textst, text: "\(footerB)\n\n\n"))
        
        textCMD?.append(textCMD?.getLFCmd())
        textCMD?.append(textCMD?.getLFCmd())
        textCMD?.append(textCMD?.getLFCmd())
        textCMD?.append(textCMD?.getLFCmd())
        
        textCMD?.append(textCMD?.getCutPaperCmd(CutterMode_Full))
        
        printer?.write(textCMD?.getCmd())
        
        //        self.disconnectedToPrinter()
        self.printer?.close()
        self.printerObject = nil
        DispatchQueue.main.async {
            AppCommonMethods.stopProgressBar()
        }
    }
    
    func openCashDrawer(){
        let textCMD = ESCFactory.create()
        textCMD?.clear()
        textCMD?.encodingType = Encoding_GBK
        textCMD?.append(textCMD?.getHeaderCmd())
        
        textCMD?.append(textCMD?.getOpenDrawerCmd(0, startTime: 5, endTime: 0))
        
        printer?.write(textCMD?.getCmd())
        printer?.close()
        //        disconnectedToPrinter()
        shouldOpenDrawer = false
    }
    
    func getNameWithPrice(name: String, strPrice: String, count: String) -> String {
        let totalWidth     = 48
        let countWidth     = 8
        let priceWidth     = 10
        let nameWidth      = totalWidth - (countWidth + priceWidth)  // 30

        // 1) Trim name if too long, then pad on the right to left-align it
        let trimmedName = name.count > nameWidth
            ? String(name.prefix(nameWidth))
            : name
        let paddedName = trimmedName
            + String(repeating: " ", count: nameWidth - trimmedName.count)

        // 2) Pad count on the left to right-align it
        let cnt = String(count.prefix(countWidth))  // guard oversize
        let paddedCount = String(repeating: " ", count: countWidth - cnt.count)
            + cnt

        // 3) Pad price on the left to right-align it
        let prc = String(strPrice.prefix(priceWidth))
        let paddedPrice = String(repeating: " ", count: priceWidth - prc.count)
            + prc

        // 4) Combine
        return "\(paddedName)\(paddedCount)\(paddedPrice)\n"
    }

    func getItemName(price: Double?, name: String, qty: Int, isKitchenCopy: Bool, size: String) -> String {
        let formattedQty = qty > 9 ? "\(qty)" : " \(qty)"
        let strName = "\(formattedQty) \(name)"
        
        if isKitchenCopy {
            return getMultipleLineText(name: strName, size: size, isQuantity: true)
        } else if let price = price {
            return getMultipleLineText(name: strName, size: size, price: String(format: " %.2f", price), isQuantity: true)
        } else {
            return getMultipleLineText(name: strName, size: size, isQuantity: true)
        }
    }

    func getSubAddons(subAddons: String, size: String = "size0") -> String {
        let delimiters = CharacterSet(charactersIn: ",:")
        
        // 1) Split on any comma or colon
        let parts = subAddons.components(separatedBy: delimiters)
        
        // 2) Trim whitespace/newlines on each segment
        let trimmed = parts.map { $0.trimmingCharacters(in: .whitespacesAndNewlines) }
        
        // 3) Drop any empty segments (in case of consecutive delimiters)
        let nonEmpty = trimmed.filter { !$0.isEmpty }
        
        // 4) Re-join with newline
        let name = nonEmpty.joined(separator: "\n")
        return self.formattedLines(name: name, fontSize: size, isQuantity: true, isAddon: true)
    }

    func removeLastDigit(string: String, size: String) -> String {
        let charSet = CharacterSet(charactersIn: "1234567890. ")
        var newString = string
        
        while let lastChar = newString.last, "\(lastChar)".rangeOfCharacter(from: charSet) != nil {
            newString.removeLast()
        }
        
        return getMultipleLineText(name: newString, size: size)
    }

    func getPriceText(title: String, price: Double, size: String = "size0") -> String {
        let strPrice = String(format: "%.2f", price)
        let lineWidth = (size == "size0" || size.isEmpty) ? 48 : 24
        let formattedTitle = title.padding(toLength: lineWidth - strPrice.count - 1, withPad: " ", startingAt: 0)
        
        return "\(formattedTitle) \(strPrice)\n"
    }
    
    func formattedLines(name: String, fontSize: String = "", price: String = "", isQuantity: Bool = false, isAddon: Bool = false) -> String {
        // Determine line width: default 48, or 24 for smaller font
        let baseWidth = (fontSize == "size0" || fontSize.isEmpty) ? 48 : 24
        let indentSpaces = isAddon ? String(repeating: " ", count: 4) : ""
        
        // Clean currency sign and split manual segments
        let cleanName = name.replacingOccurrences(of: AppConstants.currencySign, with: "")
        let segments = cleanName.components(separatedBy: "\n")
        
        var allLines: [String] = []
        var isFirstLine = true
        var currentMaxWidth = baseWidth - (isAddon ? 4 : 0)
        let priceLength = price.count
        
        for segment in segments {
            let words = segment.split(separator: " ")
            var currentLine = ""
            
            for (index, word) in words.enumerated() {
                let candidate = currentLine.isEmpty ? String(word) : currentLine + " " + word
                let lineLimit = isFirstLine ? currentMaxWidth - priceLength : currentMaxWidth
                
                if candidate.count > lineLimit {
                    // commit and adjust if quantity
                    allLines.append(currentLine)
                    currentLine = String(word)
                    if isQuantity && isFirstLine {
                        currentMaxWidth -= 4
                    }
                    isFirstLine = false
                } else {
                    currentLine = candidate
                }
                
                // end of segment or last word
                if index == words.count - 1 {
                    allLines.append(currentLine)
                    isFirstLine = false
                }
            }
            
            // For embedded newline, treat as break: will prefix indent on next segment
        }
        
        // Build output string
        var result = ""
        for (i, line) in allLines.enumerated() {
            let prefix = indentSpaces
            if i == 0 {
                result += "\(prefix)\(line)\(price)\n"
            } else {
                result += "\(prefix)\(line)\n"
            }
        }
        return result
    }
    
    func getMultipleLineText(name: String, size: String, price: String = "", isQuantity: Bool = false, isAddon: Bool = false) -> String {
        var strName = name.replacingOccurrences(of: AppConstants.currencySign, with: "")
        var line = (size == "size0" || size == "") ? 48 : 24
        if isAddon{
            line -= 4
        }
        let strPrice = price
        
        let count = strName.count
        let offset = strPrice.count
        
        if count > line - offset{
            let arr = strName.components(separatedBy: " ")
            var arrString = [String]()
            var arrBuildString = [String]()
            for i in 0..<arr.count{
                let str = arr[i]
                arrString.append(str)
                let tempString = arrString.joined(separator: " ")
                if tempString.count > line-offset{
                    arrString.removeLast()
                    if arrBuildString.count == 0{
                        var string = arrString.joined(separator: " ")
                        while string.count < line - offset{
                            string += " "
                        }
                        if isAddon{
                            arrBuildString.append("    \(string)\(strPrice)")
                        }else{
                            arrBuildString.append("\(string)\(strPrice)")
                        }
                        if isQuantity{
                            line -= 4
                        }
                    }else{
                        var string = arrString.joined(separator: " ")
                        if isAddon{
                            string  = "    \(string)"
                        }
                        if isQuantity{
                            arrBuildString.append("    \(string)")
                        }else{
                            arrBuildString.append("\(string)")
                        }
                    }
                    arrString.removeAll()
                    arrString.append(str)
                }
                if i == (arr.count-1){
                    var string = arrString.joined(separator: " ")
                    if isAddon{
                        string  = "    \(string)"
                    }
                    if isQuantity{
                        arrBuildString.append("    \(string)\n")
                    }else{
                        arrBuildString.append("\(string)\n")
                    }
                }
            }
            strName = arrBuildString.joined(separator: "\n")
        }else{
            while strName.count < line - offset{
                strName += " "
            }
            if isAddon{
                strName = "    \(strName)\(strPrice)\n"
            }else{
                strName = "\(strName)\(strPrice)\n"
            }
        }
        return strName
    }
    
    func formatBlockName(_ name: String) -> String {
        let totalLength = 35
        let nameWithSpaces = " \(name) "
        let dashCount = totalLength - nameWithSpaces.count
        let leftDashes = dashCount / 2
        let rightDashes = dashCount - leftDashes

        let formatted = String(repeating: "-", count: leftDashes) +
                        nameWithSpaces +
                        String(repeating: "-", count: rightDashes)

        return "\n\(formatted)\n"
    }
}

extension Cmd {
    
    func addLinePrintCommand(_ textst: TextSetting, isForPrep:Bool = false){
        textst.isInverse = Set_DisEnable
        textst.isBold = Set_DisEnable
        textst.isUnderline = Set_DisEnable
        textst.isTimes_Wide = Set_DisEnable
        textst.isTimes_Heigh = Set_DisEnable
        textst.alignmode = Align_Center
        self.append(self.getCmdWithPrint(textst, text: isForPrep ? "---------------------------------\n" : "------------------------------------------------\n"))
    }
    
    func getCmdWithPrint(_ textSetting: TextSetting!, text: String!) -> Data {
//        if AppConstants.isInDevlopmentMode {
//            print(text ?? "")
//        }
        return self.getTextCmd(textSetting, text: text)
    }
    
    func addCmdWithPrint(_ textSetting: TextSetting!, text: String!, structure: PrintStructureDetailModel, showLine: Bool = true) {
        guard structure.visibility == 1 else { return }
        
        applyTextSettings(textSetting, alignment: structure.alignment, size: structure.size, style: structure.style)
        
        self.append(self.getCmdWithPrint(textSetting, text: text))
        
        if structure.separator && showLine {
            resetTextSettings(textSetting)
            self.append(self.getCmdWithPrint(textSetting, text: "------------------------------------------------\n"))
        }
    }
    
    func addCmdWithPrint(_ textSetting: TextSetting!, text: String!, alignment: String? = nil, size: String? = nil, style: String? = nil, visibility: Int? = nil) {
        if AppConstants.isInDevlopmentMode {
            print(text ?? "")
        }
        guard (visibility ?? 1) == 1 else { return }
        
        applyTextSettings(textSetting, alignment: alignment, size: size, style: style)
        
        self.append(self.getTextCmd(textSetting, text: text))
    }
    
    // MARK: - Helper Functions
    
    private func applyTextSettings(_ textSetting: TextSetting, alignment: String?, size: String?, style: String?) {
        textSetting.alignmode = getAlignment(alignment)
        textSetting.isTimes_Wide = (size == "size0" || size?.isEmpty == true) ? Set_DisEnable : Set_Enabled
        textSetting.isTimes_Heigh = textSetting.isTimes_Wide
        
        switch style {
        case "bold":
            textSetting.isBold = Set_Enabled
            textSetting.isUnderline = Set_DisEnable
            textSetting.isInverse = Set_DisEnable
        case "underline":
            textSetting.isBold = Set_DisEnable
            textSetting.isUnderline = Set_Enabled
            textSetting.isInverse = Set_DisEnable
        case "reverse":
            textSetting.isBold = Set_DisEnable
            textSetting.isInverse = Set_Enabled
            textSetting.isUnderline = Set_DisEnable
        default:
            textSetting.isInverse = Set_DisEnable
            textSetting.isBold = Set_DisEnable
            textSetting.isUnderline = Set_DisEnable
        }
    }
    
    func getAlignment(_ alignment: String?) -> Alignment {
        switch alignment {
        case "center": return Align_Center
        case "right": return Align_Right
        default: return Align_Left
        }
    }
    
    private func resetTextSettings(_ textSetting: TextSetting) {
        textSetting.isInverse = Set_DisEnable
        textSetting.isBold = Set_DisEnable
        textSetting.isUnderline = Set_DisEnable
        textSetting.isTimes_Wide = Set_DisEnable
        textSetting.isTimes_Heigh = Set_DisEnable
    }
}
