//
//  Extensions.swift
//  TiffinTom
//
//  Created by Tushar Premal on 10/07/20.
//  Copyright © 2020 Tushar Premal. All rights reserved.
//

import Foundation
import UIKit

extension UITextField{
    
    func setTextFieldAlert(message:String){
        self.attributedPlaceholder = NSAttributedString(string: message, attributes: [NSAttributedString.Key.foregroundColor : UIColor.red])
    }
}

extension Double{
    func getRoundFigure()->Double{
        return ceil(self*100)/100
    }
    
    func getFloorFigure()->Double{
        return floor(self*100)/100
    }
}

extension KeyedDecodingContainer{
    func getStringValue(key:CodingKey)->String?{
        if let value = try? self.decodeIfPresent(Bool.self, forKey: key as! K){
            return value ? "true" : "false"
        }else if let value = try? self.decodeIfPresent(String.self, forKey: key as! K){
            return value
        }else if let value = try? self.decodeIfPresent(Int.self, forKey: key as! K){
            return "\(value)"
        }else if let value = try? self.decodeIfPresent(Double.self, forKey: key as! K){
            return "\(value)"
        }
        return nil
    }
    
    func getBoolValue(key:CodingKey)->Bool{
        if let value = try? self.decodeIfPresent(Bool.self, forKey: key as! K){
            return value
        }else if let value = try? self.decodeIfPresent(Int.self, forKey: key as! K){
            return Int(value) == 1
        }else if let value = try? self.decodeIfPresent(Double.self, forKey: key as! K){
            return value == 1
        }else if let value = try? self.decodeIfPresent(String.self, forKey: key as! K){
            return Int(value) == 1
        }
        return false
    }
    
    func getIntValue(key:CodingKey)->Int?{
        if let value = try? self.decodeIfPresent(Int.self, forKey: key as! K){
            return value
        }else if let value = try? self.decodeIfPresent(String.self, forKey: key as! K){
            return Int(value)
        }else if let value = try? self.decodeIfPresent(Double.self, forKey: key as! K){
            return Int(value)
        }else if let value = try? self.decodeIfPresent(Bool.self, forKey: key as! K){
            return value ? 1 : 0
        }
        return nil
    }
    
    func getInt64Value(key:CodingKey)->Int64?{
        if let value = try? self.decodeIfPresent(Int64.self, forKey: key as! K){
            return value
        }else if let value = try? self.decodeIfPresent(String.self, forKey: key as! K){
            return Int64(value)
        }else if let value = try? self.decodeIfPresent(Double.self, forKey: key as! K){
            return Int64(value)
        }else if let value = try? self.decodeIfPresent(Bool.self, forKey: key as! K){
            return value ? 1 : 0
        }
        return nil
    }
    
    func getDoubleValue(key:CodingKey)->Double?{
        if let value = try? self.decodeIfPresent(Double.self, forKey: key as! K){
            return value
        }else if let value = try? self.decodeIfPresent(String.self, forKey: key as! K){
            return Double(value)
        }else if let value = try? self.decodeIfPresent(Int.self, forKey: key as! K){
            return Double(value)
        }
        return nil
    }
    
    
}

extension UIColor {
    class func hexStr ( hexStr : String, alpha : CGFloat = 1) -> UIColor {
        var cString:String = hexStr.trimmingCharacters(in: .whitespacesAndNewlines).uppercased()
        
        if (cString.hasPrefix("#")) {
            cString.remove(at: cString.startIndex)
        }
        
        if ((cString.count) != 6) {
            return UIColor.gray
        }
        
        var rgbValue:UInt64 = 0
        Scanner(string: cString).scanHexInt64(&rgbValue)
        
        return UIColor(
            red: CGFloat((rgbValue & 0xFF0000) >> 16) / 255.0,
            green: CGFloat((rgbValue & 0x00FF00) >> 8) / 255.0,
            blue: CGFloat(rgbValue & 0x0000FF) / 255.0,
            alpha: CGFloat(alpha)
        )
    }
}

extension UIViewController{
    
    var className: String {
        return NSStringFromClass(self.classForCoder).components(separatedBy: ".").last ?? ""
    }
    
    func removePopupview(){
        UIView.animate(withDuration: 0.2) {
            self.view.alpha = 0
        } completion: { status in
            self.view.removeFromSuperview()
            self.removeFromParent()
        }
    }
}

extension UIScrollView {
    var currentPage:Int{
        return Int((self.contentOffset.x+(0.5*self.frame.size.width))/self.frame.width)+1
    }
    
    func scrollTo(horizontalPage: Int? = 0, verticalPage: Int? = 0, animated: Bool? = true) {
        var frame: CGRect = self.frame
        frame.origin.x = frame.size.width * CGFloat(horizontalPage ?? 0)
        frame.origin.y = frame.size.width * CGFloat(verticalPage ?? 0)
        self.scrollRectToVisible(frame, animated: animated ?? true)
    }
}

extension UIApplication {
    class func topViewController(controller: UIViewController? = AppConstants.keywindow?.rootViewController) -> UIViewController? {
        if let presented = controller?.presentedViewController {
            return topViewController(controller: presented)
        }
        if let navigationController = controller as? UINavigationController {
            return topViewController(controller: navigationController.visibleViewController)
        }
        if let tabController = controller as? UITabBarController {
            if let selected = tabController.selectedViewController {
                return topViewController(controller: selected)
            }
        }
        return controller
    }
}

extension UIImageView {
    func setImageColor(color: UIColor) {
        let templateImage = self.image?.withRenderingMode(.alwaysTemplate)
        self.image = templateImage
        self.tintColor = color
    }
    
    func SetImageFromURL(strURL:String){
        let imageName = strURL.components(separatedBy: "/").last ?? ""
        let nsDocumentDirectory = FileManager.SearchPathDirectory.documentDirectory
        let nsUserDomainMask = FileManager.SearchPathDomainMask.userDomainMask
        let paths = NSSearchPathForDirectoriesInDomains(nsDocumentDirectory, nsUserDomainMask, true)
        
        self.image = UIImage.init(named: "placeholder")
        
        if let path = paths.first{
            let imageURL = URL(fileURLWithPath: path).appendingPathComponent("\(imageName)")
            if FileManager.default.fileExists(atPath: imageURL.path){
                if let image = UIImage(contentsOfFile: imageURL.path){
                    self.image = image
                    return
                }
            }
            if let url = URL(string: strURL) {
                let task = URLSession.shared.dataTask(with: url) { data, response, error in
                    DispatchQueue.main.async {
                        if let httpResponse = response as? HTTPURLResponse, httpResponse.statusCode == 200{
                            guard let imageData = data, error == nil else {
                                print(error?.localizedDescription ?? "")
                                return
                            }
                            self.image = UIImage(data: imageData)
                            do {
                                try imageData.write(to: imageURL)
                            } catch let error{
                                print("error saving file to documents:", error.localizedDescription)
                            }
                        }
                    }
                }
                task.resume()
            }
        }
    }
}


extension UIView{
    func applyShadowCardView(Corner radi: Int)
    {
        self.layer.cornerRadius = CGFloat(radi)
        self.layer.shadowColor = UIColor.gray.cgColor
        self.layer.shadowOpacity = 0.7
        self.layer.shadowRadius = 3.0
        self.layer.shadowOffset = CGSize(width: 1, height: 1)
    }
    
    class func fromNib<T: UIView>(name:String) -> T {
        return Bundle(for: T.self).loadNibNamed(name, owner: nil, options: nil)![0] as! T
    }
}

extension String{
    
    func getStringWidth(font:UIFont)->CGFloat{
        return NSString.init(string: self).size(withAttributes: [NSAttributedString.Key.font:font]).width
    }
    
    func htmlToAttributedString(font:UIFont)-> NSAttributedString? {
        guard let data = data(using: .utf8) else { return nil }
        do {
            let attributedString = try NSMutableAttributedString(data: data, options: [.documentType: NSAttributedString.DocumentType.html, .characterEncoding:String.Encoding.utf8.rawValue], documentAttributes: nil)
            let nsrange = NSRange(location: 0, length: attributedString.length)
            attributedString.addAttribute(
                .font,
                value: font,
                range: nsrange)
            return attributedString
        } catch {
            return nil
        }
    }
    
    func getFirstCharOfEachString()->String{
        let arr = self.components(separatedBy: " ")
        var string = ""
        arr.forEach { str in
            if let char = str.first{
                string += String(char)
            }
        }
        return string
    }
    
    var strikeThoughText:NSAttributedString{
        return NSAttributedString.init(string: self, attributes: [NSAttributedString.Key.strikethroughStyle: 2])
    }
    
    var removeSpace:String{
        return self.replacingOccurrences(of: " ", with: "").replacingOccurrences(of: "\n", with: "")
    }
    
    func underline(color:UIColor, font:UIFont)->NSAttributedString {
        let attributedString = NSMutableAttributedString(string: self)
        let range = NSRange(location: 0, length: attributedString.length)
        attributedString.addAttribute(NSAttributedString.Key.underlineStyle, value: NSUnderlineStyle.thick.rawValue, range: range)
        attributedString.addAttribute(NSAttributedString.Key.foregroundColor, value: color, range: range)
        attributedString.addAttribute(NSAttributedString.Key.font, value: font, range: range)
        return attributedString
    }
    
    func normal(color:UIColor, font:UIFont)->NSAttributedString {
        let attributedString = NSMutableAttributedString(string: self)
        let range = NSRange(location: 0, length: attributedString.length)
        attributedString.addAttribute(NSAttributedString.Key.foregroundColor, value: color, range: range)
        attributedString.addAttribute(NSAttributedString.Key.font, value: font, range: range)
        return attributedString
    }
    
    
    func changeDateFormat(fromFormat:String,toFormat:String)->String?{
        let dateFormat = DateFormatter.init()
        dateFormat.dateFormat = fromFormat
//        dateFormat.locale = Locale.init(identifier: "en_GB")
//        dateFormat.timeZone = TimeZone.init(secondsFromGMT: 0)
        if let date = dateFormat.date(from: self){
            dateFormat.dateFormat = toFormat
            return dateFormat.string(from: date)
        }
        return nil
    }
    
    func getDateFromString(format:String,locale:String? = nil)->Date?{
        let dateFormat = DateFormatter.init()
        dateFormat.dateFormat = format
//        dateFormat.timeZone = TimeZone.init(secondsFromGMT: 0)
//        dateFormat.locale = Locale.init(identifier: "en_GB")
        if locale != nil{
            dateFormat.locale = Locale.init(identifier: locale!)
        }
        return dateFormat.date(from: self)
    }
    
    func removeDateSuffix()->String{
        return self.replacingOccurrences(of: "st", with: "").replacingOccurrences(of: "nd", with: "").replacingOccurrences(of: "rd", with: "").replacingOccurrences(of: "th", with: "")
    }
    
    func getHeightFromString(font:UIFont, width:CGFloat)->CGFloat{
        let textAttributes = [NSAttributedString.Key.font: font]
        return ceil(self.boundingRect(with: CGSize.init(width: width, height: 2000), options: .usesLineFragmentOrigin, attributes: textAttributes, context: nil).height)
    }
    
    var length: Int {
        return count
    }
    
    subscript (i: Int) -> String {
        return self[i ..< i + 1]
    }
    
    func substring(fromIndex: Int) -> String {
        return self[min(fromIndex, length) ..< length]
    }
    
    func substring(toIndex: Int) -> String {
        return self[0 ..< max(0, toIndex)]
    }
    
    subscript (r: Range<Int>) -> String {
        let range = Range(uncheckedBounds: (lower: max(0, min(length, r.lowerBound)),
                                            upper: min(length, max(0, r.upperBound))))
        let start = index(startIndex, offsetBy: range.lowerBound)
        let end = index(start, offsetBy: range.upperBound - range.lowerBound)
        return String(self[start ..< end])
    }
    
    func split(every: Int, backwards: Bool = false) -> [String] {
        var result = [String]()
        
        for i in stride(from: 0, to: self.count, by: every) {
            switch backwards {
            case true:
                let endIndex = self.index(self.endIndex, offsetBy: -i)
                let startIndex = self.index(endIndex, offsetBy: -every, limitedBy: self.startIndex) ?? self.startIndex
                result.insert(String(self[startIndex..<endIndex]), at: 0)
            case false:
                let startIndex = self.index(self.startIndex, offsetBy: i)
                let endIndex = self.index(startIndex, offsetBy: every, limitedBy: self.endIndex) ?? self.endIndex
                result.append(String(self[startIndex..<endIndex]))
            }
        }
        
        return result
    }
    
    func generateQRCode() -> UIImage? {
        let data = self.data(using: String.Encoding.ascii)

        if let filter = CIFilter(name: "CIQRCodeGenerator") {
            filter.setValue(data, forKey: "inputMessage")
            let transform = CGAffineTransform(scaleX: 20, y: 20)

            if let output = filter.outputImage?.transformed(by: transform) {
                let context = CIContext()
                guard let cgImage = context.createCGImage(output, from: output.extent) else { return UIImage(ciImage: output) }
                return UIImage(cgImage: cgImage)
            }
        }
        return nil
    }
}

extension NSAttributedString{
    func height(containerWidth: CGFloat) -> CGFloat {
        
        let rect = self.boundingRect(with: CGSize.init(width: containerWidth, height: CGFloat.greatestFiniteMagnitude),
                                     options: [.usesLineFragmentOrigin, .usesFontLeading],
                                     context: nil)
        return ceil(rect.size.height)
    }
}

extension Calendar{
    static var currentCalendar:Calendar{
        var calender = Calendar.current
        calender.timeZone = TimeZone.current
        return calender
    }
}

extension Date{
    func getDateSuffix()->String{
        var suffix = "th"
        let day = Calendar.currentCalendar.component(.day, from: self)
        if day < 20 && day > 10{
            suffix = "th"
        }else{
            switch day % 10 {
            case 1:
                suffix = "st"
            case 2:
                suffix = "nd"
            case 3:
                suffix = "rd"
            default:
                suffix = "th"
            }
        }
        return suffix
    }
    
    func gatDateFormat()->String{
        var suffix = "th"
        let day = Calendar.currentCalendar.component(.day, from: self)
        if day < 20 && day > 10{
            suffix = "th"
        }else{
            switch day % 10 {
            case 1:
                suffix = "st"
            case 2:
                suffix = "nd"
            case 3:
                suffix = "rd"
            default:
                suffix = "th"
            }
        }
        return "dd'\(suffix)' MMM yyyy"
    }
    
    func gatDateFormatAndTime(isWithTime:Bool = false)->String{
        var suffix = "th"
        let day = Calendar.currentCalendar.component(.day, from: self)
        if day < 20 && day > 10{
            suffix = "th"
        }else{
            switch day % 10 {
            case 1:
                suffix = "st"
            case 2:
                suffix = "nd"
            case 3:
                suffix = "rd"
            default:
                suffix = "th"
            }
        }
        let format = isWithTime ? "dd'\(suffix)' MMM yyyy HH:mm:ss" : "dd'\(suffix)' MMM yyyy"
        return self.getDateInString(format: format)
    }
    
    func getDateInString(format:String,locale:String? = nil)->String{
        let dateFormat = DateFormatter.init()
        dateFormat.dateFormat = format
//        dateFormat.timeZone = TimeZone.init(secondsFromGMT: 0)
//        dateFormat.locale = Locale.init(identifier: "en_GB")
        if locale != nil{
            dateFormat.locale = Locale.init(identifier: locale!)
        }
        return dateFormat.string(from: self)
    }
    
    var millisecondsSince1970:Int {
        return Int((self.timeIntervalSinceReferenceDate * 1000.0).rounded())
    }
    
    var millisecondsInString:String {
        return Int((self.timeIntervalSinceReferenceDate * 1000.0).rounded()).description
    }
    
    init(milliseconds:Int) {
        self = Date(timeIntervalSinceReferenceDate: TimeInterval(milliseconds) / 1000)
    }
    
    func startOfMonth() -> Date {
        return Calendar.currentCalendar.date(from: Calendar.currentCalendar.dateComponents([.year, .month], from: Calendar.currentCalendar.startOfDay(for: self)))!
    }
    
    func endOfMonth() -> Date {
        var component = DateComponents(month: 1, day: -1)
        component.setTimeComponentsToNight()
        return Calendar.currentCalendar.date(byAdding: component, to: self.startOfMonth())!
    }
    
    enum Weekday: Int {
        case sunday = 1, monday, tuesday, wednesday, thursday, friday, saturday
    }
    
    func startOfDate() -> Date? {
        let cal = Calendar.currentCalendar
        var dateComponents = cal.dateComponents([.yearForWeekOfYear, .weekOfYear, .day, .month, .year, .hour, .minute, .second], from: self)
        dateComponents.setTimeComponentsToNoon()
        return cal.date(from: dateComponents)
    }
    
    func startOfYear() -> Date? {
        let cal = Calendar.currentCalendar
        var dateComponents = cal.dateComponents([.yearForWeekOfYear, .weekOfYear, .day, .month, .year, .hour, .minute, .second], from: self)
        dateComponents.setTimeComponentsToNoon()
        dateComponents.month = 1
        dateComponents.day = 1
        return cal.date(from: dateComponents)
    }
    
    func endOfYear() -> Date? {
        let cal = Calendar.currentCalendar
        var dateComponents = cal.dateComponents([.yearForWeekOfYear, .weekOfYear, .day, .month, .year, .hour, .minute, .second], from: self)
        dateComponents.setTimeComponentsToNight()
        dateComponents.month = 12
        dateComponents.day = 31
        return cal.date(from: dateComponents)
    }
    
    func endOfDate() -> Date? {
        let cal = Calendar.currentCalendar
        var dateComponents = cal.dateComponents([.yearForWeekOfYear, .weekOfYear, .day, .month, .year, .hour, .minute, .second], from: self)
        dateComponents.setTimeComponentsToNight()
        return cal.date(from: dateComponents)
    }
    
    func startOfWeek(_ firstWeekday: Weekday = .monday) -> Date? {
        var cal = Calendar.currentCalendar
        var dateComponents = cal.dateComponents([.yearForWeekOfYear, .weekOfYear], from: self)
        dateComponents.setTimeComponentsToNoon()
        cal.firstWeekday = firstWeekday.rawValue
        return cal.date(from: dateComponents)
    }
    
    func endOfWeek(_ firstWeekday: Weekday = .monday) -> Date? {
        guard let startOfWeek = startOfWeek(firstWeekday) else { return nil }
        var dateComponents = DateComponents()
        dateComponents.weekOfYear = 1
        dateComponents.day = -1
        dateComponents.setTimeComponentsToNight()
        return Calendar.currentCalendar.date(byAdding: dateComponents, to: startOfWeek)
    }
    
    static func dates(from fromDate: Date, to toDate: Date) -> [Date] {
        var dates: [Date] = []
        var date = fromDate
        
        while date <= toDate {
            dates.append(date)
            guard let newDate = Calendar.currentCalendar.date(byAdding: .day, value: 1, to: date) else { break }
            date = newDate
        }
        return dates
    }
    
    static func datesAtInterVal(fromDate: Date,toDate: Date, duration: Int)->[Date]{
        var dates: [Date] = []
        var date = fromDate
        
        while date <= toDate {
            dates.append(date)
            guard let newDate = Calendar.currentCalendar.date(byAdding: .day, value: duration, to: date) else { break }
            date = newDate
        }
        return dates
    }
}

extension DateComponents {
    mutating func setTimeComponentsToNoon() {
        self.hour = 0
        self.minute = 0
        self.second = 0
        self.nanosecond = 0
    }
    
    mutating func setTimeComponentsToNight() {
        self.hour = 23
        self.minute = 59
        self.second = 59
        self.nanosecond = 59
    }
}

extension NSDictionary{
    
    func percentEncoded() -> Data? {
        return map { key, value in
            let escapedKey = "\(key)".addingPercentEncoding(withAllowedCharacters: .urlQueryAllowed) ?? ""
            let escapedValue = "\(value)".addingPercentEncoding(withAllowedCharacters: .urlQueryAllowed) ?? ""
            return escapedKey + "=" + escapedValue
        }
        .joined(separator: "&")
        .data(using: .utf8)
    }
    
    func removeNullFromDict () -> NSMutableDictionary
    {
        let dict = NSMutableDictionary()
        for (key, value) in self {
            
            let val : NSObject = value as! NSObject;
            if val is NSNull
            {
                dict.setValue("", forKey: (key as? String)!)
            }
            else
            {
                dict.setValue(value, forKey: key as! String)
            }
        }
        
        return dict
    }
    
    func getIntValue(_ param:String) ->Int?{
        if let id = self[param] as? Int{
            return id
        }
        if let id = self[param] as? String{
            return Int(id)
        }
        return nil
    }
    
    func getIntFromPath(_ param:String)-> Int?{
        if let id = self.value(forKeyPath: param) as? Int{
            return id
        }
        if let id = self.value(forKeyPath: param) as? String{
            return Int(id)
        }
        return nil
    }
    
    func getStringFromPath(_ param:String)-> String?{
        if let id = self.value(forKeyPath: param) as? String{
            return id
        }
        if let id = self.value(forKeyPath: param) as? Int{
            return "\(id)"
        }
        if let id = self.value(forKeyPath: param) as? Double{
            return "\(id)"
        }
        return nil
    }
    
    func getDoubleFromPath(_ param:String)-> Double?{
        if let id = self.value(forKeyPath: param) as? Double{
            return id
        }
        if let id = self.value(forKeyPath: param) as? String{
            return Double(id)
        }
        return nil
    }
    
    func getDoubleValue(_ param:String) ->Double?{
        if let id = self[param] as? Double{
            return id
        }
        if let id = self[param] as? String{
            return Double(id)
        }
        return nil
    }
    
    func getFloatValue(_ param:String) ->Float?{
        if let id = self[param] as? Float{
            return id
        }
        if let id = self[param] as? Double{
            return Float(id)
        }
        if let id = self[param] as? String{
            return Float(id)
        }
        return nil
    }
    
    func getStringValue(_ param:String) ->String?{
        if let id = self[param] as? String{
            return id
        }
        if let id = self[param] as? Double{
            return "\(id)"
        }
        if let id = self[param] as? Int{
            return "\(id)"
        }
        return nil
    }
}

extension UITapGestureRecognizer {
    
    func didTapAttributedTextInLabel(label: UILabel, inRange targetRange: NSRange) -> Bool {
        // Create instances of NSLayoutManager, NSTextContainer and NSTextStorage
        let layoutManager = NSLayoutManager()
        let textContainer = NSTextContainer(size: CGSize.zero)
        let textStorage = NSTextStorage(attributedString: label.attributedText!)
        
        // Configure layoutManager and textStorage
        layoutManager.addTextContainer(textContainer)
        textStorage.addLayoutManager(layoutManager)
        
        // Configure textContainer
        textContainer.lineFragmentPadding = 0.0
        textContainer.lineBreakMode = label.lineBreakMode
        textContainer.maximumNumberOfLines = label.numberOfLines
        let labelSize = label.bounds.size
        textContainer.size = labelSize
        
        // Find the tapped character location and compare it to the specified range
        let locationOfTouchInLabel = self.location(in: label)
        let textBoundingBox = layoutManager.usedRect(for: textContainer)
        let textContainerOffset = CGPoint(x: (labelSize.width - textBoundingBox.size.width) * 0.5 - textBoundingBox.origin.x, y: (labelSize.height - textBoundingBox.size.height) * 0.5 - textBoundingBox.origin.y)
        
        let locationOfTouchInTextContainer = CGPoint(x: locationOfTouchInLabel.x - textContainerOffset.x, y: locationOfTouchInLabel.y - textContainerOffset.y)
        let indexOfCharacter = layoutManager.characterIndex(for: locationOfTouchInTextContainer, in: textContainer, fractionOfDistanceBetweenInsertionPoints: nil)
        return NSLocationInRange(indexOfCharacter, targetRange)
    }
    
}

extension UITableView {
    
    func reloadDataWithoutScroll() {
        let offset = contentOffset
        reloadData()
        layoutIfNeeded()
        setContentOffset(offset, animated: false)
    }
}

extension UICollectionView {
    
    func reloadDataWithoutScroll() {
        let offset = contentOffset
        reloadData()
        layoutIfNeeded()
        setContentOffset(offset, animated: false)
    }
}

public extension Notification.Name {
    
    static let changeTheme = Notification.Name("changeTheme")
}
