//
//  CustomCellView.swift
//  EPOS
//
//  Created by Apple on 26/04/21.
//

import Foundation
import UIKit

class OrderItemCollectionCell: UICollectionViewCell {
    
    @IBOutlet weak var lblQuantity:UILabel!
    @IBOutlet weak var lblName:UILabel!
    @IBOutlet weak var lblPrice:UILabel!
    @IBOutlet weak var lblDescription:UILabel!
    @IBOutlet weak var btnDelete:UIButton!
    @IBOutlet weak var btnMinus:UIButton!
    @IBOutlet weak var btnPlus:UIButton!
    @IBOutlet weak var btnViewMore:UIButton!
    @IBOutlet weak var lblMinus:UILabel!
    @IBOutlet weak var imgDelete:UIImageView!
    
    override class func awakeFromNib() {
        
    }
}

class GroupsListCell: UICollectionViewCell {
    
    @IBOutlet weak var btnGroup:UIButton!
    
    override class func awakeFromNib() {
        
    }
}

class ProductsCollectionCell: UICollectionViewCell {
    
    @IBOutlet weak var lblQuantity:UILabel!
    @IBOutlet weak var lblName:UILabel!
    @IBOutlet weak var lblPrice:UILabel!
    @IBOutlet weak var lblDescription:UILabel!
    @IBOutlet weak var btnAdd:UIButton!
    @IBOutlet weak var btnRemove:UIButton!
    @IBOutlet weak var btnMinus:UIButton!
    @IBOutlet weak var imgDelete:UIImageView!
    @IBOutlet weak var lblMinus:UILabel!
    @IBOutlet weak var lblPlus:UILabel!
    @IBOutlet weak var viewForBG:UIViewX!
    @IBOutlet weak var imgProduct:UIImageView!
    @IBOutlet weak var constMinusSpace:NSLayoutConstraint!
    @IBOutlet weak var constPlusSpace:NSLayoutConstraint!
    
    override class func awakeFromNib() {
        
    }
}

class ProductHeaderCollectionCell: UICollectionViewCell {
    
    @IBOutlet weak var lblTitle:UILabel!
    @IBOutlet weak var lblMaxQuantity:UILabel!
    @IBOutlet weak var imgExpand:UIImageView!
    @IBOutlet weak var imgSelect:UIImageView!
    @IBOutlet weak var viewForArchived:UIView!
    @IBOutlet weak var viewForSelctAll:UIViewX!
    @IBOutlet weak var btnSelect:UIButton!
    
    override class func awakeFromNib() {
        
    }
}

class ProductsCategoryCell: UICollectionViewCell {
    
    @IBOutlet weak var lblName:UILabel!
    @IBOutlet weak var NameTopSpace:NSLayoutConstraint!
    @IBOutlet weak var NameLeadingSpace:NSLayoutConstraint!
    @IBOutlet weak var lblLine:UILabel!
    @IBOutlet weak var viewForBG:UIViewX!
    
    override class func awakeFromNib() {
        
    }
}

class TablesViewCell: UICollectionViewCell {
    
    @IBOutlet weak var lblTitle:UILabel!
    @IBOutlet weak var lblTableNo:UILabel!
    @IBOutlet weak var lblTotalOrder:UILabel!
    @IBOutlet weak var lblTime:UILabel!
    @IBOutlet weak var btnFreeTable:UIButton!
    @IBOutlet weak var btnMarkServed:UIButton!
    @IBOutlet weak var viewForBG:UIViewX!
    @IBOutlet weak var imgStatus:UIImageViewX!
    var lastOrderTime:Int?
    var orderTimer:Timer?
    
    override class func awakeFromNib() {
        
    }
    
    func setTimer(){
        setOrderTimer()
        if lastOrderTime ?? 0 != 0{
            if orderTimer == nil{
                orderTimer = Timer.scheduledTimer(timeInterval: 1, target: self, selector: #selector(setOrderTimer), userInfo: nil, repeats: true)
            }
        }
    }
    
    @objc func setOrderTimer(){
        if lastOrderTime ?? 0 != 0{
            let timestamp = Int(Date().timeIntervalSince1970) - lastOrderTime!
            let hour = timestamp/(60*60)
            let minute = (timestamp - (hour*60*60))/60
            let second = timestamp - (hour*60*60) - (minute*60)
            lblTime.text = String.init(format: "%02d:%02d:%02d",hour,minute,second)
            lblTime.isHidden = false
        }else{
            if orderTimer != nil{
                orderTimer?.invalidate()
                orderTimer = nil
            }
            lblTime.isHidden = true
        }
    }
}

class AmountListCell: UICollectionViewCell {
    
    @IBOutlet weak var lblAmount:UILabel!
    @IBOutlet weak var viewForBG:UIView!
    
    override class func awakeFromNib() {
        
    }
}


class OrderViewCell: UICollectionViewCell{
    
    @IBOutlet weak var lblStatus:UILabel!
    @IBOutlet weak var lblMainStatus:UILabel!
    @IBOutlet weak var lblOrderType:UILabel!
    @IBOutlet weak var lblUserName:UILabel!
    @IBOutlet weak var lblPaid:UILabel!
    @IBOutlet weak var lblPostcode:UILabel!
    @IBOutlet weak var lblTime:UILabel!
    @IBOutlet weak var constOrderLeadingSpace:NSLayoutConstraint!
    @IBOutlet weak var viewForBG:UIView!
    @IBOutlet weak var imgStatus:UIImageViewX!
    @IBOutlet weak var btnView:UIButton!
    @IBOutlet weak var btnReadyToCollect:UIButton!
    @IBOutlet weak var btnCollected:UIButton!
    @IBOutlet weak var btnBack:UIButton!
    @IBOutlet weak var btnSelect:UIButton!
    @IBOutlet weak var constOrderTopSpace:NSLayoutConstraint!
    @IBOutlet weak var constOrderStatusHeight:NSLayoutConstraint!
    var timer:Timer?
    
    override class func awakeFromNib() {
        
    }
    
    func startTimer(createdDate:Date, theme:String) {
        if timer == nil{
            timer = Timer.scheduledTimer(withTimeInterval: 1.0, repeats: true) {_ in
                var difference = Int(Date().timeIntervalSince(createdDate))
                
                if difference < 0 { difference = 0 }
                
                let hours = difference / 3600
                let minutes = (difference % 3600) / 60
                
                self.lblTime?.superview?.isHidden = false
                if theme == "theme2"{
                    let seconds = difference % 60
                    self.lblTime?.text = String(format: "%02d:%02d:%02d", hours, minutes, seconds)
                }else{
                    self.lblTime?.text = String(format: "%02d:%02d", hours, minutes)
                }
            }
            var difference = Int(Date().timeIntervalSince(createdDate))
            
            if difference < 0 { difference = 0 }
            
            let hours = difference / 3600
            let minutes = (difference % 3600) / 60
            
            self.lblTime?.superview?.isHidden = false
            if AppCommonMethods.fetchSiteSettingValue(key: "home_theme") ?? "" == "theme2"{
                let seconds = difference % 60
                self.lblTime?.text = String(format: "%02d:%02d:%02d", hours, minutes, seconds)
            }else{
                self.lblTime?.text = String(format: "%02d:%02d", hours, minutes)
            }
        }
    }
}

class HeaderViewCell: UICollectionViewCell{
    
    @IBOutlet weak var lblTitle:UILabel!
    @IBOutlet weak var btnCollapse:UIButton!
    
    override class func awakeFromNib() {
        
    }
}

class TimseSlotViewCell: UICollectionViewCell {
    
    @IBOutlet weak var btnTimeSlot:UIButton!
    @IBOutlet weak var lblTimeSlot:UILabel!
    
    override func awakeFromNib() {
        
    }
}

class CancelReasonCell: UICollectionViewCell {
    
    
    @IBOutlet weak var lblReason:UILabel!
    
    override class func awakeFromNib() {
        
    }
    
}

class FloorViewCell: UICollectionViewCell {
    
    @IBOutlet weak var lblFloorName:UILabel!
    @IBOutlet weak var lblFloorLine:UILabel!
    
    override class func awakeFromNib() {
        
    }
    
}

class HomeViewCell:UICollectionViewCell{
    
    @IBOutlet weak var lblTitle:UILabel!
    @IBOutlet weak var lblDescription:UILabel!
    @IBOutlet weak var lblCount:UILabel!
    
    override class func awakeFromNib() {
        
    }
}

class SelectOrderCell: UICollectionViewCell {
    
    @IBOutlet weak var lblStoreName:UILabel!
    @IBOutlet weak var lblOrderDescription:UILabel!
    @IBOutlet weak var lblTotalPrice:UILabel!
    @IBOutlet weak var lblPaymentMEthod:UILabel!
    
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }
}
