//
//  AppConstants.swift
//  TiffinTomPartner
//
//  Created by Tushar Premal on 23/10/20.
//

import Foundation
import UIKit
import CoreLocation
import StripeTerminal

enum Environment{
    case live
    case stage
    case localhost
}

let environment:Environment = .live
var socketURL = ""

func setEnviromentData(){
    if environment == .live{
        AppConstants.APIURL.kBaseURL = "https://www.ubsidifinancial.com/V2/public/"
    }else{
        if environment == .stage{
            AppConstants.APIURL.kBaseURL = "https://www.ubsidifinancial.co.uk/V2/public/"
        }else{
            AppConstants.APIURL.kBaseURL = "http://192.168.1.26:8300/"
        }
    }
}


class AppConstants {
    
    static var isInDevlopmentMode = true
    
    static var isAdminLogin = false
    static var isSupervisorLogin = false
    
    static var orderCount = 0
    static var reservationCount = 0
    static var chatCount = 0
    static var recentlyChangedTableId:Int?
    static var selectedStripeReader:Reader?
    static var selectedReader:CardReaderModel?
    static let keyForAPI = "Kp+O[BZFh;31#&hvw.nj,Z!j0{h6!QFn"
    static let ivForAPI = "v@XI!kaW3BK,@8ki"
    
    static var keywindow:UIWindow?{
        return UIApplication.shared.windows.first { $0.isKeyWindow }
    }
    
    static var currencySign:String{
        return businessData?.country?.currencySymbol ?? "£"
    }
    
    static var webResId:String?{
        return AppCommonMethods.fetchSiteSettingValue(key: "res_id")
    }
    
    static var deviceApproves:Bool{
        return ((AppCommonMethods.readObjfromUserDefault(withKey: userDefaultKey.kDeviceApproved) as? Int) ?? 0) == 1
    }
    
    static var appDelegate = UIApplication.shared.delegate as! AppDelegate
    
    static var arrOrderTypes = [OrderTypesModel]()
    
    static var arrOrderStatuses = [OrderStatusModel]()
    
    static var arrPaymentMethods = SQLiteManage.fetchPatmentMethods()
    
    static var arrDepositType = [DepositTypeModel]()
    
    static var DeviceId:Int{
        if let id = AppCommonMethods.readObjfromUserDefault(withKey: userDefaultKey.kDeviceId) as? Int{
            return id
        }
        return 0
    }
    
    static var FCMToken:String?{
        return AppCommonMethods.readObjfromUserDefault(withKey: userDefaultKey.kFCMToken) as? String
    }
    
    static var remoteDevice:String{
        return (AppCommonMethods.readObjfromUserDefault(withKey: userDefaultKey.kRemoteDevice) as? String) ?? "No"
    }
    
    static var DataSyncMode:String{
        return (AppCommonMethods.readObjfromUserDefault(withKey: userDefaultKey.kDataSyncMode) as? String) ?? "Manual"
    }
    
    static var siteSettings:[SiteSettingsModel]?{
        if let savedData = AppCommonMethods.readObjfromUserDefault(withKey: userDefaultKey.kSiteSettings) as? Data {
            let decoder = JSONDecoder()
            return try? decoder.decode([SiteSettingsModel].self, from: savedData)
        }
        return nil
    }
    
    static var printSettings:[PrintSettingsModel]?{
        if let savedData = AppCommonMethods.readObjfromUserDefault(withKey: userDefaultKey.kPrintSettings) as? [NSDictionary], let data = AppCommonMethods.convertToJson(object: savedData){
            let decoder = JSONDecoder()
            return try? decoder.decode([PrintSettingsModel].self, from: data)
        }
        return nil
    }
    
    static var arrUserList:[UserModel]?{
        if let savedData = AppCommonMethods.readObjfromUserDefault(withKey: userDefaultKey.kUserList) as? Data {
            let decoder = JSONDecoder()
            return try? decoder.decode([UserModel].self, from: savedData)
        }
        return nil
    }
    
    static var autoDiscount:[OrderDiscountModel]?{
        if let savedData = AppCommonMethods.readObjfromUserDefault(withKey: userDefaultKey.kAutoDiscount) as? Data {
            let decoder = JSONDecoder()
            return try? decoder.decode([OrderDiscountModel].self, from: savedData)
        }
        return nil
    }
    
    static var adminData:AdminModel?{
        if let savedData = AppCommonMethods.readObjfromUserDefault(withKey: userDefaultKey.kAdminUserData) as? Data {
            let decoder = JSONDecoder()
            return try? decoder.decode(AdminModel.self, from: savedData)
        }
        return nil
    }
    
    static var businessData:BusinessModel?{
        if let savedData = AppCommonMethods.readObjfromUserDefault(withKey: userDefaultKey.kBusinessData) as? Data {
            let decoder = JSONDecoder()
            return try? decoder.decode(BusinessModel.self, from: savedData)
        }
        return nil
    }
    
    static var userData:UserModel?{
        if let savedData = AppCommonMethods.readObjfromUserDefault(withKey: userDefaultKey.kUserData) as? Data {
            let decoder = JSONDecoder()
            return try? decoder.decode(UserModel.self, from: savedData)
        }
        return nil
    }
    
    static var selectedPrinter: PrinterModel? {
        if let savedData = AppCommonMethods.readObjfromUserDefault(withKey: userDefaultKey.kSelectedPrinter) as? Data {
            let decoder = JSONDecoder()
            return try? decoder.decode(PrinterModel.self, from: savedData)
        }
        return nil
    }
    
    static var restaurantData:RestaurantDetailModel?{
        if let savedData = AppCommonMethods.readObjfromUserDefault(withKey: userDefaultKey.kRestaurantData) as? Data {
            let decoder = JSONDecoder()
            return try? decoder.decode(RestaurantDetailModel.self, from: savedData)
        }
        return nil
    }
    
    static var cardBrands: [CardBrandModel]? {
        let decoder = JSONDecoder()
        if let savedData = UserDefaults.standard.value(forKey: userDefaultKey.kCardBrand) as? Data, let loadedData = try? decoder.decode([CardBrandModel].self, from: savedData){
            return loadedData
        }else {
            return nil
        }
    }
    
    static var cardBrandComissions: [CardBrandComissionModel]? {
        let decoder = JSONDecoder()
        if let savedData = UserDefaults.standard.value(forKey: userDefaultKey.kCardBrandComission) as? Data, let loadedData = try? decoder.decode([CardBrandComissionModel].self, from: savedData){
            return loadedData
        }else {
            return nil
        }
    }
    
    static var countryComissions: [CountryComissionModel]? {
        let decoder = JSONDecoder()
        if let savedData = UserDefaults.standard.value(forKey: userDefaultKey.kCountryComission) as? Data, let loadedData = try? decoder.decode([CountryComissionModel].self, from: savedData){
            return loadedData
        }else {
            return nil
        }
    }
    
    static var restaurantSiteSettings:RestaurantSiteSettingsModel?{
        if let savedData = AppCommonMethods.readObjfromUserDefault(withKey: userDefaultKey.kRestaurantSiteSettings) as? Data {
            let decoder = JSONDecoder()
            return try? decoder.decode(RestaurantSiteSettingsModel.self, from: savedData)
        }
        return nil
    }
    
    struct Common {
        static let kAppStoreId = "1574017140"
        static let kAppiTunesURL = "https://apps.apple.com/in/app/tiffintom/id\(kAppStoreId)"
    }
    
    struct APIURL{
//        static let kBaseURL = "http://192.168.1.47:8300/" //Localhost
//        static var kBaseURL = "https://www.ubsidifinancial.co.uk/V2/public/" //Stage
        static var kBaseURL = "https://www.ubsidifinancial.com/V2/public/" //Live
        
        static let kOnlineOrder = kBaseURL+"tiffintom/orders/"
        static let kOnlineAllOrder = kOnlineOrder+"all-orders"
        static let kOnlineDineinOrder = kBaseURL+"tiffintom/dinein-orders/"
        static let kOnlineReservation = kBaseURL+"tiffintom/bookings/"
        static let kBulkDelete = kOnlineReservation+"bulk-delete"
        static let kOrderHelp = kBaseURL+"tiffintom/order-help/"
        static let kChat = kBaseURL+"tiffintom/chat/"
        static let kRestaurant = kBaseURL+"tiffintom/restaurants/"
        static let kRestaurantOffer = kBaseURL+"tiffintom/offers/"
        static let kRestaurantVoucher = kBaseURL+"tiffintom/restaurant-vouchers/"
        static let kAppFeedback = kBaseURL+"tiffintom/app-feedback"
        static let kPaymentMessage = kBaseURL+"tiffintom/payment-message/"
        static let kOnlineCategories = kBaseURL+"tiffintom/categories/"
        static let kTiffinTomMenus = kBaseURL+"tiffintom/menu/"
        static let kTiffinTomAddons = kBaseURL+"tiffintom/addons/"
        
        static let kAdminLogin = kBaseURL+"epos/login"
        static let kUser = kBaseURL+"epos/users/"
        static let kLogin = kBaseURL+"epos/users/login"
        static let kLogout = kBaseURL+"epos/users/logout"
        static let kUserProfile = kBaseURL+"epos/users/me"
        static let kUserList = kBaseURL+"epos/users/mini"
        static let kFloorList = kBaseURL+"epos/floors"
        static let kTableStatus = kBaseURL+"epos/table-statuses"
        static let kCategoryList = kBaseURL+"epos/categories"
        static let kCustomer = kBaseURL+"epos/customers/"
        static let kSearchPostCode = kBaseURL+"api/postcodes/find/"
        static let kAddDevice = kBaseURL+"epos/devices/"
        static let kValidateDevice = kBaseURL+"epos/devices/validate/"
        static let kProductList = kBaseURL+"epos/products/"
        static let kAddOnsList = kBaseURL+"epos/product-addons/"
        static let kIngredientsList = kBaseURL+"epos/product-ingredients/"
        static let kDeliveryCharge = kBaseURL+"epos/delivery-charges/calculate"
        static let kPrepLocationList = kBaseURL+"epos/preparation-locations/"
        static let kCreateOrder = kBaseURL+"epos/orders"
        static let kOrderTypes = kBaseURL+"epos/order-types"
        static let kOrderStatuses = kBaseURL+"epos/order-statuses"
        static let kVoucher = kBaseURL+"epos/vouchers/"
        static let kFindVoucher = kVoucher+"find/"
        static let kOrderPayment = kBaseURL+"epos/order-payments"
        static let kPaymentMethod = kBaseURL+"epos/payment-methods"
        static let kLoyaltyPoints = kBaseURL+"epos/loyalty-points"
        static let kOrderItems = kBaseURL+"epos/order-items"
        static let kOrderSplits = kBaseURL+"epos/order-splits"
        static let kOrderBulkSplits = kBaseURL+"epos/order-splits/split-bulk"
        static let kSiteSettings = kBaseURL+"epos/site-settings"
        static let kTables = kBaseURL+"epos/tables/"
        static let kSwapTable = kBaseURL+"epos/orders/swap-table"
        static let kPullData = kBaseURL+"epos/database/pull"
        static let kBulkOrderPayment = kBaseURL+"epos/order-payments/payment-bulk"
        static let kDeposits = kBaseURL+"epos/deposit-types"
        static let kAutoDiscount = kBaseURL+"epos/discounts"
        static let kReservations = kBaseURL+"epos/reservations"
        static let kBusinesses = kBaseURL+"epos/businesses"
        static let kFullReport = kBaseURL+"epos/reports"
        static let kFullReportBeta = kFullReport+"/full-report"
        static let kSendReport = kFullReport+"/send-mail-full-report"
        static let kProductWiseReport = kFullReport+"/products-wise"
        static let kCategoryWiseReport = kFullReport+"/products-category-wise"
        static let kOnlineOrderReport = kFullReport+"/online-order"
        static let kMerchantBusiness = kBaseURL+"epos/merchant/businesses/"
        static let kDeletAllOrder = kBaseURL+"epos/orders/delete-all"
        static let kDeleteAllReservation = kBaseURL+"epos/reservations/delete-all"
        static let kCallLogDelete = kBaseURL+"epos/call-logs/delete-all"
        static let kCashDrawerLogDelete = kBaseURL+"epos/cashdraw-logs/delete-all"
        static let kFactoryReset = kBaseURL+"epos/factory-reset"
        static let kArchiveOrders = kBaseURL+"epos/orders/bulk-archive"
        static let kUnrchiveOrders = kBaseURL+"epos/orders/bulk-unarchive"
        static let kPrinters = kBaseURL+"epos/printers"
        static let kPrintSettings = kBaseURL+"epos/print-settings"
        static let kEPOSIngrident = kBaseURL + "epos/ingredients/"
        static let kEPOSAddons = kBaseURL + "epos/addons/"
        static let kOrderRefund = kBaseURL + "epos/orders/refund"
        static let kOrderLogs = kBaseURL + "epos/order-logs"
        
        static let kPaymentIntentAPI = kBaseURL + "api/pg/payment-intent"
        static let kCalculteAppFeeAPI = kBaseURL + "api/pg/calculate-application-fee"
        static let kConnectionTokenAPI = kBaseURL + "api/pg/card-reader-connection-token"
        static let kCaptureIntentAPI = kBaseURL + "api/pg/payment-intent-capture"
        static let kCardBrand = kBaseURL + "api/card-brands"
        static let kAPIBusinesses = kBaseURL + "api/businesses"
        static let kZReport = kFullReport + "/z-report"
        
        static let kStripeBASEURL = "https://api.stripe.com/v1/"
        static let kConfirmIntentAPI = kStripeBASEURL + "payment_intents"
        static let kStripeChargeAPI = kStripeBASEURL + "charges"
        
        static let kAllSiteSettings = kBaseURL + "tiffintom/site-settings/1/all"
    }
    
    struct GlobalAlert{
        // Alert Title
        static let ALERT_TITLE = "UBSIDI"
        
        // Alert Button Titles
        static let ALERT_BTN_OK = "Ok"
        static let ALERT_BTN_NO = "NO"
        static let ALERT_BTN_YES = "YES"
        static let ALERT_BTN_LOGOUT = "LOGOUT"
        static let ALERT_BTN_CANCEL = "CANCEL"
        static let ALERT_BTN_SETTING = "Settings"
        
        static let ALERT_NO_ORDERTYPE = "No order type found"
        static let ALERT_ENTER_NAME = "Please enter name"
        static let ALERT_ENTER_DINERS = "Please enter diners"
        static let ALERT_ZERO_DINERS = "Diners can not be zero"
        static let ALERT_ENTER_EMAILID = "Please enter email address"
        static let ALERT_ENTER_VALID_EMAIL = "Please enter valid email address"
        static let ALERT_ENTER_USERNAME = "Please enter username"
        static let ALERT_ENTER_PASSWORD = "Please enter password"
        static let ALERT_INVALID_PASSWORD = "Invalid password"
        static let ALERT_ENTER_MOBILENO = "Please enter mobile number"
        static let ALERT_MOBILE_10_DIGIT = "Mobile number must be in 10 or 11 digits"
        static let ALERT_ENTER_HOUSENO = "Please enter house number"
        static let ALERT_ENTER_STATE = "Please enter state"
        static let ALERT_ENTER_PRICE = "Please enter price"
        static let ALERT_ENTER_VOUCHER = "Please enter voucher code"
        static let ALERT_ENTER_INSTPRICE = "Please enter special instruction price"
        static let ALERT_ENTER_SPECIALINST = "Please enter special instruction"
        static let ALERT_ZERO_PRICE = "Price can not be zero"
        static let ALERT_ZERO_AMOUNT = "Amount can not be zero"
        static let ALERT_MOTO_AMOUNT = "Amount can not be less than 1"
        static let ALERT_ZERO_CASH = "Cash amount can not be zero"
        static let ALERT_ZERO_CARD = "Card amount can not be zero"
        static let ALERT_ORDER_PAID = "Order is already paid"
        static let ALERT_AMOUNT_LESS_ORDER = "Amount can not be exceed from total order amount"
        static let ALERT_AMOUNT_LESS_CREDIT = "Amount can not be exceed from total available credit"
        static let ALERT_ZERO_CHEQUE = "Cheque amount can not be zero"
        static let ALERT_ENTER_CHEQUENUMBER = "Please enter cheque number"
        static let ALERT_SELECT_BUSINESS = "Please select business"
        static let ALERT_SELECT_CUSTOMER = "Please select customer"
        static let ALERT_ENTER_POSTCODE = "Please enter postcode"
        static let ALERT_SEARCH_POSTCODE = "Please search postcode"
        static let ALERT_ENTER_DEVICENAME = "Please enter device name"
        static let ALERT_SELECT_PREPLOCATION = "Please select prep location"
        static let ALERT_ENTER_NOOFGUEST = "Please enter number of guest"
        static let ALERT_ZERO_NOOFGUEST = "Number of guest can not be zero"
        static let ALERT_APPLY_VOUCHER = "Please enter voucher code and apply"
        static let ALERT_EMPTY_CARDNO = "Please enter card number"
        static let ALERT_EMPTY_CARDNAME = "Please enter card holder name"
        static let ALERT_VALID_CARDNO = "Please enter valid card number"
        static let ALERT_EMPTY_CVV = "Please enter CVV"
        static let ALERT_VALID_CVV = "Please enter valid CVV"
        static let ALERT_EMPTY_EXPIRYDATE = "Please enter expiry date"
        static let ALERT_VALID_EXPIRYDATE = "Please enter valid expiry date"
        static let ALERT_INVALID_CARD = "Your card has declined, please use another card or try again"
        static let ALERT_NO_CARDREADER = "Sorry!! No Card Readers found"
        static let ALERT_SELECT_CARDREADER = "Please select card reader"
        static let ALERT_SELECT_PRINTER = "Please select printer"
        static let FailedChat = "Message failed to send, do you want to resend message?"
        static let ALERT_ALLOW_AUDIO = "Please allow microphone from settings to record audio"
        static let FailedCall = "Failed to call customer, Please try again"
        static let FailedSendMessage = "Failed to send message to customer, Please try again"
        static let ALERT_EMPTY_REST_DESC = "Please enter restaurant description"
        static let ALERT_EMPTY_FEEDBACK = "Please enter description of your problem"
        static let ALERT_SUCCESS_FEEDBACK = "Feedback submitted successfully"
        static let ALERT_EMPTY_SUBJECT = "Please enter a subject"
        static let ALERT_VOUCHER_TYPE = "Please select discount code type"
        static let ALERT_ENTER_CODE = "Please enter discount code"
        static let ALERT_ENTER_MULTIPLE = "Please enter number of times voucher code is valid"
        static let ALERT_MULTIPLE_ZERO = "Number of times voucher code validity can not be 0"
        static let ALERT_ENTER_OFFERVALUE = "Please enter voucher code value"
        static let ALERT_OFFERVALUE_ZERO = "Voucher code value can not be 0"
        static let ALERT_ENTER_OFFERMINVALUE = "Please enter voucher code minimum value"
        static let ALERT_OFFERMINVALUE_ZERO = "Voucher code minimum value can not be 0"
        static let ALERT_SELECT_DEVICETYPE = "Please select type of device"
        static let deliveryFeeNotZero = "Delivery fee can not be 0"
        static let deliveryDistanceNotZero = "Distance can not be 0"
        static let ALERT_SELECT_TOTIME = "Please select to time"
        static let ALERT_SELECT_FROMTIME = "Please select from time"
        static let ALERT_TO_GREATER_FROM_DATE = "To date must be greater or queal to from date"
        static let DINEIN_UPDATED = "Dine in options updated"
        static let spentAmountNotZero = "Spend amount can not be 0"
        static let offerAmountNotZero = "Offer percentage can not be 0"
        static let ALERT_OFFER_TYPE = "Please select offer type"
        static let DELIVERY_FEE_DISTANCE = "You have already added delivery fee for purticular distance"
        static let ALERT_TO_GREATER_FROM_TIME = "To time must be greater or queal to from time"
        static let kSelectOneOrder = "Please select atleast one order to archive"
        static let ALERT_REFUND_GREATER = "Sorry!! refund amount can not be greater than charge amount"
        static let ALERT_PAYMENT_FAILED = "Payment failed, Please try again!"
        
        static let FailedTiffinTomCall = "Failed to call TiffinTom support, Please try again"
        static let FailedEmail = "Failed to configure email, Please try again"
        static let kServerErrorMsg = "Sorry! Something went wrong. Please try again later"
        static let kNoInternetMsg = "Please check your internet connection"
        
        static let kUserLogout = "Do you wish to logout from user?"
        static let kAdminLogout = "Do you wish to logout from business?"
        static let kInvalidLogin = "Invalid login credential"
        
        static let kFullPaymentDone = "You have done full payment for current order"
        static let kAddProduct = "Please add atleast one product"
        static let kSelectLocation = "Please select prep location"
        static let kEnterProductName = "Please enter product name"
        static let kSplitPersonCount = "Split person must be greater than 1"
        static let kAddWillPay = "Please add some item for pay"
        static let kAddComment = "Please enter comment"
        static let kOneOrderItemDelete = "All Order item can not deleted"
        static let kItemOrderSplit = "Order has been already splited by item"
        static let kPersonOrderSplit = "Order has been already splited by person"
        static let kSelectGroup = "Please select group to preceed with the payment"
        static let kSelectTable = "Please select table"
        static let kSelectReservationDate = "Please select reservation date"
        static let kSelectReservationTime = "Please select reservation time"
        static let kReservationTimeGreaterToday = "Reservation date and time must be greater than current time"
        static let kSelectDepositType = "Please select deposit type"
        static let kVoucherFromDate = "Please select voucher from date"
        static let kVoucherToDate = "Please select voucher to date"
        
        static let noLocation = "In order get your current location, please allow the app to use your location by turning it on in the settings page"
        static let instructionAdded = "Instructions have been added"
        static let instructionRemoved = "Instructions have been removed"
        
        static let RESERVATION_ACCEPETD = "Reservation has been accepted"
        static let RESERVATION_REJECTED = "Reservation has been rejected"
        static let ORDER_REJECTED = "Order has been rejected"
        static let ORDER_ACCPETED = "Order has been accepted"
        static let ORDER_DELAYED = "Order has been delayed"
        static let ORDER_COMPLETED = "Order completed"
        static let ALERT_KITCHEN_COPY = "Do you want to print kitchen copy?"
        static let ALERT_ORDER_BILL = "Do you want to print order bill?"
        static let ALERT_CUSTOMER_COPY = "Do you want to print a customer copy?"
        static let ALERT_REMINDER_GREATER_DATE = "reminder time must be greater than current time"
        static let ALERT_SELECT_REMINDERTIME = "Please select reminder time"
        static let ALERT_SELECT_TIMESLOT = "Please select timeslot"
        static let ALERT_TIMESLOT_GREATER_DATE = "selected timeslot must be greater than current time"
        static let ALERT_EMPTY_CANCELREASON = "Please enter reason for cancellation"
        static let ALERT_SELECT_CANCELREASON = "Please select reason for cancellation"
        
        static let ALERT_LOGOUT_ADMIN = "Do you wish to logout from supervisor?"
        static let ALERT_LOGOUT_SUPERVISOR = "Do you wish to logout from admin?"
        
        static let ALERT_MARK_ORDER_RTC = "Do you wish to mark order as ready to collect?"
        static let ALERT_MARK_ORDER_OTW = "Do you wish to mark order as on the way?"
        static let ALERT_MARK_ORDER_DELIVERED = "Do you wish to mark this order as delivered?"
        static let ALERT_MARK_ORDER_COLLECTED = "Do you wish to mark this order as collected?"
        static let ALERT_MARK_ORDER_RTS = "Do you wish to mark this order as ready to serve?"
        static let ALERT_MARK_ORDER_SERVED = "Are you sure want to mark order as served?"
        static let ALERT_MARK_ALLORDER_SERVED = "Do you wish to mark all orders as served?"
        static let ALERT_CANCEL_ORDER = "Do you wish to cancel order?"
        static let ALERT_DELETE_ORDER = "Do you wish to delete order?"
        static let ALERT_ENTER_PASSWORD_OFF_RESERVATION = "Please enter your password to turn off online reservation"
        static let ALERT_ENTER_PASSWORD_OFF_ORDER = "Please enter your password to turn off online orders"
        static let ALERT_ENTER_ADMIN_PASSWORD = "Please enter admin/supervisor password"
        
        static let ALERT_ENTER_AMOUNT = "Please enter amount"
        static let ALERT_ENTER_PASSOWRD_REFUND_TRANSACTION = "Please enter passowrd to refund transaction"
        static let ALERT_ENTER_PASSOWRD_ACCESS_PAGE = "Please enter passowrd to access this page"
        static let ALERT_ENTER_REFUNDAMOUNT = "Please enter amount you want to refund"
        static let ALERT_ENTER_PASSWORD_REPORTSETTING = "Please enter your password to access the report settings"
        static let ALERT_TRANSACTION_ARCHIVE = "Do you wish to archive transactions"
        static let ALERT_TRANSACTION_UNARCHIVE = "Do you wish to unarchive transactions"
        static let ALERT_CONFIRM_RESERVATION = "Do you wish to confirm this reservation?"
        static let ALERT_CANCEL_RESERVATION = "Do you wish to cancel this reservation?"
        static let ALERT_ENTER_MIN_VOUCHERAMOUNT = "Please enter minimum voucher amount"
        static let ALERT_PRINT_ORDER = "Do you wish to print this order?"
        static let ALERT_ENTER_PASSWORD_SYNCMODE = "Please enter password to change order sync mode"
        static let ALERT_ENTER_PASSWORD_ARCHIVEORDER = "Please enter your password to archive orders"
        static let ALERT_ENTER_PASSWORD_UNARCHIVEORDER = "Please enter your password to unarchive orders"
        static let ALERT_ENTER_PASSWORD_CANCELORDER = "Please enter your password to cancel order"
        static let ALERT_ENTER_PASSWORD_DELETEORDER = "Please enter your password to delete order"
        
        static let ALERT_TRANSACTION_UNARCHIVE_SUCCESS = "Transactions unarchieved sucessfully"
        static let ALERT_TRANSACTION_ARCHIVE_SUCCESS = "Transactions archieved sucessfully"
        static let ALERT_CAMERA_SUPPORT = "Camera is not supported"
        static let ALERT_NO_IMAGE = "No image found"
        static let ALERT_CANCELLED_RESERVATION = "Reservation cancelled"
        static let ALERT_VOUCHER_CREATED = "Voucher created successfully"
        static let ALERT_VOUCHER_UPDATED = "Voucher updated successfully"
        static let ALERT_VOUCHER_APPLIED = "Voucher applied successfully"
        static let ALERT_GROUP_MODIFIED_AFTER_PAYMENT = "Group can not be modified after payment has done"
        static let ALERT_SELECT_GROUP = "Please select group first"
        static let ALERT_ORDER_SPLIT_AFTER_DISCOUNT = "Order can not be splited after discount has been added"
        static let ALERT_ORDER_SPLIT_AFTER_GRATUITY = "Order can not be splited after gratutiy has been added"
        static let ALERT_ORDER_SPLIT_AFTER_SERVICECHARGE = "Order can not be splited after service charge has been added"
        static let ALERT_ORDER_MODIFIED_AFTER_CANCELLED = "Order is cancelled, You can not modified this order"
        static let ALERT_ORDER_MODIFIED_AFTER_COMPLETED = "Order is completed, You can not modified this order"
        static let ALERT_ORDER_MODIFIED_AFTER_OTW = "Order is on the way, You can not modified this order"
        static let ALERT_ORDER_MODIFIED_AFTER_RTC = "Order is ready to collect, You can not modified this order"
        static let ALERT_ORDER_MODIFIED_AFTER_SPLITED = "Order can not modified after order is splited with persons"
        static let ALERT_ORDER_MODIFIED_AFTER_PAYMENT = "Order can not modified after order payment is done"
        static let ALERT_ORDER_CANCELLED = "Order is cancelled"
        static let ALERT_NO_ORDER = "No Order Found"
        static let ALERT_NO_TABLESTATUS = "Table status not found"
        static let ALERT_TABLE_BUSY = "Table is busy"
        static let ALERT_PUSHORDER_LOGOUT = "Please push data to the server before logout"
        static let ALERT_VOUCHER_REDEEMED = "Voucher already redeemed"
        static let ALERT_VOUCHER_NOT_VALID_CUSTOMER = "Voucher is not valid for selected customer"
        static let ALERT_PAYMENT_DECLINED = "Payment was declined/aborted!"
        static let ALERT_PAYMENT_SUCESS = "Payment was successful!"
        static let ALERT_MIN_ORDER_VALUE_UPDATE = "Minimum order value updated"
        static let ALERT_DELIVERY_FEE_UPDATE = "Delivery fees updated"
        static let ALERT_SYNCMODE_CHANGE = "Order sync mode has been changed"
        
        static let ALERT_ALL_DATA_WIPE = "All data will be wiped from the system. Are you sure you want to complete a factory data reset?"
        static let ALERT_ALL_ORDER_WIPE = "All orders will be wiped from the system. Are you sure you want to erase all orders?"
        static let ALERT_ALL_RESERVATION_WIPE = "All reservations will be wiped from the system. Are you sure you want to erase all reservations?"
        static let ALERT_THECALLEDID_WIPE = "The caller ID log will be wiped from the system. Are you sure you want to erase it?"
        static let ALERT_CASHDRAWER_WIPE = "The cash drawer log will be wiped from the system. Are you sure you want to erase all it?"
        static let ALERT_ENTER_PASSWORD_FACTRORY_RESET = "Please enter your password to complete factory data reset"
        static let ALERT_ENTER_PASSWORD_ERASEORDER = "Please enter your password to erase all orders"
        static let ALERT_ENTER_PASSWORD_ERASERESERVATION = "Please enter your password to erase all reservations"
        static let ALERT_ENTER_PASSWORD_ERASECALLEDID = "Please enter your password to erase caller ID log"
        static let ALERT_ENTER_PASSWORD_ERASECASHDRAWER = "Please enter your password to erase cash drawer log"
        
        static let ALERT_CANCEL_ORDER_TITLE = "Cancel Order"
        static let ALERT_DELETE_ORDER_TITLE = "Delete Order"
        static let ALERT_CONFIRM_TITLE = "Confirmation"
        static let ALERT_SELECT_PERCENTAGE_TITLE = "Select percentage"
        static let ALERT_SELECT_AMOUNT_TITLE = "Select amount"
        static let ALERT_SELECT_DISTANCE_TITLE = "Select distance"
        static let ALERT_ACCEPT_RESERVATION_TITLE = "Accept Reservation"
        static let ALERT_CANCEL_RESERVATION_TITLE = "Cancel Reservation"
        static let ALERT_INSTRUCTION_TITLE = "Instruction"
        static let ALERT_MIN_VOUCHER_AMOUNT_TITLE = "Minimum voucher amount"
        static let ALERT_RTS_TITLE = "Ready to serve"
        static let ALERT_COLLECTED_TITLE = "Mark as collected"
        static let ALERT_DELIVERED_TITLE = "Mark as delivered"
        static let ALERT_PRINT_ORDER_TITLE = "Print order"
        
        static let ALERT_PAYMENTLINK_SEND = "Payment link sent successfully"
        static let ALERT_REMOTE_DEVICE = "Do you want this device to act as remote device?"
        static let ALERT_ENTER_PASSWORD_REMOTE = "Please enter password for remote device access"
        static let ALERT_REMOTE_ON = "You had turn on your device's remote access"
        static let ALERT_REMOTE_OFF = "You had turn off your device's remote access"
        static let ALERT_GUEST_ZERO = "Number of diners can not be zero."
    }
    
    struct Colors {
        static let kAppThemeBGColor = UIColor.init(named: "AppBGColor")!
        static let kAppDarkGrayColor = UIColor.init(named: "AppDarkGrayColor")!
        static let kAppMediumGrayColor = UIColor.init(named: "AppMediumGrayColor")!
        static let kAppLightGrayColor = UIColor.init(named: "AppLightGrayColor")!
        static let kAppDarkGreenColor = UIColor.init(named: "AppDarkGreenColor")!
        static let kAppMediumGreenColor = UIColor.init(named: "AppMediumGreenColor")!
        static let kAppLightGreenColor = UIColor.init(named: "AppLightGreenColor")!
        static let kAppMainThemeColor = UIColor.init(named: "AppMainThemeColor")!
        static let kAppThemeRedColor = UIColor.init(named: "AppThemeRedColor")!
        static let kAppThemeDarkRedColor = UIColor.init(named: "AppThemeDarkRedColor")!
        static let kAppThemeMediumRedColor = UIColor.init(named: "AppThemeMediumRedColor")!
        static let kAppThemeAquaColor = UIColor.init(named: "AppThemeAquaColor")!
        static let kAppThemeDarkAquaColor = UIColor.init(named: "AppThemeDarkAquaColor")!
        static let kAppThemeTextColor = UIColor.init(named: "AppTextBlackColor")!
        static let kAppThemeBlueColor = UIColor.init(named: "AppThemeBlueColor")!
        static let kAppThemeYellowColor = UIColor.init(named: "AppThemeYellowColor")!
    }
    
    struct GlobalFontConstants {
        static func kRegularFont(size:CGFloat)->UIFont{
            return UIFont.init(name: "Avenir-Roman", size: size) ?? UIFont.systemFont(ofSize: size)
        }
        
        static func kMediumFont(size:CGFloat)->UIFont{
            return UIFont.init(name: "Avenir-Medium", size: size) ?? UIFont.systemFont(ofSize: size)
        }
        
        static func kBoldFont(size:CGFloat)->UIFont{
            return UIFont.init(name: "Avenir-Heavy", size: size) ?? UIFont.boldSystemFont(ofSize: size)
        }
        
        static func kBookFont(size:CGFloat)->UIFont{
            return UIFont.init(name: "Avenir-Book", size: size) ?? UIFont.systemFont(ofSize: size)
        }
        
        static func kLightFont(size:CGFloat)->UIFont{
            return UIFont.init(name: "Avenir-Light", size: size) ?? UIFont.systemFont(ofSize: size)
        }
    }
    
    struct notifications {
        static let kDatabasePushed = Notification.Name(rawValue: "databasePushed")
        static let kDatabasePulled = Notification.Name(rawValue: "databasePulled")
        static let kCountFetched = Notification.Name(rawValue: "countFetched")
        static let kAdminLogin = Notification.Name(rawValue: "adminLogin")
        static let kSideViewChanged = Notification.Name(rawValue: "sideViewChanged")
        static let kSiteSettingsFeatched = Notification.Name(rawValue: "siteSettingsFeatched")
        static let kTableUpdated = Notification.Name(rawValue: "tableUpdated")
        static let kFailedOrder = Notification.Name(rawValue: "failedOrder")
    }
    
    struct userDefaultKey {
        static let kRefreshHeaderToken = "refresh_header_token"
        static let kHeaderToken = "header_token"
        static let kAdminRefreshHeaderToken = "admin_refresh_header_token"
        static let kAdminHeaderToken = "admin_header_token"
        static let kUserData = "user_data"
        static let kUserList = "user_list"
        static let kRestaurantData = "restaurant_data"
        static let kRestaurantSiteSettings = "restaurant_site_settings"
        static let kAdminUserData = "admin_user_data"
        static let kBusinessData = "business_data"
        static let kDeviceId = "device_id"
        static let kFCMToken = "fcm_token"
        static let kSiteSettings = "site_settings"
        static let kSelectedPrinter = "selected_printer"
        static let kReminderData = "reminder_data"
        static let kDataSyncMode = "data_sync_,ode"
        static let kLastUpdateTimeStamp = "last_updated_timestamp"
        static let kAutoDiscount = "auto_discount"
        static let kDeviceName = "device_name"
        static let kLoginTimeStamp = "login_timestamp"
        static let kCardBrand = "card_brands"
        static let kCardBrandComission = "card_brand_comission"
        static let kCountryComission = "country_comission"
        static let kRemoteDevice = "remote_device"
        static let kDeviceApproved = "device_approved"
        static let kPrintSettings = "print_settings"
    }
    
    struct ScreenSize{
        static let SCREEN_WIDTH = UIScreen.main.bounds.size.width
        static let SCREEN_HEIGHT = UIScreen.main.bounds.size.height
        static let topPadding = keywindow?.safeAreaInsets.top ?? 0
        static let bottomPadding = keywindow?.safeAreaInsets.bottom ?? 0
        static let SAFEAREAHEIGHT = UIScreen.main.bounds.size.height-topPadding-bottomPadding
        static let SCREEN_MAX_LENGTH = max(ScreenSize.SCREEN_WIDTH, ScreenSize.SCREEN_HEIGHT)
        static let SCREEN_MIN_LENGTH = min(ScreenSize.SCREEN_WIDTH, ScreenSize.SCREEN_HEIGHT)
    }
    
}



