//
//  AppCommonMethods.swift
//  TiffinTomPartner
//
//  Created by Tushar Premal on 29/10/20.
//

import Foundation
import UIKit
import IQKeyboardManagerSwift
import Toast_Swift
import CoreLocation
import StripeTerminal
import Stripe

class AppCommonMethods: AppConstants{
    
    static var LoaderParentView:UIView?
    static var lblMessage:UILabel?
    
    static func fetchDistance(fLat:Double,fLong:Double,tLat:Double,tLong:Double)->Double{
        let coordinate = CLLocation(latitude: fLat, longitude: fLong)
        let coordinate1 = CLLocation(latitude: tLat, longitude: tLong)
        
        let distanceInMeters = coordinate.distance(from: coordinate1)
        
        return distanceInMeters/1609
    }
    
    static func changeProgressMessage(msg:String){
        DispatchQueue.main.async {
            if lblMessage != nil{
                lblMessage!.text = msg
            }
        }
    }
    
    static func startProgressBar(view:UIView? = nil, isWhiteBG:Bool = false, isInteractive:Bool = false, strMessage:String? = nil)
    {
        if view == nil{
            if LoaderParentView != nil{
                stopProgressBar()
            }
            LoaderParentView = appDelegate.window
        }
        
        let width = ScreenSize.SCREEN_WIDTH
        let height = ScreenSize.SCREEN_HEIGHT
        let viewLoader = UIViewX.init(frame: CGRect.init(x: (width-120)/2, y: (height-120)/2, width: 120, height: 120))
        viewLoader.backgroundColor = .clear
        
        let activityIndicator = UIActivityIndicatorView.init(style: .large)
        activityIndicator.color = Colors.kAppMainThemeColor
        activityIndicator.frame = CGRect.init(x: (viewLoader.frame.width-37)/2, y: (viewLoader.frame.width-37)/2, width: 37, height: 37)
        activityIndicator.startAnimating()
        activityIndicator.transform = CGAffineTransform.init(scaleX: 2, y: 2)
        viewLoader.addSubview(activityIndicator)
        
        let viewBG = UIView.init(frame: CGRect.init(x: 0, y: 0, width: width, height: height))
        viewBG.tag = 10987
        viewBG.backgroundColor = isWhiteBG ? .white : .clear
        viewBG.addSubview(viewLoader)
        
        if isInteractive{
            viewBG.frame = CGRect.init(x: (width-120)/2, y: (height-120)/2, width: 120, height: 120)
            viewLoader.frame = CGRect.init(x: 0, y: 0, width: 120, height: 120)
        }
        if strMessage != nil{
            lblMessage = UILabel()
            lblMessage!.text = strMessage
            lblMessage!.textAlignment = .center
            lblMessage!.textColor = Colors.kAppThemeTextColor
            lblMessage!.font = GlobalFontConstants.kBoldFont(size: 19)
            lblMessage!.numberOfLines = 3
            lblMessage!.adjustsFontSizeToFitWidth = true
            lblMessage!.minimumScaleFactor = 0.7
            viewLoader.addSubview(lblMessage!)
            viewBG.backgroundColor = UIColor.black.withAlphaComponent(0.5)
            viewLoader.backgroundColor = .white
            viewLoader.frame = CGRect.init(x: (width-225)/2, y: (height-225)/2, width: 225, height: 225)
            activityIndicator.frame = CGRect.init(x: (viewLoader.frame.width-37)/2, y: 50, width: 37, height: 37)
            lblMessage!.frame = CGRect.init(x: 10, y: activityIndicator.frame.height + activityIndicator.frame.origin.y + 30, width: 205, height: 85)
            viewLoader.cornerRadius = 15
            viewLoader.shadowColor = Colors.kAppLightGrayColor
            viewLoader.shadowOpacity = 0.7
            viewLoader.shadowOffsetY = 1
        }
        
        if view == nil{
            LoaderParentView!.addSubview(viewBG)
        }else{
            view!.addSubview(viewBG)
        }
        
    }
    
    static func stopProgressBar(view:UIView? = nil)
    {
        if view != nil{
            for subView in (view!.subviews)
            {
                if subView.tag == 10987
                {
                    subView.isHidden = true
                    subView.removeFromSuperview()
                    break
                }
            }
        }else{
            if LoaderParentView != nil{
                for subView in (LoaderParentView!.subviews)
                {
                    if subView.tag == 10987
                    {
                        subView.isHidden = true
                        subView.removeFromSuperview()
                        break
                    }
                }
                LoaderParentView = nil
            }
        }
        lblMessage = nil
        
    }
    
    static func setIntialScreen(){
        if adminData == nil{
            if let VC = AdminLoginVC.instance(){
                let navc = UINavigationController.init(rootViewController: VC)
                navc.isNavigationBarHidden = true
                appDelegate.window?.rootViewController = navc
            }
        }else if businessData == nil{
            if let VC = SelectBusinessVC.instance(){
                let navc = UINavigationController.init(rootViewController: VC)
                navc.isNavigationBarHidden = true
                appDelegate.window?.rootViewController = navc
            }
        }else{
            if let VC = LoginVC.instance(){
                VC.isFromLogout = false
                let navc = UINavigationController.init(rootViewController: VC)
                navc.isNavigationBarHidden = true
                appDelegate.window?.rootViewController = navc
            }
        }
    }
    
    static func removefromUserDefault(withKey key:String){
        UserDefaults.standard.removeObject(forKey: key)
        UserDefaults.standard.synchronize()
    }
    
    static func readStringfromUserDefault(withKey key:String) -> String?{
        return UserDefaults.standard.string(forKey: key)
    }
    
    static func readObjfromUserDefault(withKey key:String) -> Any?{
        return UserDefaults.standard.object(forKey: key)
    }
    
    static func saveDataIntoUserDefault(value:Any?, withKey key:String){
        if value != nil{
            UserDefaults.standard.setValue(value, forKey: key)
            UserDefaults.standard.synchronize()
        }
    }
    
    static func getjsonDataFromCodable<T: Codable>(object:T,isWithoutSlash:Bool = false)->Data? {
        let encoder = JSONEncoder()
        encoder.outputFormatting = [.prettyPrinted,.sortedKeys]
        if isWithoutSlash{
            if #available(iOS 13.0, *) {
                encoder.outputFormatting = [.withoutEscapingSlashes]
            }else{
                encoder.outputFormatting = [.sortedKeys]
            }
        }
        guard let jsonData = try? encoder.encode(object) else { return nil }
        return jsonData
    }
    
    static func convertToJson(object:Any)->Data?{
        do {
            let jsonData = try JSONSerialization.data(withJSONObject: object, options: .prettyPrinted)
            return jsonData
            
        } catch {
            print(error.localizedDescription)
            return nil
        }
    }
    
    static func convertJsontoString(json: Any, prettyPrinted: Bool = false, shouldEncode:Bool = true) -> String{
        var options: JSONSerialization.WritingOptions = []
        if prettyPrinted {
            options = JSONSerialization.WritingOptions.withoutEscapingSlashes
        }
        
        do {
            let data = try JSONSerialization.data(withJSONObject: json, options: options)
            if let string = String(data: data, encoding: String.Encoding.utf8) {
                if shouldEncode{
                    return string.addingPercentEncoding(withAllowedCharacters:.letters) ?? ""
                }else{
                    return string
                }
            }
        } catch {
            print(error)
        }
        
        return ""
    }
    
    static func getUUID() -> String? {
        
        let keychain = KeychainAccess()
        
        let uuidKey = "com.tiffintomepos.unique_uuid"
        
        if let uuid = try? keychain.queryKeychainData(itemKey: uuidKey) {
            return uuid
        }
        
        guard let newId = UIDevice.current.identifierForVendor?.uuidString else {
            return nil
        }
        
        try? keychain.addKeychainData(itemKey: uuidKey, itemValue: newId)
        
        return newId
    }
    
    static func showToastAlert(message:String){
        if message != ""{
            DispatchQueue.main.async {
                appDelegate.window?.makeToast(message, duration: 1, position: .bottom)
            }
        }
    }
    
    static func convertToDictionary(text: String) -> [String: Any]? {
        if let data = text.data(using: .utf8) {
            do {
                return try JSONSerialization.jsonObject(with: data, options: []) as? [String: Any]
            } catch {
                print(error.localizedDescription)
            }
        }
        return nil
    }
    
    static func checkForAppVersion()->Bool{
        let currentVersion = Double(Bundle.main.infoDictionary?["CFBundleShortVersionString"] as? String ?? "1.0") ?? 1
        let strAppStoreVersion = Double(fetchSiteSettingValue(key: "epos_ios_app_version") ?? "") ?? 0
        if currentVersion < strAppStoreVersion{
            if let timestamp = readObjfromUserDefault(withKey: userDefaultKey.kLastUpdateTimeStamp) as? Double{
                let currentTimestamp = Date().timeIntervalSinceReferenceDate
                if timestamp - currentTimestamp > 24*60*60{
                    if let VC = ForceFullyUpdateVC.instance(){
                        appDelegate.window?.rootViewController = VC
                        return false
                    }
                }
            }else{
                if let VC = ForceFullyUpdateVC.instance(){
                    appDelegate.window?.rootViewController = VC
                    return false
                }
            }
        }
        return true
    }
    
    static func getRestaurantDetails(Completed : @escaping (_ status: Bool) -> ()) {
        if webResId ?? "" == ""{
            return
        }
        DispatchQueue.global(qos: .background).async {
            let dictParam = [String:Any]()
            WebServiceManager().requestAPI(params: dictParam, urlString: "\(APIURL.kRestaurant)\(webResId ?? "")", method: "GET", isAdminURL: true, saveAdminToken: true) { (message, response) in
                DispatchQueue.main.async {
                    if response != nil{
                        if isInDevlopmentMode{
                            print("Profile response:",response!)
                        }
                        if let result = response as? NSDictionary{
                            let jsonDecoder = JSONDecoder()
                            if let jsonData = AppCommonMethods.convertToJson(object: result), let aLoginData = try? jsonDecoder.decode(RestaurantDetailModel.self, from: jsonData){
                                if let encoded = AppCommonMethods.getjsonDataFromCodable(object: aLoginData) {
                                    AppCommonMethods.saveDataIntoUserDefault(value: encoded, withKey: userDefaultKey.kRestaurantData)
                                }
                            }
                            if let restaurant = result["site_setting"] as? NSDictionary,let jsonData = AppCommonMethods.convertToJson(object: restaurant), let aData = try? jsonDecoder.decode(RestaurantSiteSettingsModel.self, from: jsonData){
                                if let encoded = AppCommonMethods.getjsonDataFromCodable(object: aData) {
                                    AppCommonMethods.saveDataIntoUserDefault(value: encoded, withKey: userDefaultKey.kRestaurantSiteSettings)
                                }
                            }
                            Completed(true)
                            return
                        }
                    }
                    Completed(false)
                }
            }
        }
    }
    
    static func FetchUserProfile(){
        DispatchQueue.global(qos: .background).async {
            if userData == nil{
                return
            }
            let dictParam = [String:String]()
            WebServiceManager().requestAPI(params: dictParam, urlString: APIURL.kUserProfile, method: "GET") { (message, result) in
                DispatchQueue.main.async {
                    if let response = result as? NSDictionary{
                        let jsonDecoder = JSONDecoder()
                        if let data = convertToJson(object: response), let aLoginData = try? jsonDecoder.decode(UserModel.self, from: data){
                            if let encoded = getjsonDataFromCodable(object: aLoginData) {
                                saveDataIntoUserDefault(value: encoded, withKey: userDefaultKey.kUserData)
                            }
                        }
                    }
                }
            }
        }
    }
    
    static func FetchBusinessData(id:Int? = nil,Completed : @escaping (_ arr:[BusinessModel]?) -> ()){
        if adminData == nil{
            return
        }
        DispatchQueue.global(qos: .background).async {
            var dictParam = [String:String]()
            var strURL = APIURL.kBusinesses
            if id != nil{
                strURL = "\(APIURL.kBusinesses)/\(id!)"
            }else{
                dictParam["nopaginate"] = "1"
            }
            WebServiceManager().requestAPI(params: dictParam, urlString: strURL, method: "GET", isAdminURL: true, saveAdminToken: true) { (message, result) in
                DispatchQueue.main.async {
                    if id != nil{
                        if let response = result as? NSDictionary{
                            let jsonDecoder = JSONDecoder()
                            if let data = convertToJson(object: response), let aData = try? jsonDecoder.decode(BusinessModel.self, from: data){
                                if let encoded = AppCommonMethods.getjsonDataFromCodable(object: aData) {
                                    AppCommonMethods.saveDataIntoUserDefault(value: encoded, withKey: userDefaultKey.kBusinessData)
                                }
                                return
                            }
                        }
                    }else{
                        if let response = result as? [NSDictionary]{
                            let jsonDecoder = JSONDecoder()
                            if let data = convertToJson(object: response), let aData = try? jsonDecoder.decode([BusinessModel].self, from: data){
                                Completed(aData)
                                if self.businessData != nil{
                                    let data = aData.filter { (model) -> Bool in
                                        return model.id ?? 0 == businessData?.id ?? 0
                                    }
                                    if let business = data.first, let encoded = AppCommonMethods.getjsonDataFromCodable(object: business) {
                                        AppCommonMethods.saveDataIntoUserDefault(value: encoded, withKey: userDefaultKey.kBusinessData)
                                    }
                                }
                                return
                            }
                        }
                    }
                    Completed(nil)
                }
            }
        }
    }
    
    static func getSiteSettings() {
        let dictParam = [String:Any]()
        WebServiceManager().requestAPI(params: dictParam, urlString: APIURL.kAllSiteSettings, method: "GET") { (message, response) in
            DispatchQueue.main.async {
                let jsonDecoder = JSONDecoder()
                if let siteSettings = response as? NSDictionary, let jsonData = convertToJson(object: siteSettings), let aData = try? jsonDecoder.decode(TiffintomSiteSettingModel.self, from: jsonData){
                    UserDefaults.siteSettings = aData
                    if aData.finance_stripe_mode.lowercased() == "test"{
                        StripeAPI.defaultPublishableKey = aData.finance_stripe_publishkeyTest
                    }else{
                        StripeAPI.defaultPublishableKey = aData.finance_stripe_publishkey
                    }
                }
            }
        }
    }
    
    static func FetchSiteSettings(Completed : @escaping (_ success:Int) -> ()){
        if adminData == nil{
            return
        }
        var dictParam = [String:String]()
        dictParam["nopaginate"] = "1"
        WebServiceManager().requestAPI(params: dictParam, urlString: APIURL.kSiteSettings, method: "GET") { (message, result) in
            DispatchQueue.main.async {
                if let response = result as? [NSDictionary]{
                    let jsonDecoder = JSONDecoder()
                    if let data = convertToJson(object: response), let aData = try? jsonDecoder.decode([SiteSettingsModel].self, from: data){
                        if let encoded = getjsonDataFromCodable(object: aData) {
                            saveDataIntoUserDefault(value: encoded, withKey: userDefaultKey.kSiteSettings)
                            if fetchSiteSettingValue(key: "cloud_system") ?? "" == "no"{
                                saveDataIntoUserDefault(value: "Manual", withKey: userDefaultKey.kDataSyncMode)
                            }
                            if !checkForAppVersion(){
                                AppCommonMethods.stopProgressBar()
                            }else{
                                Completed(1)
                            }
                            return
                        }
                    }
                }
                Completed(0)
            }
        }
    }
    
    static func Copy<T:Codable>(of object:T) -> T?{
        do{
            let json = try JSONEncoder().encode(object)
            return try JSONDecoder().decode(T.self, from: json)
        }
        catch let error{
            print(error)
            return nil
        }
    }
    
    static func fetchSiteSettingValue(key:String, lowercased:Bool = true)->String?{
        let arr = siteSettings?.filter({ (model) -> Bool in
            return (model.key ?? "").lowercased() == key
        })
        if !lowercased{
            return arr?.first?.value
        }
        return arr?.first?.value?.lowercased()
    }
    
    static func fetchSiteSettingId(key:String, lowercased:Bool = true)->Int?{
        let arr = siteSettings?.filter({ (model) -> Bool in
            return (model.key ?? "").lowercased() == key
        })
        return arr?.first?.id
    }
    
    
    static func PullDataFromServer(Completed : @escaping () -> ()){
        if !Reachabilities.shared.isConnectedToNetwork(){
            Completed()
            return
        }
        let dictParam = [String:String]()
        WebServiceManager().requestAPI(params: dictParam, urlString: APIURL.kPullData, method: "POST", isAdminURL: true, saveAdminToken: userData == nil) { (message, result) in
            if let response = result as? NSDictionary{
                let jsonDecoder = JSONDecoder()
                CoreDataHelper.shared.deleteDataFromDatabase(entity: "Category")
                CoreDataHelper.shared.deleteDataFromDatabase(entity: "Product")
                CoreDataHelper.shared.deleteDataFromDatabase(entity: "AddOns")
                CoreDataHelper.shared.deleteDataFromDatabase(entity: "Ingredients")
                CoreDataHelper.shared.deleteDataFromDatabase(entity: "ProductAddons")
                CoreDataHelper.shared.deleteDataFromDatabase(entity: "Floor")
                CoreDataHelper.shared.deleteDataFromDatabase(entity: "PrepLocation")
                CoreDataHelper.shared.deleteDataFromDatabase(entity: "PrintBlock")
                CoreDataHelper.shared.deleteDataFromDatabase(entity: "TableStatuses")
                CoreDataHelper.shared.deleteDataFromDatabase(entity: "DepositTypes")
                _ = SQLiteManage.ExecuteQuery("DELETE FROM PaymentMethods")
                
                if let arr = response["users"] as? [NSDictionary],let data = convertToJson(object: arr), let aData = try? jsonDecoder.decode([UserModel].self, from: data){
                    let model = aData.filter { (model) -> Bool in
                        return model.id ?? 0 == userData?.id ?? 0
                    }.first
                    if model != nil{
                        if let encoded = getjsonDataFromCodable(object: model!) {
                            saveDataIntoUserDefault(value: encoded, withKey: userDefaultKey.kUserData)
                        }
                    }
                }
                if let arr = response["site_settings"] as? [NSDictionary],let data = convertToJson(object: arr), let aData = try? jsonDecoder.decode([SiteSettingsModel].self, from: data){
                    if let encoded = getjsonDataFromCodable(object: aData) {
                        saveDataIntoUserDefault(value: encoded, withKey: userDefaultKey.kSiteSettings)
                        if fetchSiteSettingValue(key: "cloud_system") ?? "" == "no"{
                            saveDataIntoUserDefault(value: "Manual", withKey: userDefaultKey.kDataSyncMode)
                        }
                        DispatchQueue.main.async {
                            _ = checkForAppVersion()
                        }
                    }
                }
                if let arr = response["discounts"] as? [NSDictionary],let data = convertToJson(object: arr), let aData = try? jsonDecoder.decode([OrderDiscountModel].self, from: data){
                    if let encoded = getjsonDataFromCodable(object: aData) {
                        saveDataIntoUserDefault(value: encoded, withKey: userDefaultKey.kAutoDiscount)
                    }
                }
                if let arr = response["deposit_types"] as? [NSDictionary],let data = convertToJson(object: arr), let aData = try? jsonDecoder.decode([DepositTypeModel].self, from: data){
                    CoreDataHelper.shared.saveDepositTypeIntoDatabase(arrData: aData)
                    arrDepositType = aData
                }
                if let arr = response["payment_methods"] as? [NSDictionary],let data = convertToJson(object: arr), let aData = try? jsonDecoder.decode([PaymentMethodModel].self, from: data){
                    SQLiteManage.savePaymentMethodIntoDatabase(arrData: aData)
                    arrPaymentMethods = aData
                }
                if let arr = response["categories"] as? [NSDictionary],let data = convertToJson(object: arr), let aData = try? jsonDecoder.decode([CategoryModel].self, from: data){
                    CoreDataHelper.shared.saveCategoryIntoDatabase(arrData: aData)
                }
                if let arr = response["floors"] as? [NSDictionary],let data = convertToJson(object: arr), let aData = try? jsonDecoder.decode([FloorModel].self, from: data){
                    CoreDataHelper.shared.saveFloorIntoDatabase(arrData: aData)
                }
                if let arr = response["prep_locations"] as? [NSDictionary],let data = convertToJson(object: arr), let aData = try? jsonDecoder.decode([PrepLocationModel].self, from: data){
                    CoreDataHelper.shared.savePrepLocationIntoDatabase(arrData: aData)
                }
                if let arr = response["addons"] as? [NSDictionary],let data = convertToJson(object: arr), let aData = try? jsonDecoder.decode([AddOnModel].self, from: data){
                    CoreDataHelper.shared.saveAddOnIntoDatabase(arrData: aData)
                }
                if let arr = response["products"] as? [NSDictionary],let data = convertToJson(object: arr), let aData = try? jsonDecoder.decode([ProductModel].self, from: data){
                    CoreDataHelper.shared.saveProductIntoDatabase(arrData: aData)
                }
                if let arr = response["print_blocks"] as? [NSDictionary],let data = convertToJson(object: arr), let aData = try? jsonDecoder.decode([PrintBlockModel].self, from: data){
                    CoreDataHelper.shared.savePrintBlockIntoDatabase(arrData: aData)
                }
                if let arr = response["table_statuses"] as? [NSDictionary],let data = convertToJson(object: arr), let aData = try? jsonDecoder.decode([TableStatusModel].self, from: data){
                    CoreDataHelper.shared.saveTableStatusesIntoDatabase(arrData: aData)
                }
                if let arr = response["order_statuses"] as? [NSDictionary],let data = convertToJson(object: arr), let aData = try? jsonDecoder.decode([OrderStatusModel].self, from: data){
                    SQLiteManage.saveOrderStatusIntoDatabase(arrData: aData)
                    arrOrderStatuses = aData
                }
            }
            Completed()
        }
    }
    
    static func PullCustomerFromServer(Completed : @escaping () -> ()){
        if !Reachabilities.shared.isConnectedToNetwork(){
            Completed()
            return
        }
        var dictParam = [String:String]()
        dictParam["nopaginate"] = "1"
        WebServiceManager().requestAPI(params: dictParam, urlString: APIURL.kCustomer, method: "GET", isAdminURL: true, saveAdminToken: userData == nil) { (message, result) in
            let jsonDecoder = JSONDecoder()
            CoreDataHelper.shared.deleteDataFromDatabase(entity: "Customer",predict: NSPredicate.init(format: "offline == 0"))
            if let response = result as? [NSDictionary],let data = convertToJson(object: response), let aData = try? jsonDecoder.decode([CustomerModel].self, from: data){
                CoreDataHelper.shared.saveAndUpdateCusomer(customers: aData, offline: 0, shouldUpdateLabel: true)
            }
            Completed()
        }
    }
    
    static func FetchDeposits(){
        var dictParam = [String:String]()
        dictParam["nopaginate"] = "1"
        WebServiceManager().requestAPI(params: dictParam, urlString: APIURL.kDeposits, method: "GET", isAdminURL: true, saveAdminToken: true) { (message, result) in
            DispatchQueue.main.async {
                CoreDataHelper.shared.deleteDataFromDatabase(entity: "DepositTypes")
                if let response = result as? [NSDictionary]{
                    let jsonDecoder = JSONDecoder()
                    if let data = AppCommonMethods.convertToJson(object: response), let aData = try? jsonDecoder.decode([DepositTypeModel].self, from: data){
                        CoreDataHelper.shared.saveDepositTypeIntoDatabase(arrData: aData)
                        arrDepositType = aData
                        return
                    }
                }
                
            }
        }
    }
    
    static func FetchTableStatus(){
        var dictParam = [String:String]()
        dictParam["nopaginate"] = "1"
        WebServiceManager().requestAPI(params: dictParam, urlString: APIURL.kTableStatus, method: "GET", isAdminURL: true, saveAdminToken: true) { (message, result) in
            DispatchQueue.main.async {
                CoreDataHelper.shared.deleteDataFromDatabase(entity: "TableStatuses")
                if let response = result as? [NSDictionary]{
                    let jsonDecoder = JSONDecoder()
                    if let data = AppCommonMethods.convertToJson(object: response), let aData = try? jsonDecoder.decode([TableStatusModel].self, from: data){
                        CoreDataHelper.shared.saveTableStatusesIntoDatabase(arrData: aData)
                    }
                }
                
            }
        }
    }
    
    static func FetchAutoDiscount(){
        var dictParam = [String:String]()
        dictParam["nopaginate"] = "1"
        WebServiceManager().requestAPI(params: dictParam, urlString: APIURL.kAutoDiscount, method: "GET", isAdminURL: true, saveAdminToken: true) { (message, result) in
            DispatchQueue.main.async {
                if let response = result as? [NSDictionary]{
                    let jsonDecoder = JSONDecoder()
                    if let data = AppCommonMethods.convertToJson(object: response), let aData = try? jsonDecoder.decode([OrderDiscountModel].self, from: data){
                        if let encoded = getjsonDataFromCodable(object: aData) {
                            saveDataIntoUserDefault(value: encoded, withKey: userDefaultKey.kAutoDiscount)
                        }
                    }
                }
                
            }
        }
    }
    
    static func FetchOrderStatus(){
        var dictParam = [String:String]()
        dictParam["nopaginate"] = "1"
        WebServiceManager().requestAPI(params: dictParam, urlString: APIURL.kOrderStatuses, method: "GET", isAdminURL: true, saveAdminToken: true) { (message, result) in
            DispatchQueue.main.async {
                if let response = result as? [NSDictionary]{
                    let jsonDecoder = JSONDecoder()
                    if let data = AppCommonMethods.convertToJson(object: response), let aData = try? jsonDecoder.decode([OrderStatusModel].self, from: data){
                        SQLiteManage.saveOrderStatusIntoDatabase(arrData: aData)
                        arrOrderStatuses = aData
                    }
                }
            }
            
        }
    }
    
    static func FetchOrderType(Completed : @escaping () -> ()){
        var dictParam = [String:String]()
        dictParam["nopaginate"] = "1"
        WebServiceManager().requestAPI(params: dictParam, urlString: APIURL.kOrderTypes, method: "GET", isAdminURL: true, saveAdminToken: true) { (message, result) in
            DispatchQueue.main.async {
                if let response = result as? [NSDictionary]{
                    let jsonDecoder = JSONDecoder()
                    if let data = AppCommonMethods.convertToJson(object: response), let aData = try? jsonDecoder.decode([OrderTypesModel].self, from: data){
                        SQLiteManage.saveOrderTypeIntoDatabase(arrData: aData)
                        arrOrderTypes = aData
                    }
                }
                Completed()
            }
            
        }
    }
    
    static func FetchOrdersList(showMessage:Bool = true, Completed : @escaping () -> ())  {
        var dictParam = [String:String]()
        dictParam["nopaginate"] = "1"
        dictParam["from_date"] = "2020-01-01"
        dictParam["to_date"] = Date().getDateInString(format: "yyyy-MM-dd")
        if showMessage{
            AppCommonMethods.changeProgressMessage(msg: "Fetching orders")
        }
        WebServiceManager().requestAPI(params: dictParam, urlString: APIURL.kCreateOrder, method: "GET") { (message, result) in
            if let response = result as? [NSDictionary]{
                let jsonDecoder = JSONDecoder()
                if let data = AppCommonMethods.convertToJson(object: response), let aData = try? jsonDecoder.decode([OrderModel].self, from: data){
                    aData.forEach { order in
                        let statusId = order.orderStatusId ?? 0
                        if order.table != nil && statusId != 11 && statusId != 10 && statusId != 9 && statusId != 5{
                            let tabel = order.table!
                            tabel.lastOrderId = order.id ?? 0
                            tabel.lastOrderTime = order.createdDate?.getDateInString(format: "yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'") ?? ""
                            tabel.lastOrderTotal = order.total ?? 0
                            SQLiteManage.updateTableSocket(model: tabel)
                            NotificationCenter.default.post(name: AppConstants.notifications.kTableUpdated, object: nil)
                        }
                    }
                    SQLiteManage.SaveOrderIntoDatabase(arrOrder: aData,showMessage: showMessage, isFromSplash: true)
                }else{
                    SQLiteManage.SaveOrderIntoDatabase(arrOrder: [OrderModel](), isFromSplash: true)
                }
            }
            Completed()
        }
    }
    
    static func fireLocalNotification(interval:TimeInterval,orderId:String,message:String){
        let content = UNMutableNotificationContent()
        content.title = NSString.localizedUserNotificationString(forKey: GlobalAlert.ALERT_TITLE, arguments: nil)
        content.body = NSString.localizedUserNotificationString(forKey: message, arguments: nil)
        content.userInfo = ["type":"order","id":orderId]
        content.sound = UNNotificationSound.init(named: UNNotificationSoundName.init(rawValue: "order_alert.mp3"))
        content.categoryIdentifier = orderId
        
        let trigger = UNTimeIntervalNotificationTrigger.init(timeInterval: TimeInterval(interval), repeats: false)
        
        let request = UNNotificationRequest.init(identifier: orderId, content: content, trigger: trigger)
        
        let center = UNUserNotificationCenter.current()
        center.add(request)
    }
    
    static func cancelLocalNotification(orderId:String){
        let center = UNUserNotificationCenter.current()
        center.removePendingNotificationRequests(withIdentifiers: [orderId])
    }
    
    static func DownloadImageFromURL(strURL:String,Completed : @escaping (_ image: UIImage?, _ error: String?) -> ()){
        let imageName = strURL.components(separatedBy: "/").last ?? ""
        let nsDocumentDirectory = FileManager.SearchPathDirectory.documentDirectory
        let nsUserDomainMask = FileManager.SearchPathDomainMask.userDomainMask
        let paths = NSSearchPathForDirectoriesInDomains(nsDocumentDirectory, nsUserDomainMask, true)
        
        if let path = paths.first{
            let imageURL = URL(fileURLWithPath: path).appendingPathComponent("\(imageName)")
            if FileManager.default.fileExists(atPath: imageURL.path){
                Completed(UIImage(contentsOfFile: imageURL.path),nil)
                return
            }
            if let url = URL(string: strURL) {
                let task = URLSession.shared.dataTask(with: url) { data, response, error in
                    guard let data = data, error == nil else {
                        Completed(nil,error?.localizedDescription)
                        return
                    }
                    
                    Completed(UIImage(data: data),nil)
                    do {
                        try data.write(to: imageURL)
                    } catch let error{
                        print("error saving file to documents:", error.localizedDescription)
                    }
                }
                
                task.resume()
            }
        }
    }
    
    static func SaveTable(table:TableModel, status:String? = nil, statusId:Int? = nil, locked:Int? = nil, mergeTableId:Int? = nil, lastOrderId:Int? = nil){
        var shouldCallAPI = false
        if statusId != nil{
            if statusId! != table.tableStatusId ?? 0{
                table.tableStatusId = statusId!
                shouldCallAPI = true
                if let tableStatus = CoreDataHelper.shared.fetchTableStatusData(id: statusId!).first{
                    table.tableStatus = tableStatus
                }
            }
        }
        if status != nil{
            if let tableStatus = CoreDataHelper.shared.fetchTableStatusData(name: status!).first{
                if tableStatus.id ?? 0 != table.tableStatusId ?? 0{
                    shouldCallAPI = true
                }
                table.tableStatus = tableStatus
                table.tableStatusId = tableStatus.id ?? 0
            }else{
                AppCommonMethods.showToastAlert(message: "Table status not found")
                return
            }
        }
        
        if locked != nil{
            shouldCallAPI = true
            table.locked = locked! == 1
        }
        if mergeTableId != nil{
            shouldCallAPI = true
            table.mergeTableId = mergeTableId!
        }
        if lastOrderId != nil{
            shouldCallAPI = true
            table.lastOrderId = lastOrderId!
            table.lastOrderTime = Date().getDateInString(format: "yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'")
        }
        
        table.updaterId = AppConstants.userData?.id ?? 0
        
        if shouldCallAPI{
            if table.tableStatus?.status?.lowercased() ?? "" == "vacant"{
                if let tableStatus = CoreDataHelper.shared.fetchTableStatusData(name: "vacant").first, let table = SQLiteManage.fetchTableDataFromMergeId(id: table.id ?? 0){
                    table.mergeTableId = 0
                    table.locked = false
                    table.tableStatusId = tableStatus.id ?? 0
                    if let dictTable = encodeFromModel(table) as? [String:Any]{
                        SocketService.shared?.sendTableToSocket(data: dictTable, id: table.id ?? 0)
                    }
                }
            }
            if let dictTable = encodeFromModel(table) as? [String:Any]{
                SocketService.shared?.sendTableToSocket(data: dictTable, id: table.id ?? 0)
            }
        }
    }
    
    static func FetchCardBrand()  {
        if adminData != nil{
            var dictParam = [String:String]()
            dictParam["nopaginate"] = "1"
            
            WebServiceManager().requestAPI(params: dictParam, urlString: APIURL.kCardBrand, method: "GET", isAdminURL: true) { (message, result) in
                let jsonDecoder = JSONDecoder()
                if let response = result as? [NSDictionary], let data = AppCommonMethods.convertToJson(object: response), let aData = try? jsonDecoder.decode([CardBrandModel].self, from: data){
                    if let encoded = getjsonDataFromCodable(object: aData) {
                        saveDataIntoUserDefault(value: encoded, withKey: userDefaultKey.kCardBrand)
                    }
                }
            }
        }
    }
    
    static func FetchCardBrandComission()  {
        if businessData?.connectService ?? 0 == 1{
            var dictParam = [String:String]()
            dictParam["nopaginate"] = "1"
            
            WebServiceManager().requestAPI(params: dictParam, urlString: "\(APIURL.kAPIBusinesses)/\(businessData?.id ?? 0)/card-brand-commissions", method: "GET", isAdminURL: true) { (message, result) in
                let jsonDecoder = JSONDecoder()
                if let response = result as? [NSDictionary], let data = AppCommonMethods.convertToJson(object: response), let aData = try? jsonDecoder.decode([CardBrandComissionModel].self, from: data){
                    if let encoded = getjsonDataFromCodable(object: aData) {
                        saveDataIntoUserDefault(value: encoded, withKey: userDefaultKey.kCardBrandComission)
                    }
                }
            }
        }
    }
    
    static func FetchCountryComission()  {
        if businessData?.connectService ?? 0 == 1{
            var dictParam = [String:String]()
            dictParam["nopaginate"] = "1"
            
            WebServiceManager().requestAPI(params: dictParam, urlString: "\(APIURL.kAPIBusinesses)/\(businessData?.id ?? 0)/country-commissions", method: "GET", isAdminURL: true) { (message, result) in
                let jsonDecoder = JSONDecoder()
                if let response = result as? [NSDictionary], let data = AppCommonMethods.convertToJson(object: response), let aData = try? jsonDecoder.decode([CountryComissionModel].self, from: data){
                    if let encoded = getjsonDataFromCodable(object: aData) {
                        saveDataIntoUserDefault(value: encoded, withKey: userDefaultKey.kCountryComission)
                    }
                }
            }
        }
    }
    
    static func FetchPrintSettings()  {
        if businessData == nil{
            return
        }
        var dictParam = [String:String]()
        dictParam["nopaginate"] = "1"
        
        WebServiceManager().requestAPI(params: dictParam, urlString: APIURL.kPrintSettings, method: "GET", isAdminURL: true, saveAdminToken: true) { (message, result) in
            if let response = result as? [NSMutableDictionary]{
                var arrStructures = [NSMutableDictionary]()
                var arrKeys = [String]()
                for structure in response{
                    let dictStructure = structure
                    if let print = structure["print_structure"] as? NSMutableDictionary{
                        let keys = print.allKeys as! [String]
                        var arrS = [NSMutableDictionary]()
                        for key in keys{
                            if let data = print[key] as? NSMutableDictionary{
                                data["name"] = key
                                if !arrKeys.contains(key){
                                    arrKeys.append(key)
                                }
                                arrS.append(data)
                            }
                        }
                        arrS = arrS.sorted{ $0.getIntValue("sequence") ?? 0 < $1.getIntValue("sequence") ?? 0 }
                        dictStructure["structure"] = arrS
                    }
                    arrStructures.append(dictStructure)
                }
                //                print(arrKeys)
                //                print(convertJsontoString(json: arrStructures, prettyPrinted: true, shouldEncode: false))
                saveDataIntoUserDefault(value: arrStructures, withKey: userDefaultKey.kPrintSettings)
            }
        }
    }
}

class KeychainAccess {
    
    func addKeychainData(itemKey: String, itemValue: String) throws {
        guard let valueData = itemValue.data(using: .utf8) else {
            print("Keychain: Unable to store data, invalid input - key: \(itemKey), value: \(itemValue)")
            return
        }
        
        let queryAdd: [String: AnyObject] = [
            kSecClass as String: kSecClassGenericPassword,
            kSecAttrAccount as String: itemKey as AnyObject,
            kSecValueData as String: valueData as AnyObject,
            kSecAttrAccessible as String: kSecAttrAccessibleWhenUnlocked
        ]
        let resultCode: OSStatus = SecItemAdd(queryAdd as CFDictionary, nil)
        
        if resultCode != 0 {
            print("Keychain: value not added - Error: \(resultCode)")
        } else {
            print("Keychain: value added successfully")
        }
    }
    
    func queryKeychainData (itemKey: String) throws -> String? {
        let queryLoad: [String: AnyObject] = [
            kSecClass as String: kSecClassGenericPassword,
            kSecAttrAccount as String: itemKey as AnyObject,
            kSecReturnData as String: kCFBooleanTrue,
            kSecMatchLimit as String: kSecMatchLimitOne
        ]
        var result: AnyObject?
        let resultCodeLoad = withUnsafeMutablePointer(to: &result) {
            SecItemCopyMatching(queryLoad as CFDictionary, UnsafeMutablePointer($0))
        }
        
        if resultCodeLoad != 0 {
            print("Keychain: unable to load data - \(resultCodeLoad)")
            return nil
        }
        
        guard let resultVal = result as? NSData, let keyValue = NSString(data: resultVal as Data, encoding: String.Encoding.utf8.rawValue) as String? else {
            print("Keychain: error parsing keychain result - \(resultCodeLoad)")
            return nil
        }
        return keyValue
    }
}

class LeftAlignedCollectionViewFlowLayout: UICollectionViewFlowLayout {
    
    override func layoutAttributesForElements(in rect: CGRect) -> [UICollectionViewLayoutAttributes]? {
        let attributes = super.layoutAttributesForElements(in: rect)
        
        var leftMargin = sectionInset.left
        var maxY: CGFloat = -1.0
        attributes?.forEach { layoutAttribute in
            if layoutAttribute.frame.origin.y >= maxY {
                leftMargin = sectionInset.left
            }
            
            layoutAttribute.frame.origin.x = leftMargin
            
            leftMargin += layoutAttribute.frame.width + minimumInteritemSpacing
            maxY = max(layoutAttribute.frame.maxY , maxY)
        }
        
        return attributes
    }
}

public class HorizontalCollectionViewLayout : UICollectionViewLayout {
    var itemSize = CGSize(width: 0, height: 0) {
        didSet {
            invalidateLayout()
        }
    }
    private var cellCount = 0
    private var boundsSize = CGSize(width: 0, height: 0)
    
    public override func prepare() {
        cellCount = self.collectionView!.numberOfItems(inSection: 0)
        boundsSize = self.collectionView!.bounds.size
    }
    public override var collectionViewContentSize: CGSize {
        let verticalItemsCount = Int(floor(boundsSize.height / itemSize.height))
        let horizontalItemsCount = Int(floor(boundsSize.width / itemSize.width))
        
        let itemsPerPage = verticalItemsCount * horizontalItemsCount
        let numberOfItems = cellCount
        let numberOfPages = Int(ceil(Double(numberOfItems) / Double(itemsPerPage)))
        
        var size = boundsSize
        size.width = CGFloat(numberOfPages) * boundsSize.width
        return size
    }
    
    public override func layoutAttributesForElements(in rect: CGRect) -> [UICollectionViewLayoutAttributes]? {
        var allAttributes = [UICollectionViewLayoutAttributes]()
        for i in 0..<cellCount {
            let indexPath = IndexPath(row: i, section: 0)
            let attr = self.computeLayoutAttributesForCellAt(indexPath: indexPath)
            allAttributes.append(attr)
        }
        return allAttributes
    }
    
    public override func layoutAttributesForItem(at indexPath: IndexPath) -> UICollectionViewLayoutAttributes? {
        return computeLayoutAttributesForCellAt(indexPath: indexPath)
    }
    
    public override func shouldInvalidateLayout(forBoundsChange newBounds: CGRect) -> Bool {
        return true
    }
    
    private func computeLayoutAttributesForCellAt(indexPath:IndexPath)
    -> UICollectionViewLayoutAttributes {
        let row = indexPath.row
        let bounds = self.collectionView!.bounds
        
        let verticalItemsCount = Int(floor(boundsSize.height / itemSize.height))
        let horizontalItemsCount = Int(floor(boundsSize.width / itemSize.width))
        let itemsPerPage = verticalItemsCount * horizontalItemsCount
        
        let columnPosition = row % horizontalItemsCount
        let rowPosition = (row/horizontalItemsCount)%verticalItemsCount
        let itemPage = Int(floor(Double(row)/Double(itemsPerPage)))
        
        let attr = UICollectionViewLayoutAttributes(forCellWith: indexPath)
        
        var frame = CGRect.zero
        frame.origin.x = CGFloat(itemPage) * bounds.size.width + CGFloat(columnPosition) * itemSize.width
        frame.origin.y = CGFloat(rowPosition) * itemSize.height
        frame.size = itemSize
        attr.frame = frame
        
        return attr
    }
}


func decodeToModel<T: Decodable>(_ object: Any)->T?{
    do {
        let data = try JSONSerialization.data(withJSONObject: object, options: [.prettyPrinted, .sortedKeys, .withoutEscapingSlashes])
        let model = try JSONDecoder().decode(T.self, from: data)
        return model
    }catch {
        print(error.localizedDescription)
        return nil
    }
}

func encodeFromModel<T: Codable>(_ object: T)->Any?{
    let encoder = JSONEncoder()
    encoder.outputFormatting = [.prettyPrinted, .sortedKeys, .withoutEscapingSlashes]
    guard let jsonData = try? encoder.encode(object) else { return nil }
    do {
        return try JSONSerialization.jsonObject(with: jsonData, options: [.mutableContainers])
    } catch {
        print(error)
        return nil
    }
}

func encodeFromModelToString<T: Codable>(_ object: T)->String?{
    let encoder = JSONEncoder()
    encoder.outputFormatting = [.prettyPrinted, .sortedKeys, .withoutEscapingSlashes]
    guard let jsonData = try? encoder.encode(object) else { return nil }
    return String.init(data: jsonData, encoding: .utf8)
}
