//
//  AppDelegate.swift
//  EPOS
//
//  Created by Tushar Premal on 01/03/21.
//

import UIKit
import IQKeyboardManagerSwift
import CoreData
import UserNotifications
import FirebaseCore
import FirebaseAppCheck
import IQKeyboardToolbarManager
import StripeTerminal
import FirebaseMessaging
import Stripe

@main
class AppDelegate: UIResponder, UIApplicationDelegate {
    
    var apiCalling = false
    var window: UIWindow?
    func application(_ application: UIApplication, didFinishLaunchingWithOptions launchOptions: [UIApplication.LaunchOptionsKey: Any]?) -> Bool {
        // Override point for customization after application launch.
        setEnviromentData()
        FirebaseApp.configure()
        IQKeyboardManager.shared.isEnabled = true
        IQKeyboardManager.shared.resignOnTouchOutside = true
        IQKeyboardToolbarManager.shared.isEnabled = true
        Reachabilities.shared.startMonitoring()
        let providerFactory = UBSIDICheckProviderFactory()
        AppCheck.setAppCheckProviderFactory(providerFactory)
        registerForPushNotifications()
        _ = SQLiteManage.copyDatabaseToDirectory()
        Terminal.setTokenProvider(WebServiceManager())
        SQLiteManage.printDBPath()
        Messaging.messaging().token { token, error in
            if let error = error {
                print("Error fetching FCM registration token: \(error)")
            }else if let token = token {
                print("FCM registration token: \(token)")
                AppCommonMethods.saveDataIntoUserDefault(value: token, withKey: AppConstants.userDefaultKey.kFCMToken)
            }
        }
        Messaging.messaging().delegate = self
        UIApplication.shared.isIdleTimerDisabled = true
        
        return true
    }
    
    func applicationWillTerminate(_ application: UIApplication) {
        UIApplication.shared.isIdleTimerDisabled = false
    }
    
    func registerForPushNotifications() {
        UNUserNotificationCenter.current().delegate = self
        UNUserNotificationCenter.current().requestAuthorization(options: [.badge, .sound, .alert], completionHandler: {(granted, error) in
            if (granted)
            {
                DispatchQueue.main.async(execute: {
                    UIApplication.shared.registerForRemoteNotifications()
                })
            }
            else{
                
            }
        })
    }
    
    func application(_ application: UIApplication, didRegisterForRemoteNotificationsWithDeviceToken deviceToken: Data){
        var token: String = ""
        
        for i in 0..<deviceToken.count {
            token += String(format: "%02.2hhx", deviceToken[i] as CVarArg)
        }
        if AppConstants.isInDevlopmentMode{
            print("device token: \(token)")
        }
        Messaging.messaging().apnsToken = deviceToken
    }
    
    // MARK: UISceneSession Lifecycle
    func application(_ application: UIApplication, configurationForConnecting connectingSceneSession: UISceneSession, options: UIScene.ConnectionOptions) -> UISceneConfiguration {
        // Called when a new scene session is being created.
        // Use this method to select a configuration to create the new scene with.
        return UISceneConfiguration(name: "Default Configuration", sessionRole: connectingSceneSession.role)
    }
    
    func application(_ application: UIApplication, didDiscardSceneSessions sceneSessions: Set<UISceneSession>) {
        // Called when the user discards a scene session.
        // If any sessions were discarded while the application was not running, this will be called shortly after application:didFinishLaunchingWithOptions.
        // Use this method to release any resources that were specific to the discarded scenes, as they will not return.
    }
    
    // MARK: - Core Data stack
    
    lazy var persistentContainer: NSPersistentContainer = {
        let container = NSPersistentContainer(name: "EPOSModel")
        container.loadPersistentStores(completionHandler: { (storeDescription, error) in
            if let error = error as NSError? {
                fatalError("Unresolved error \(error), \(error.userInfo)")
            }
        })
        return container
    }()
    
    // MARK: - Core Data Saving support
    
    func saveContext () {
        let context = persistentContainer.viewContext
        if context.hasChanges {
            context.performAndWait {
                do {
                    try context.save()
                } catch let error{
                    print(error.localizedDescription)
                }
            }
        }
    }
    
    func CallPaymentAPI(amount:Double,txnId:String,orderId:Int){
        let paymentId = Date().millisecondsSince1970
        PrintManager.shared.shouldOpenDrawer = false
        if let order = SQLiteManage.fetchOrderForNotification(orderId: orderId){
            let totalPaid = (order.totalPaid ?? 0) + amount
            order.totalPaid = totalPaid
            
            let paymentModel = PaymentOrderModel()
            paymentModel.id = paymentId
            paymentModel.amount = amount
            paymentModel.paymentMethodId = 11
            paymentModel.offline = 1
            paymentModel.updaterId = AppConstants.userData?.id ?? 0
            paymentModel.paymentMethodName = "Pay By Link"
            paymentModel.txnId = txnId
            
            var arrPayments = order.arrOrderPayments
            arrPayments.append(paymentModel)
            order.arrOrderPayments = arrPayments
            SQLiteManage.insertOrderPayments(orderId: order.id ?? 0, arrPayments: [paymentModel], database: nil, offline: 1)
            
            if (order.totalPaid ?? 0).getRoundFigure() >= (order.total ?? 0).getRoundFigure() && order.total ?? 0 > 0{
                if AppCommonMethods.fetchSiteSettingValue(key: "order_complete_mode") ?? "" == "auto"{
                    if order.table != nil{
                        if let status = CoreDataHelper.shared.fetchTableStatusData(name: "vacant").first{
                            AppCommonMethods.SaveTable(table: order.table!, statusId: status.id)
                            order.table?.tableStatusId = status.id
                            SQLiteManage.updateTableStatus(tableId: order.table?.id ?? 0, statusId: status.id, lastOrderId: 0, lastOrderTotal: 0, lastOrderTime: "", offline: 1)
                        }else{
                            AppCommonMethods.showToastAlert(message: AppConstants.GlobalAlert.ALERT_NO_TABLESTATUS)
                        }
                    }
                    order.orderStatusId = 5
                }else{
                    if order.table != nil{
                        if let status = CoreDataHelper.shared.fetchTableStatusData(name: "Served and paid").first{
                            AppCommonMethods.SaveTable(table: order.table!, statusId: status.id)
                            SQLiteManage.updateTableStatus(tableId: order.table?.id ?? 0, statusId: status.id)
                            order.table?.tableStatus = status
                            order.table?.tableStatusId = status.id ?? 0
                        }else{
                            AppCommonMethods.showToastAlert(message: AppConstants.GlobalAlert.ALERT_NO_TABLESTATUS)
                        }
                    }
                    order.orderStatusId = 4
                }
            }
            
            if Reachabilities.shared.isConnectedToNetwork() && AppConstants.DataSyncMode == "Auto"{
                BGAPIExecution.shared.orderSaved = { id,message in
                    print("Order \(id) Saved To Server")
                    DispatchQueue.main.async {
                        if message == nil{
                            self.performOrderSaveAction(id: id, oldId: orderId)
                        }else{
                            AppCommonMethods.showToastAlert(message: message!)
                        }
                    }
                }
                BGAPIExecution.shared.AddOrderToQueue(order: order, shouldPrint: true)
            }else{
                SQLiteManage.SaveOrderIntoDatabase(order: order, updated: 1)
                self.performOrderSaveAction(id: orderId, oldId: orderId)
            }
        }
    }
    
    func performOrderSaveAction(id:Int,oldId:Int){
        if let order = SQLiteManage.fetchOrderDataById(orderId: id), let controller = UIApplication.topViewController(){
            var payBillAction = "pay_bill_action"
            if order.orderTypeId ?? 0 == 2{
                payBillAction = "pickup_pay_bill_action"
            }else if order.orderTypeId ?? 0 == 5{
                payBillAction = "waiting_pay_bill_action"
            }else if order.orderTypeId ?? 0 == 3{
                payBillAction = "delivery_pay_bill_action"
            }
            if AppCommonMethods.fetchSiteSettingValue(key: payBillAction) ?? "" == "prep_ticket"{
                if AppCommonMethods.fetchSiteSettingValue(key: "kitchen_copy_type") ?? "" == "manual"{
                    AppValidation().showAlertView(parentVC: controller, withAlertTile: nil, withAlertMsg: AppConstants.GlobalAlert.ALERT_KITCHEN_COPY, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_NO,AppConstants.GlobalAlert.ALERT_BTN_YES]) { (index) in
                        if index == 1{
                            PrintManager.shared.connectToPrinterWithPrintOrder(order: order, controller: controller)
                        }
                    }
                }else{
                    PrintManager.shared.connectToPrinterWithPrintOrder(order: order, controller: controller)
                }
            }else if AppCommonMethods.fetchSiteSettingValue(key: payBillAction) ?? "" == "both"{
                PrintManager.shared.connectToPrinterWithPrintOrder(order: order, controller: controller, isPrintAll: true)
            }else if AppCommonMethods.fetchSiteSettingValue(key: payBillAction) ?? "" == "bill"{
                if AppCommonMethods.fetchSiteSettingValue(key: "pay_bill_action_type") ?? "" == "manual"{
                    AppValidation().showAlertView(parentVC: controller, withAlertTile: nil, withAlertMsg: AppConstants.GlobalAlert.ALERT_ORDER_BILL, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_NO,AppConstants.GlobalAlert.ALERT_BTN_YES]) { (index) in
                        if index == 1{
                            PrintManager.shared.isSplitBillCopy = false
                            PrintManager.shared.isPrintingBill = true
                            PrintManager.shared.connectToPrinterWithPrint(model:order, controller: controller)
                        }
                    }
                }else{
                    PrintManager.shared.isSplitBillCopy = false
                    PrintManager.shared.isPrintingBill = true
                    PrintManager.shared.connectToPrinterWithPrint(model: order, controller: controller)
                }
            }
        }
        NotificationCenter.default.post(name: AppConstants.notifications.kDatabasePushed, object: ["order_id":id,"old_id":oldId])
    }
    
    func CallGetOrderDetailAPI(orderId:Int,orderType:String){
        if apiCalling{
            return
        }
        let dictParam = [String:String]()
        WebServiceManager().requestAPI(params: dictParam,  urlString: "\(AppConstants.APIURL.kOnlineOrder)\(orderId)", method: "GET",isRestaurantAPI: true) { (message, result) in
            DispatchQueue.main.async {
                self.apiCalling = false
                let jsonDecoder = JSONDecoder()
                if let arrO = result as? NSDictionary, let data = AppCommonMethods.convertToJson(object: arrO), let aData = try? jsonDecoder.decode(WebOrderModel.self, from: data){
                    if let _ = NewOnlineOrderVC.showPopup(order: aData, orderType: orderType){
                        
                    }
                }
            }
        }
    }
    
    func FetchOrderDetail(id:Int, shouldPrint:Bool = false, controller:UIViewController){
//        if shouldPrint && ((controller is DineInTableVC) || (controller is HomeViewController) || (controller is OrderListVC) || (controller is CreateOrderVC) || (controller is OrderReviewVC)){
            let dictParam = [String:String]()
            WebServiceManager().requestAPI(params: dictParam, urlString: "\(AppConstants.APIURL.kCreateOrder)/\(id)", method: "GET") { (message, result) in
                DispatchQueue.main.async {
                    let jsonDecoder = JSONDecoder()
                    if let response = result as? NSDictionary, let data = AppCommonMethods.convertToJson(object: response), let aData = try? jsonDecoder.decode(OrderModel.self, from: data){
                        SQLiteManage.SaveOrderIntoDatabase(arrOrder: [aData], shouldDelete: false)
                        if shouldPrint{
                            PrintManager.shared.stopPrintForNotification = nil
                            PrintManager.shared.stopPrintForNotification = { orderId in
                                DispatchQueue.main.async {
                                    AppCommonMethods.stopProgressBar()
                                }
                                if Reachabilities.shared.isConnectedToNetwork() && AppConstants.DataSyncMode == "Auto"{
                                    if let order = SQLiteManage.fetchOrderDataById(orderId: id){
                                        BGAPIExecution.shared.orderSaved = { orderId,message in
                                            print("Order \(orderId) Saved To Server")
                                        }
                                        BGAPIExecution.shared.AddOrderToQueue(order: order)
                                        self.orderNotificationTask(order:order,VC:controller)
                                    }
                                }
                                self.orderNotificationTask(order:aData,VC:controller)
                            }
                            let printSetting = AppCommonMethods.fetchSiteSettingValue(key: "dinein_remote_device_setting")
                            if printSetting != "none" && printSetting != ""{
                                var isPrintAll = false
                                if printSetting == "print_all"{
                                    isPrintAll = true
                                }else if printSetting == "send_order"{
                                    PrintManager.shared.isPrintingBill = false
                                }else if printSetting == "print_bill"{
                                    PrintManager.shared.isPrintingBill = true
                                }
                                PrintManager.shared.connectToPrinterWithPrintOrder(order: aData, controller: controller,isPrintAll: isPrintAll)
                            }
                        }
                        self.orderNotificationTask(order:aData,VC:controller)
                    }
                }
            }
//        }
    }
    
    func orderNotificationTask(order:OrderModel,VC:UIViewController){
        if (order.orderType ?? "").lowercased() == "dine in"{
            if VC is DineInTableVC{
                (VC as! DineInTableVC).FetchFloorList()
            }
            if VC is HomeViewController && AppCommonMethods.fetchSiteSettingValue(key: "home_theme") ?? "" == "theme2"{
                (VC as! HomeViewController).FetchFloorList()
            }
        }else{
            if VC is OrderListVC{
                (VC as! OrderListVC).checkForOrderType()
            }
            if VC is HomeViewController && AppCommonMethods.fetchSiteSettingValue(key: "home_theme") ?? "" == "theme2"{
                (VC as! HomeViewController).checkForOrderType()
            }
        }
        if VC is CreateOrderVC{
            (VC as! CreateOrderVC).fetchOrderFromDB(notificationId: order.id)
        }
        if VC is OrderReviewVC{
            (VC as! OrderReviewVC).fetchOrderFromDB(notificationId: order.id ?? 0)
        }
    }
    
    func CallSetOrderStatusAPI(id:Int, prepTime:String, strType:String){
        var dictParam = [String:Any]()
        dictParam["preparation"] = prepTime
        let strURL = "\(AppConstants.APIURL.kOnlineOrder)\(id)/change-status"
        dictParam["status"] = "Accepted"
        WebServiceManager().requestAPI(params: dictParam,  urlString: strURL, method: "POST",isRestaurantAPI: true) { (message, result) in
            DispatchQueue.main.async {
                if var VC = UIApplication.topViewController(){
                    if let sheetVC = VC as? SheetViewController{
                        sheetVC.dismiss(animated: true) {
                            
                        }
                        if let controller = UIApplication.topViewController(controller: sheetVC.presentingViewController){
                            VC = controller
                        }
                    }
                    if let controller = VC as? SideMenuVC{
                        if let _ = OrderDetailVC.addToParentView(parentVC: controller, orderId: id, orderType: strType){
                        }
                    }else{
                        if let sideVC = SideMenuVC.instance(){
                            let navc = UINavigationController.init(rootViewController: sideVC)
                            navc.isNavigationBarHidden = true
                            AppConstants.appDelegate.window?.rootViewController = navc
                            DispatchQueue.main.asyncAfter(deadline: .now()+0.1) {
                                if let _ = OrderDetailVC.addToParentView(parentVC: sideVC, orderId: id, orderType: strType){
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    
    
    func CallSetBookingStatusAPI(id:Int){
        var dictParam = [String:Any]()
        dictParam["status"] = "Approved"
        WebServiceManager().requestAPI(params: dictParam, urlString: "\(AppConstants.APIURL.kOnlineReservation)\(id)/change-status", method: "POST", isRestaurantAPI: true) { (message, result) in
            DispatchQueue.main.async {
                if var VC = UIApplication.topViewController(){
                    if let sheetVC = VC as? SheetViewController{
                        if let controller = UIApplication.topViewController(controller: sheetVC.presentingViewController){
                            VC = controller
                        }
                    }
                    if let sideController = VC as? SideMenuVC, let lastVC = sideController.children.last{
                        VC = lastVC
                    }
                    if VC is ReservationListVC{
                        (VC as! ReservationListVC).CallGetReservationListAPI()
                    }
                }
            }
        }
    }
    
}

extension AppDelegate:UNUserNotificationCenterDelegate{
    func userNotificationCenter(_ center: UNUserNotificationCenter, willPresent notification: UNNotification, withCompletionHandler completionHandler: @escaping (UNNotificationPresentationOptions) -> Void){
        var orderId:Int?
        
        if let data = notification.request.content.userInfo as? [String : Any]{
            print("userInfo:",data)
            if AppConstants.userData == nil{
                return
            }
            if let transactionId = data["transaction_id"] as? String, transactionId != ""{
                if let id = data["order_id"] as? Int{
                    orderId = id
                }else if let id = data["order_id"] as? String{
                    orderId = Int(id)
                }
                var amount:Double?
                if let id = data["amount"] as? Double{
                    amount = id
                }else if let id = data["amount"] as? String{
                    amount = Double(id)
                }
                if orderId != nil && amount != nil{
                    self.CallPaymentAPI(amount: amount!, txnId: transactionId, orderId: orderId!)
                    return
                }
            }
            if let strType = data["notification_for"] as? String, strType == "epos" && AppConstants.DataSyncMode != "Auto"{
                if let strFor = data["notification_section"] as? String{
                    if var VC = UIApplication.topViewController(){
                        if let sheetVC = VC as? SheetViewController{
                            if let controller = UIApplication.topViewController(controller: sheetVC.presentingViewController){
                                VC = controller
                            }
                        }
                        if let sideController = VC as? SideMenuVC, let lastVC = sideController.children.last{
                            VC = lastVC
                        }
                        var Ids:Int?
                        if let id = data["order_id"] as? Int{
                            Ids = id
                        }else if let id = data["order_id"] as? String{
                            Ids = Int(id)
                        }
                        if strFor == "orders"{
                            var shouldPrint = false
                            if let print = data["print"] as? Int, print == 1, AppConstants.DataSyncMode == "Auto"{
                                shouldPrint = true
                            }
                            if Ids != nil{
                                self.FetchOrderDetail(id: Ids!, shouldPrint: shouldPrint, controller: VC)
                            }
                        }else if strFor == "tables"{
                            var Ids:Int?
                            if let id = data["table_id"] as? Int{
                                Ids = id
                            }else if let id = data["table_id"] as? String{
                                Ids = Int(id)
                            }
                            if let id = AppConstants.recentlyChangedTableId, id == Ids ?? 0{
                                AppConstants.recentlyChangedTableId = nil
                                return
                            }
                            AppConstants.recentlyChangedTableId = nil
                            if VC is DineInTableVC{
                                if Ids != nil{
                                    (VC as! DineInTableVC).FetchTableDetail(tableId: Ids!)
                                }
                            }
                            if VC is HomeViewController && AppCommonMethods.fetchSiteSettingValue(key: "home_theme") ?? "" == "theme2"{
                                if Ids != nil{
                                    (VC as! HomeViewController).FetchTableDetail(tableId: Ids!)
                                }
                            }
                        }
                    }
                }
                completionHandler([])
                return
            }
            if let aps = data["aps"] as? [String:Any], let payload = aps["alert"] as? [String:Any], let strType = payload["title"] as? String{
                if strType == "booking"{
                    var Ids:Int?
                    var autoAccept = false
                    if let id = data["auto_accept"] as? Int{
                        autoAccept = id == 1
                    }else if let id = data["auto_accept"] as? Bool{
                        autoAccept = id
                    }
                    if let id = data["booking_id"] as? Int{
                        Ids = id
                    }else if let id = data["booking_id"] as? String{
                        Ids = Int(id)
                    }
                    if autoAccept && Ids != nil{
                        self.CallSetBookingStatusAPI(id: Ids!)
                    }
                    BadgeManager.shared?.stopLastAPICall()
                }
                if strType.lowercased() == "neworder" && AppConstants.DataSyncMode != "Auto"{
                    if let id = data["order_id"] as? Int{
                        orderId = id
                    }else if let id = data["order_id"] as? String{
                        orderId = Int(id)
                    }
                    if orderId != nil{
                        CustomAudioPlayer.prepareOrderPlayer()
                    }
                    if var VC = UIApplication.topViewController(){
                        if let sheetVC = VC as? SheetViewController{
                            if let controller = UIApplication.topViewController(controller: sheetVC.presentingViewController){
                                VC = controller
                            }
                        }
                        if let sideController = VC as? SideMenuVC, let lastVC = sideController.children.last{
                            VC = lastVC
                        }
                        if VC is OrderListVC{
                            (VC as! OrderListVC).GetOnlineOrders()
                        }
                        if orderId != nil{
                            self.CallGetOrderDetailAPI(orderId: orderId!, orderType: strType)
                        }
                    }
                }
                if strType == "Payment"{
                    var amount:Double?
                    if let price = data["amount"] as? Double{
                        amount = price
                    }else if let price = data["amount"] as? String{
                        amount = Double(price)
                    }
                    if let id = data["transaction_id"] as? String, let amount{
                        if let sideVC = UIApplication.topViewController() as? SideMenuVC{
                            if let lastVC = sideVC.children.last as? PaymentMainVC {
                                if let VC = lastVC.children.last as? QRPaymentVC {
                                    VC.PaymentLinkSuccessAlert(paymentId: id, amount: amount)
                                }
                                if let VC = lastVC.children.last as? PaymentLinksVC {
                                    VC.PaymentLinkSuccessAlert(paymentId: id, amount: amount)
                                }
                            }
                        }
                    }
                }
            }
        }
        if orderId == nil{
            completionHandler([.badge, .sound])
        }else{
            completionHandler([.badge])
        }
    }
    
    func performEPOSNotificationTask(_ data:[String:Any]){
        
    }
    
    func userNotificationCenter(_ center: UNUserNotificationCenter, didReceive response: UNNotificationResponse, withCompletionHandler completionHandler: @escaping () -> Void) {
        if let data = response.notification.request.content.userInfo as? [String : AnyObject] {
            if AppConstants.userData == nil{
                return
            }
            print("userInfo:",data)
            if let payload = data["payload"] as? [String:Any], let strType = payload["type"] as? String, AppConstants.DataSyncMode != "Auto"{
                if var VC = UIApplication.topViewController(){
                    var Ids:Int?
                    if let id = data["order_id"] as? Int{
                        Ids = id
                    }else if let id = data["order_id"] as? String{
                        Ids = Int(id)
                    }
                    if let sheetVC = VC as? SheetViewController{
                        sheetVC.dismiss(animated: true) {
                            
                        }
                        if let controller = UIApplication.topViewController(controller: sheetVC.presentingViewController){
                            VC = controller
                        }
                    }
                    if strType == "order"{
                        if Ids != nil{
                            if let time = data["preparation_time"] as? String, time != ""{
                                self.CallSetOrderStatusAPI(id: Ids!, prepTime: time, strType: strType)
                            }else{
                                if let controller = VC as? SideMenuVC{
                                    if let _ = OrderDetailVC.addToParentView(parentVC: controller, orderId: Ids ?? 0, orderType: strType){
                                    }
                                }else{
                                    if let sideVC = SideMenuVC.instance(){
                                        AppConstants.appDelegate.window?.rootViewController = sideVC
                                        DispatchQueue.main.asyncAfter(deadline: .now()+0.1) {
                                            if let _ = OrderDetailVC.addToParentView(parentVC: sideVC, orderId: Ids ?? 0, orderType: strType){
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        BadgeManager.shared?.stopLastAPICall()
                    }
                }
            }
        }
    }
}

extension AppDelegate:MessagingDelegate{
    func messaging(_ messaging: Messaging, didReceiveRegistrationToken fcmToken: String?) {
        let dataDict: [String: String] = ["token": fcmToken ?? ""]
        AppCommonMethods.saveDataIntoUserDefault(value: fcmToken ?? "", withKey: AppConstants.userDefaultKey.kFCMToken)
        NotificationCenter.default.post(name: Notification.Name("FCMToken"), object: nil, userInfo: dataDict)
    }
}

class UBSIDICheckProviderFactory: NSObject, AppCheckProviderFactory {
    func createProvider(with app: FirebaseApp) -> AppCheckProvider? {
        if #available(iOS 14.0, *) {
            return AppAttestProvider(app: app)
        } else {
            return DeviceCheckProvider(app: app)
        }
    }
}
